/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Position;

public class Watermark
implements ImageFilter {
    private final Position position;
    private final BufferedImage watermarkImg;
    private final float opacity;

    public Watermark(Position position, BufferedImage watermarkImg, float opacity) {
        if (position == null) {
            throw new NullPointerException("Position is null.");
        }
        if (watermarkImg == null) {
            throw new NullPointerException("Watermark image is null.");
        }
        if (opacity > 1.0f || opacity < 0.0f) {
            throw new IllegalArgumentException("Opacity is out of range of between 0.0f and 1.0f.");
        }
        this.position = position;
        this.watermarkImg = watermarkImg;
        this.opacity = opacity;
    }

    @Override
    public BufferedImage apply(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int type = img.getType();
        BufferedImage imgWithWatermark = new BufferedImageBuilder(width, height, type).build();
        int watermarkWidth = this.watermarkImg.getWidth();
        int watermarkHeight = this.watermarkImg.getHeight();
        Point p = this.position.calculate(width, height, watermarkWidth, watermarkHeight, 0, 0, 0, 0);
        Graphics2D g = imgWithWatermark.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.setComposite(AlphaComposite.getInstance(3, this.opacity));
        g.drawImage((Image)this.watermarkImg, p.x, p.y, null);
        g.dispose();
        return imgWithWatermark;
    }
}

