/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.resizers;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Map;
import net.coobird.thumbnailator.resizers.AbstractResizer;

public class ProgressiveBilinearResizer
extends AbstractResizer {
    public ProgressiveBilinearResizer() {
        this(Collections.emptyMap());
    }

    public ProgressiveBilinearResizer(Map<RenderingHints.Key, Object> hints) {
        super(RenderingHints.VALUE_INTERPOLATION_BILINEAR, hints);
    }

    @Override
    public void resize(BufferedImage srcImage, BufferedImage destImage) throws NullPointerException {
        super.performChecks(srcImage, destImage);
        int currentWidth = srcImage.getWidth();
        int currentHeight = srcImage.getHeight();
        int targetWidth = destImage.getWidth();
        int targetHeight = destImage.getHeight();
        if (targetWidth * 2 >= currentWidth && targetHeight * 2 >= currentHeight) {
            Graphics2D g = destImage.createGraphics();
            g.drawImage(srcImage, 0, 0, targetWidth, targetHeight, null);
            g.dispose();
            return;
        }
        BufferedImage tempImage = new BufferedImage(currentWidth, currentHeight, destImage.getType());
        Graphics2D g = tempImage.createGraphics();
        g.setRenderingHints(this.RENDERING_HINTS);
        g.setComposite(AlphaComposite.Src);
        int startWidth = targetWidth;
        int startHeight = targetHeight;
        while (startWidth < currentWidth && startHeight < currentHeight) {
            startWidth *= 2;
            startHeight *= 2;
        }
        currentWidth = startWidth / 2;
        currentHeight = startHeight / 2;
        g.drawImage(srcImage, 0, 0, currentWidth, currentHeight, null);
        while (currentWidth >= targetWidth * 2 && currentHeight >= targetHeight * 2) {
            currentHeight /= 2;
            if ((currentWidth /= 2) < targetWidth) {
                currentWidth = targetWidth;
            }
            if (currentHeight < targetHeight) {
                currentHeight = targetHeight;
            }
            g.drawImage(tempImage, 0, 0, currentWidth, currentHeight, 0, 0, currentWidth * 2, currentHeight * 2, null);
        }
        g.dispose();
        Graphics2D destg = destImage.createGraphics();
        destg.drawImage(tempImage, 0, 0, targetWidth, targetHeight, 0, 0, currentWidth, currentHeight, null);
        destg.dispose();
    }
}

