/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSink;
import net.coobird.thumbnailator.util.BufferedImages;
import net.coobird.thumbnailator.util.ThumbnailatorUtils;

public class OutputStreamImageSink
extends AbstractImageSink<OutputStream> {
    private final OutputStream os;

    public OutputStreamImageSink(OutputStream os) {
        if (os == null) {
            throw new NullPointerException("OutputStream cannot be null.");
        }
        this.os = os;
    }

    @Override
    public void write(BufferedImage img) throws IOException {
        ImageOutputStream ios;
        super.write(img);
        if (this.outputFormat == null) {
            throw new IllegalStateException("Output format has not been set.");
        }
        String formatName = this.outputFormat;
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(formatName);
        if (!writers.hasNext()) {
            throw new UnsupportedFormatException(formatName, "No suitable ImageWriter found for " + formatName + ".");
        }
        ImageWriter writer = writers.next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        if (writeParam.canWriteCompressed() && this.param != null) {
            writeParam.setCompressionMode(2);
            if (this.param.getOutputFormatType() != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
                writeParam.setCompressionType(this.param.getOutputFormatType());
            } else {
                List<String> supportedFormats = ThumbnailatorUtils.getSupportedOutputFormatTypes(formatName);
                if (!supportedFormats.isEmpty()) {
                    writeParam.setCompressionType(supportedFormats.get(0));
                }
            }
            if (!Float.isNaN(this.param.getOutputQuality())) {
                writeParam.setCompressionQuality(this.param.getOutputQuality());
            }
        }
        if ((ios = ImageIO.createImageOutputStream(this.os)) == null) {
            throw new IOException("Could not open OutputStream.");
        }
        if (formatName.equalsIgnoreCase("jpg") || formatName.equalsIgnoreCase("jpeg") || formatName.equalsIgnoreCase("bmp")) {
            img = BufferedImages.copy(img, 1);
        }
        writer.setOutput(ios);
        writer.write(null, new IIOImage(img, null, null), writeParam);
        writer.dispose();
        ios.close();
    }

    @Override
    public OutputStream getSink() {
        return this.os;
    }
}

