/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.util.exif;

import net.coobird.thumbnailator.util.exif.IfdType;

public class IfdStructure {
    private final int tag;
    private final IfdType type;
    private final int count;
    private final int offsetValue;

    public IfdStructure(int tag, int type, int count, int offsetValue) {
        this.tag = tag;
        this.type = IfdType.typeOf(type);
        this.count = count;
        this.offsetValue = offsetValue;
    }

    public int getTag() {
        return this.tag;
    }

    public IfdType getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public int getOffsetValue() {
        return this.offsetValue;
    }

    public boolean isValue() {
        return this.type.size() * this.count <= 4;
    }

    public boolean isOffset() {
        return !this.isValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + this.offsetValue;
        result = 31 * result + this.tag;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IfdStructure other = (IfdStructure)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.offsetValue != other.offsetValue) {
            return false;
        }
        if (this.tag != other.tag) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "IfdStructure [tag=" + Integer.toHexString(this.tag) + ", type=" + (Object)((Object)this.type) + ", count=" + this.count + ", offsetValue=" + this.offsetValue + "]";
    }
}

