/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.common.http;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.HttpMethod;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class HttpParamers {
    private Map<String, String> params = new HashMap<String, String>();
    private Map<String, FileItem> files = new HashMap<String, FileItem>();
    private Map<String, List<FileItem>> listFiles = new HashMap<String, List<FileItem>>();
    private HttpMethod httpMethod;

    public HttpParamers(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public static HttpParamers httpPostParamers() {
        return new HttpParamers(HttpMethod.POST);
    }

    public static HttpParamers httpGetParamers() {
        return new HttpParamers(HttpMethod.GET);
    }

    public HttpParamers addParam(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public HttpParamers addFile(String name, FileItem file) {
        this.files.put(name, file);
        return this;
    }

    public HttpParamers addListFiles(String name, List<FileItem> fileItems) {
        this.listFiles.put(name, fileItems);
        return this;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getQueryString(String charset) throws IOException {
        if (this.params == null || this.params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = this.params.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.isNoneEmpty(name, value = entry.getValue())) continue;
            query.append("&");
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.substring(1);
    }

    public boolean isMultipart() {
        return !this.files.isEmpty() || !this.listFiles.isEmpty();
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, FileItem> getFiles() {
        return this.files;
    }

    public Map<String, List<FileItem>> getListFiles() {
        return this.listFiles;
    }

    public String toString() {
        return "HttpParamers " + JSONUtils.toJson(this);
    }
}

