/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.CategoryService;
import net.qiyuesuo.sdk.bean.contract.Category;
import net.qiyuesuo.sdk.bean.contract.CategoryGroup;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.utils.CollectionUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class CategoryServiceImpl
implements CategoryService {
    private SDKClient client;

    public CategoryServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public List<Category> categoryList(Long companyId, String companyName) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (companyId != null) {
            paramers.addParam("companyId", companyId.toString());
        }
        if (StringUtils.isNotBlank(companyName)) {
            paramers.addParam("companyName", companyName);
        }
        if ((code = (Integer)(result = this.client.doService("/contract/categories", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u5206\u7c7b\u5217\u8868\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        List categoriesList = (List)result.get("categories");
        ArrayList<Category> categories = new ArrayList<Category>();
        try {
            for (Map categoriesMap : categoriesList) {
                String id = (String)categoriesMap.get("id");
                String name = (String)categoriesMap.get("name");
                Integer state = (Integer)categoriesMap.get("state");
                String tenantId = (String)categoriesMap.get("tenantId");
                String tenantName = (String)categoriesMap.get("tenantName");
                Category category = new Category();
                category.setId(Long.valueOf(id));
                category.setName(name);
                category.setState(state);
                category.setTenantId(Long.valueOf(tenantId));
                if (tenantName != null) {
                    category.setTenantName(tenantName);
                }
                categories.add(category);
            }
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return categories;
    }

    @Override
    public List<CategoryGroup> categoryGroups(CategoryGroup condition) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (condition.getCompanyId() != null) {
            paramers.addParam("companyId", condition.getCompanyId().toString());
        }
        if (StringUtils.isNotBlank(condition.getCompanyName())) {
            paramers.addParam("companyName", condition.getCompanyName());
        }
        if (StringUtils.isNotBlank(condition.getName())) {
            paramers.addParam("groupName", condition.getName());
        }
        if ((code = (Integer)(result = this.client.doService("/contract/categorygroup", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u4e1a\u52a1\u5206\u7c7b\u5206\u7ec4\u5217\u8868\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        ArrayList<CategoryGroup> categoryGroupList = new ArrayList<CategoryGroup>();
        List groups = (List)result.get("result");
        if (CollectionUtils.isEmpty(groups)) {
            return categoryGroupList;
        }
        for (Map groupMap : groups) {
            CategoryGroup categoryGroup = new CategoryGroup(groupMap);
            List categories = (List)groupMap.get("categoryList");
            ArrayList<Category> categoryList = new ArrayList<Category>();
            if (CollectionUtils.isNotEmpty(categories)) {
                for (Map categoryMap : categories) {
                    categoryList.add(new Category(categoryMap));
                }
                categoryGroup.setCategoryList(categoryList);
            }
            categoryGroupList.add(categoryGroup);
        }
        return categoryGroupList;
    }

    @Override
    public Category deatil(Category condition) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (condition.getId() != null) {
            paramers.addParam("categoryId", String.valueOf(condition.getId()));
        }
        paramers.addParam("categoryName", condition.getName());
        Map<String, Object> result = this.client.doService("/contract/categorydetail", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u4e1a\u52a1\u5206\u7c7b\u8be6\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map categoryMap = (Map)result.get("result");
        Category category = null;
        try {
            category = MapUtils.toObject(categoryMap, Category.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return category;
    }
}

