/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.CompanyService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.company.CompanyAuthNoticeRequset;
import net.qiyuesuo.sdk.bean.company.CompanyRequest;
import net.qiyuesuo.sdk.bean.company.CreateCompanyRequest;
import net.qiyuesuo.sdk.bean.company.TenantStatus;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.sealapply.MapUtil;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class CompanyServiceImpl
implements CompanyService {
    private SDKClient client;

    public CompanyServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String createCompany(CreateCompanyRequest request) throws Exception {
        request.valid();
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        paramers.addFile("license", request.getLicense());
        paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("legalPerson", request.getLegalPerson());
        paramers.addParam("legalPersonId", request.getLegalPersonId());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("operator", request.getOperator());
        paramers.addParam("paperType", request.getPaperType());
        paramers.addParam("province", request.getProvince());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("tenantType", request.getTenantType().name());
        Map<String, Object> result = this.client.doService("/company/create", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u521b\u5efa\u4f01\u4e1a\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("result");
    }

    @Override
    public String getComnpanyAuthStatus(String companyName) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("companyName", companyName);
        Map<String, Object> result = this.client.doService("/company/status", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u4f01\u4e1a\u8ba4\u8bc1\u72b6\u6001\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("result");
    }

    @Override
    public List<Company> queryList(TenantType tenantType) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (tenantType != null) {
            paramers.addParam("tenantType", tenantType.toString());
        }
        if ((code = (Integer)(result = this.client.doService("/company/list", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u516c\u53f8\u5217\u8868\u5931\u8d25," + (String)result.get("message"));
        }
        ArrayList<Company> companies = new ArrayList<Company>();
        if (result.get("result") != null) {
            List companyList = (List)result.get("result");
            for (Map companyMap : companyList) {
                Company company = new Company();
                company.setId(Long.valueOf((String)companyMap.get("id")));
                company.setName((String)companyMap.get("name"));
                if (companyMap.get("status") != null) {
                    company.setStatus(TenantStatus.valueOf((String)companyMap.get("status")));
                }
                if (companyMap.get("tenantType") != null) {
                    company.setTenantType(TenantType.valueOf((String)companyMap.get("tenantType")));
                }
                if (companyMap.get("parentId") != null) {
                    company.setParentId(Long.valueOf((String)companyMap.get("parentId")));
                }
                companies.add(company);
            }
        }
        return companies;
    }

    @Override
    public Company detail(CompanyRequest request) throws Exception {
        Map<String, Object> result;
        Integer code;
        if (request == null) {
            return null;
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        if (StringUtils.isNotBlank(request.getCompanyName())) {
            paramers.addParam("companyName", request.getCompanyName());
        }
        if (StringUtils.isNotBlank(request.getRegisterNo())) {
            paramers.addParam("registerNo", request.getRegisterNo());
        }
        if ((code = (Integer)(result = this.client.doService("/company/detail", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u516c\u53f8\u8be6\u60c5\u5931\u8d25," + (String)result.get("message"));
        }
        Map companyMap = (Map)result.get("result");
        Company company = new Company();
        if (companyMap != null) {
            company.setId(MapUtil.getLong(companyMap, "id"));
            company.setName(MapUtil.getString(companyMap, "name"));
            company.setRegisterNo(MapUtil.getString(companyMap, "registerNo"));
            company.setTenantType(TenantType.valueOf(MapUtil.getString(companyMap, "tenantType")));
            company.setCreateTime(MapUtil.getDate(companyMap, "createTime"));
            company.setStatus(TenantStatus.valueOf(MapUtil.getString(companyMap, "status")));
            company.setLegalPerson(MapUtil.getString(companyMap, "legalPerson"));
            company.setLegalPersonId(MapUtil.getString(companyMap, "legalPersonId"));
            company.setParentId(MapUtil.getLong(companyMap, "parentId"));
        }
        return company;
    }

    @Override
    public void sendCompanyAuthNotice(CompanyAuthNoticeRequset requset) throws Exception {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", requset.getName());
        paramers.addParam("registerNo", requset.getRegisterNo());
        paramers.addParam("charger", requset.getCharger());
        paramers.addParam("mobile", requset.getMobile());
        Map<String, Object> result = this.client.doService("/companyauth/notice", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u521b\u5efa\u5e76\u53d1\u9001\u5916\u90e8\u516c\u53f8\u4f01\u4e1a\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25," + (String)result.get("message"));
        }
    }
}

