/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.PrintService;
import net.qiyuesuo.sdk.bean.contract.Document;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;

public class PrintServiceImpl
implements PrintService {
    private SDKClient client;

    public PrintServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String getEntiFakePrintUrl(Long contractId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/efprinturl", paramers);
        String efPrintUrl = (String)result.get("printUrl");
        return efPrintUrl;
    }

    @Override
    public void setPrintCount(Long contractId, int count) throws Exception {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        paramers.addParam("count", String.valueOf(count));
        this.client.doService("/contract/setprintcount", paramers);
    }

    @Override
    public int getPrintCount(Long contractId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/getprintcount", paramers);
        int count = (Integer)result.get("printCount");
        return count;
    }

    @Override
    public void setDocumentPrintCount(List<Document> documents) throws Exception {
        this.client.doServiceWithJson("/document/setprintcount", JSONUtils.toJson(documents));
    }

    @Override
    public int getDocumentPrintCount(Long documentId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("documentId", String.valueOf(documentId));
        Map<String, Object> result = this.client.doService("/document/getprintcount", paramers);
        int count = (Integer)result.get("printCount");
        return count;
    }
}

