/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk;

import java.io.OutputStream;
import java.util.Map;
import net.qiyuesuo.sdk.common.Version;
import net.qiyuesuo.sdk.common.crypt.MD5;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpClient;
import net.qiyuesuo.sdk.common.http.HttpHeader;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONObject;

public class SDKClient {
    private int connectTimeout = 30000;
    private int readTimeout = 120000;
    private String serviceUrl;
    private String accessToken;
    private String accessSecret;

    public SDKClient(String serviceUrl, String accessToken, String accessSecret) {
        this.serviceUrl = serviceUrl;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
    }

    public Map<String, Object> doService(String requestUrl, HttpParamers paramers) throws PrivateAppException {
        String url = this.serviceUrl + requestUrl;
        HttpHeader header = this.buildHttpHeader();
        String response = null;
        try {
            response = HttpClient.doService(url, paramers, header, this.connectTimeout, this.readTimeout);
        }
        catch (Exception e) {
            throw new PrivateAppException(e);
        }
        return this.handleHttpResponse(response);
    }

    public String checkService(String requestUrl, HttpParamers paramers) throws PrivateAppException {
        String url = this.serviceUrl + requestUrl;
        HttpHeader header = this.buildHttpHeader();
        String response = null;
        try {
            response = HttpClient.doService(url, paramers, header, this.connectTimeout, this.readTimeout);
        }
        catch (Exception e) {
            throw new PrivateAppException(e);
        }
        return response;
    }

    public Map<String, Object> doServiceWithJson(String requestUrl, String json) throws PrivateAppException {
        System.out.println("\u8bf7\u6c42\u7684json\uff1a" + json);
        String url = this.serviceUrl + requestUrl;
        HttpHeader header = this.buildHttpHeader();
        String response = null;
        try {
            response = HttpClient.doServiceWithJson(url, json, header, this.connectTimeout, this.readTimeout);
        }
        catch (Exception e) {
            throw new PrivateAppException(e);
        }
        return this.handleHttpResponse(response);
    }

    private HttpHeader buildHttpHeader() {
        Long timestamp = System.currentTimeMillis();
        String signature = MD5.toMD5(this.accessToken + this.accessSecret + timestamp);
        return new HttpHeader(this.accessToken, timestamp, signature);
    }

    private Map<String, Object> handleHttpResponse(String response) throws PrivateAppException {
        JSONObject jsonObject = new JSONObject(response);
        Map<String, Object> result = jsonObject.toMap();
        if (result == null || result.isEmpty()) {
            throw new PrivateAppException("\u8fdc\u7a0b\u670d\u52a1\u8fd4\u56de\u7684\u6570\u636e\u65e0\u6cd5\u89e3\u6790");
        }
        Integer code = (Integer)result.get("code");
        if (code == null || code != 0) {
            throw new PrivateAppException(code, (String)result.get("message"));
        }
        return result;
    }

    public void download(String requestUrl, HttpParamers paramers, OutputStream outputStream) throws PrivateAppException {
        String url = this.serviceUrl + requestUrl;
        Long timestamp = System.currentTimeMillis();
        String signature = MD5.toMD5(this.accessToken + this.accessSecret + Long.toString(timestamp));
        HttpHeader header = new HttpHeader(this.accessToken, timestamp, signature);
        try {
            HttpClient.doDownload(url, paramers, header, this.connectTimeout, this.readTimeout, outputStream);
        }
        catch (Exception e) {
            throw new PrivateAppException(e.getMessage(), e);
        }
    }

    public String getVersionInfo() {
        return Version.touch();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void reset(String serviceUrl, String accessToken, String accessSecret) {
        this.serviceUrl = serviceUrl;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
    }
}

