/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.bean.contract;

import java.io.Serializable;
import java.util.HashMap;
import net.qiyuesuo.sdk.bean.contract.BackgroundShape;
import net.qiyuesuo.sdk.bean.contract.TileDensity;
import net.qiyuesuo.sdk.bean.contract.WaterMarkLocation;
import net.qiyuesuo.sdk.bean.contract.WaterMarkType;

public class WaterMarkContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long documentId;
    private WaterMarkType type;
    private String content;
    private byte[] imageBytes;
    private String imageBase64;
    private Integer fontSize;
    private Double transparency;
    private String color;
    private WaterMarkLocation location;
    private TileDensity density;
    private Double rotateAngle;
    private Double scaling;
    private BackgroundShape backgroundShape;

    public WaterMarkContent() {
    }

    public WaterMarkContent(String content, Integer fontSize, WaterMarkLocation location) {
        this.content = content;
        this.fontSize = fontSize;
        this.location = location;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
    }

    public WaterMarkType getType() {
        return this.type;
    }

    public void setType(WaterMarkType type) {
        this.type = type;
    }

    public WaterMarkLocation getLocation() {
        return this.location;
    }

    public void setLocation(WaterMarkLocation location) {
        this.location = location;
    }

    public TileDensity getDensity() {
        return this.density;
    }

    public void setDensity(TileDensity density) {
        this.density = density;
    }

    public Double getRotateAngle() {
        return this.rotateAngle;
    }

    public void setRotateAngle(Double rotateAngle) {
        this.rotateAngle = rotateAngle;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public Double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Double transparency) {
        this.transparency = transparency;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Double getScaling() {
        return this.scaling;
    }

    public void setScaling(Double scaling) {
        this.scaling = scaling;
    }

    public BackgroundShape getBackgroundShape() {
        return this.backgroundShape;
    }

    public void setBackgroundShape(BackgroundShape backgroundShape) {
        this.backgroundShape = backgroundShape;
    }

    public String getImageBase64() {
        return this.imageBase64;
    }

    public void setImageBase64(String imageBase64) {
        this.imageBase64 = imageBase64;
    }

    public HashMap<String, Object> toHashMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.type.name());
        map.put("content", this.content);
        map.put("imageBytes", this.imageBytes);
        map.put("fontSize", this.fontSize);
        map.put("transparency", this.transparency);
        map.put("color", this.color);
        map.put("location", this.location.name());
        map.put("density", TileDensity.SUITABLE.getDensity());
        if (WaterMarkType.NO == this.type) {
            map.put("density", this.density.getDensity());
        }
        map.put("rotateAngle", this.rotateAngle);
        map.put("scaling", this.scaling);
        if (this.backgroundShape != null) {
            switch (this.backgroundShape) {
                case SQUARE_5: {
                    map.put("width", 5);
                    map.put("height", 5);
                    break;
                }
                case SQUARE_10: {
                    map.put("width", 10);
                    map.put("height", 10);
                    break;
                }
                case SQUARE_20: {
                    map.put("width", 20);
                    map.put("height", 20);
                    break;
                }
                case RECTANGLE_5_10: {
                    map.put("width", 5);
                    map.put("height", 10);
                    break;
                }
                case RECTANGLE_10_20: {
                    map.put("width", 10);
                    map.put("height", 20);
                    break;
                }
            }
        }
        return map;
    }
}

