/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.bean.template;

public enum MimeType {
    pdf("application/pdf"),
    xlsx("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
    pptx("application/vnd.openxmlformats-officedocument.presentationml.presentation"),
    docx("application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
    doc("application/msword"),
    xls("application/vnd.ms-excel"),
    ppt("application/vnd.ms-powerpoint"),
    png("image/png"),
    webp("image/webp"),
    tiff("image/tiff"),
    xml("application/xml"),
    xht("application/xhtml+xml"),
    xhtml("application/xhtml+xml"),
    htm("text/html"),
    html("text/html"),
    txt("text/plain"),
    jpe("image/jpeg"),
    jpg("image/jpeg"),
    jpeg("image/jpeg"),
    gif("image/gif"),
    zip("application/zip");

    private String mimetype;

    private MimeType(String mimetype) {
        this.mimetype = mimetype;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public static MimeType getByFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int extIndex = fileName.lastIndexOf(".");
        if (extIndex > 0 && extIndex + 1 < fileName.length()) {
            String ext = fileName.substring(extIndex + 1).toLowerCase();
            try {
                return MimeType.valueOf(ext);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

