/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.common.utils.TimeUtils;

public class MapUtils {
    public static <T> T toObject(Map<String, Object> map, Class<T> beanClass) throws Exception {
        T bean = null;
        try {
            bean = beanClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (map == null || map.isEmpty()) {
            return bean;
        }
        for (String methodName : map.keySet()) {
            Field[] fields;
            Object value = map.get(methodName);
            if (value == null) continue;
            Field beanField = null;
            for (Field field : fields = beanClass.getDeclaredFields()) {
                if (!field.getName().equals(methodName)) continue;
                beanField = field;
                break;
            }
            if (beanField == null) continue;
            String methodType = beanField.getType().getName();
            if (beanField.getType().isAssignableFrom(String.class)) {
                value = value.toString();
            } else if (beanField.getType().isAssignableFrom(Long.class)) {
                value = Long.parseLong(value.toString());
            } else if (beanField.getType().isAssignableFrom(Integer.class)) {
                value = Integer.parseInt(value.toString());
            } else if (beanField.getType().isAssignableFrom(Float.class)) {
                value = Float.valueOf(Float.parseFloat(value.toString()));
            } else if (beanField.getType().isAssignableFrom(Double.class)) {
                value = Double.parseDouble(value.toString());
            } else if (beanField.getType().isAssignableFrom(Boolean.class)) {
                value = Boolean.parseBoolean(value.toString());
            } else if (beanField.getType().isAssignableFrom(Date.class)) {
                value = TimeUtils.parse(value.toString());
            } else if (beanField.getType().isEnum()) {
                value = MapUtils.convertToEnum(methodType, value);
            } else if (beanField.getType().isAssignableFrom(List.class)) {
                String className = beanField.getGenericType().toString();
                className = className.replaceAll("java.util.List", "");
                className = className.replaceAll("<", "");
                className = className.replaceAll(">", "");
                Class<?> tempClass = Class.forName(className);
                ArrayList objects = new ArrayList();
                if (value != null) {
                    List maps = (List)value;
                    for (Map tempMap : maps) {
                        Object object = MapUtils.toObject(tempMap, tempClass);
                        objects.add(object);
                    }
                }
                value = objects;
            } else {
                Class<?> tempClass = beanField.getType();
                Map tempMap = (Map)value;
                value = MapUtils.toObject(tempMap, tempClass);
            }
            try {
                String methodName1 = "set" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                Method method = beanClass.getMethod(methodName1, beanField.getType());
                method.invoke(bean, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bean;
    }

    private static Enum convertToEnum(String enumName, Object value) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(enumName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            Enum myE = (Enum)value;
            return myE;
        }
        return Enum.valueOf(clazz, value.toString());
    }

    public static <T> List<T> toObjectList(List<Map<String, Object>> maps, Class<T> beanClass) throws Exception {
        if (maps == null || maps.size() < 0) {
            return null;
        }
        ArrayList<T> beanList = new ArrayList<T>();
        for (Map<String, Object> tempMap : maps) {
            T bean = MapUtils.toObject(tempMap, beanClass);
            beanList.add(bean);
        }
        return beanList;
    }
}

