/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.Action;
import net.qiyuesuo.sdk.bean.contract.ActionStatus;
import net.qiyuesuo.sdk.bean.contract.ActionType;
import net.qiyuesuo.sdk.bean.contract.AddDocumentByFile;
import net.qiyuesuo.sdk.bean.contract.AddDocumentByTemplate;
import net.qiyuesuo.sdk.bean.contract.ContractDetail;
import net.qiyuesuo.sdk.bean.contract.ContractFinish;
import net.qiyuesuo.sdk.bean.contract.ContractListRequest;
import net.qiyuesuo.sdk.bean.contract.ContractListResponse;
import net.qiyuesuo.sdk.bean.contract.ContractOperationLog;
import net.qiyuesuo.sdk.bean.contract.ContractPerminssionBean;
import net.qiyuesuo.sdk.bean.contract.CreateContractByTemplateIdsRequest;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.Document;
import net.qiyuesuo.sdk.bean.contract.DocumentParam;
import net.qiyuesuo.sdk.bean.contract.DocumentParams;
import net.qiyuesuo.sdk.bean.contract.FinishContractRequest;
import net.qiyuesuo.sdk.bean.contract.SendContractRequest;
import net.qiyuesuo.sdk.bean.contract.StamperType;
import net.qiyuesuo.sdk.bean.contract.ViewUrlRequest;
import net.qiyuesuo.sdk.bean.contract.WaterMarkContent;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentResult;
import net.qiyuesuo.sdk.bean.document.DocumentFillParam;
import net.qiyuesuo.sdk.bean.sign.FillParamRequest;
import net.qiyuesuo.sdk.bean.sign.PreSignUrlRequest;
import net.qiyuesuo.sdk.bean.sign.SignUrlRequest;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.bean.sign.SignatoryRect;
import net.qiyuesuo.sdk.bean.sign.SignatoryStatus;
import net.qiyuesuo.sdk.bean.transmit.ContractTransmit;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.CollectionUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;

public class ContractServiceImpl
implements ContractService {
    private SDKClient client;

    public ContractServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public Long createDocument(InputStream inputStream, String title) throws Exception {
        return this.createDocument(inputStream, title, null);
    }

    @Override
    public Long createDocument(InputStream inputStream, String title, List<WaterMarkContent> waterMarks) throws Exception {
        Map<String, Object> result;
        Integer code;
        if (StringUtils.isEmpty(title)) {
            throw new Exception("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inputStream == null) {
            throw new Exception("\u6587\u4ef6\u8f93\u5165\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(inputStream);
        paramers.addFile("file", fileItem);
        paramers.addParam("title", title);
        if (waterMarks != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(waterMarks));
        }
        if ((code = (Integer)(result = this.client.doService("/document/createbyfile", paramers)).get("code")) != 0) {
            throw new Exception("\u521b\u5efa\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public CreateDocumentResult createByFile(CreateDocumentRequest request) throws PrivateAppException {
        int serverVersion;
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addFile("file", request.getFile());
        paramers.addParam("fileType", request.getFileType());
        paramers.addParam("title", request.getTitle());
        if (request.getWaterMarkConfig() != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(request.getWaterMarkConfig()));
        }
        if ((code = (Integer)(result = (serverVersion = this.getServerVersion()) >= StringUtils.getVersion("3.9.0") ? this.client.doService("/v2/document/createbyfile", paramers) : this.client.doService("/document/createbyfile", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u521b\u5efa\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = null;
        if (serverVersion >= StringUtils.getVersion("3.9.0")) {
            Map document = (Map)result.get("result");
            if (document == null) {
                return null;
            }
            documentId = Long.valueOf((String)document.get("documentId"));
        } else {
            documentId = Long.valueOf((String)result.get("documentId"));
        }
        CreateDocumentResult createResult = new CreateDocumentResult();
        createResult.setDocumentId(documentId);
        return createResult;
    }

    private int getServerVersion() throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        Map<String, Object> result = this.client.doService("/version/info", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u670d\u52a1\u5668\u7248\u672c\u53f7\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        String serverVersionStr = (String)result.get("result");
        if (StringUtils.isBlank(serverVersionStr)) {
            throw new PrivateAppException("\u670d\u52a1\u5668\u7248\u672c\u53f7\u4e3a\u7a7a");
        }
        return StringUtils.getVersion(serverVersionStr);
    }

    @Override
    public void addWatermark(WaterMarkContent waterMarkContent) throws PrivateAppException {
        if (waterMarkContent == null) {
            throw new PrivateAppException("\u6c34\u5370\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (waterMarkContent.getDocumentId() == null) {
            throw new PrivateAppException("documentId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (waterMarkContent.getContent() == null && waterMarkContent.getImageBytes().length == 0) {
            throw new PrivateAppException("\u6c34\u5370\u5185\u5bb9\u6216\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> result = this.client.doServiceWithJson("/document/addwatermark", JSONUtils.toJson(waterMarkContent));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u6dfb\u52a0\u6c34\u5370\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public Long createDocument(List<InputStream> inputStreams, String title) throws Exception {
        return this.createDocument(inputStreams, title, null);
    }

    @Override
    public Long createDocument(List<InputStream> inputStreams, String title, List<WaterMarkContent> waterMarks) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        for (InputStream inputStream : inputStreams) {
            StreamFile fileItem = new StreamFile(inputStream);
            fileItems.add(fileItem);
        }
        paramers.addListFiles("files", fileItems);
        paramers.addParam("title", title);
        if (waterMarks != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(waterMarks));
        }
        if ((code = (Integer)(result = this.client.doService("/document/createbyfiles", paramers)).get("code")) != 0) {
            throw new Exception("\u521b\u5efa\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return Long.valueOf((String)result.get("documentId"));
    }

    @Override
    public Long createDocument(Long templateId, Map<String, String> params, String title) throws Exception {
        return this.createDocument(templateId, params, title, null);
    }

    @Override
    public Long createDocument(Long templateId, Map<String, String> params, String title, List<WaterMarkContent> waterMarks) throws Exception {
        Map<String, Object> result;
        Integer code;
        if (templateId == null) {
            throw new Exception("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("templateId", templateId.toString());
        paramers.addParam("title", title);
        if (params != null && !params.isEmpty()) {
            String json = JSONUtils.toJson(params);
            paramers.addParam("params", json);
        }
        if (waterMarks != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(waterMarks));
        }
        if ((code = (Integer)(result = this.client.doService("/document/createbytemplate", paramers)).get("code")) != 0) {
            throw new Exception("\u521b\u5efa\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long createDocumentByLocalFile(String filePath, String title) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("filePath", filePath);
        paramers.addParam("title", title);
        Map<String, Object> result = this.client.doService("/document/createbylocalfile", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u521b\u5efa\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long createDocumentByUrl(String url, String title) throws PrivateAppException {
        return this.createDocumentByUrl(url, title, null);
    }

    @Override
    public Long createDocumentByUrl(String url, String title, List<WaterMarkContent> waterMarks) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("url", url);
        paramers.addParam("title", title);
        if (waterMarks != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(waterMarks));
        }
        if ((code = (Integer)(result = this.client.doService("/document/createbyurl", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u521b\u5efa\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long createSponsorDocumentByFile(InputStream inputStream, String title) throws Exception {
        if (StringUtils.isEmpty(title)) {
            throw new Exception("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inputStream == null) {
            throw new Exception("\u6587\u4ef6\u8f93\u5165\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(inputStream);
        paramers.addFile("file", fileItem);
        paramers.addParam("title", title);
        Map<String, Object> result = this.client.doService("/document/createsponsorfile", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u521b\u5efa\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long addDocumentByFile(AddDocumentByFile request) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(request.getFile());
        paramers.addFile("file", fileItem);
        paramers.addParam("title", request.getTitle());
        if (request.getWaterMarkConfig() != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(request.getWaterMarkConfig()));
        }
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        if ((code = (Integer)(result = this.client.doService("/document/addbyfile", paramers)).get("code")) != 0) {
            throw new Exception("\u6dfb\u52a0\u9644\u4ef6\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long addDocumentByTemplate(AddDocumentByTemplate request) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("title", request.getTitle());
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        if (request.getTemplateId() != null) {
            paramers.addParam("templateId", request.getTemplateId().toString());
        }
        if (request.getParams() != null && !request.getParams().isEmpty()) {
            paramers.addParam("params", JSONUtils.toJson(request.getParams()));
        }
        if (request.getWaterMarkConfig() != null) {
            paramers.addParam("waterMarks", JSONUtils.toJson(request.getWaterMarkConfig()));
        }
        if ((code = (Integer)(result = this.client.doService("/document/addbytemplate", paramers)).get("code")) != 0) {
            throw new Exception("\u6dfb\u52a0\u5408\u540c\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public Long addSponsorDocumentByFile(AddDocumentByFile request) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(request.getFile());
        paramers.addFile("file", fileItem);
        paramers.addParam("title", request.getTitle());
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        if ((code = (Integer)(result = this.client.doService("/document/addsponsorfile", paramers)).get("code")) != 0) {
            throw new Exception("\u6dfb\u52a0\u9644\u4ef6\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public void addAttachment(InputStream attachment, Long documentId, String title, String description) throws Exception {
        if (attachment == null) {
            throw new Exception("\u6587\u4ef6\u8f93\u5165\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (documentId == null) {
            throw new Exception("\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(title)) {
            throw new Exception("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(attachment);
        paramers.addFile("attachment", fileItem);
        paramers.addParam("documentId", String.valueOf(documentId));
        paramers.addParam("title", title);
        paramers.addParam("description", description);
        Map<String, Object> result = this.client.doService("/document/addattachment", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u6dfb\u52a0\u9644\u4ef6\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public Long createContract(CreateContractRequest request) throws Exception {
        request.valid();
        Map<String, Object> result = this.client.doServiceWithJson("/contract/create", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u521b\u5efa\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long contractId = Long.valueOf((String)result.get("contractId"));
        return contractId;
    }

    @Override
    public Long createContractByCategory(CreateContractRequest request) throws Exception {
        request.valid();
        Map<String, Object> result = this.client.doServiceWithJson("/contract/createbycategory", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u521b\u5efa\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long contractId = Long.valueOf((String)result.get("contractId"));
        return contractId;
    }

    @Override
    public Long editContract(CreateContractRequest request) throws Exception {
        request.valid();
        Map<String, Object> result = this.client.doServiceWithJson("/contract/createRetainParams", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u521b\u5efa\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long contractId = Long.valueOf((String)result.get("contractId"));
        return contractId;
    }

    @Override
    public void send(SendContractRequest request) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/send", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u53d1\u8d77\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void complete(Long contractId) throws Exception {
        if (contractId == null) {
            throw new Exception("\u672a\u6307\u5b9a\u5408\u540cID");
        }
        FinishContractRequest request = new FinishContractRequest();
        request.setContractId(contractId);
        Map<String, Object> result = this.client.doServiceWithJson("/contract/finish", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u5c01\u5b58\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public ContractDetail detail(Long contractId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/detail", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u67e5\u8be2\u5408\u540c\u8be6\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map contractMap = (Map)result.get("contract");
        ContractDetail detail = new ContractDetail();
        try {
            detail = new ContractDetail(contractMap);
            if (contractMap.get("documents") != null) {
                List documentList = (List)contractMap.get("documents");
                ArrayList<Document> documents = new ArrayList<Document>();
                for (Map documentMap : documentList) {
                    Document document = new Document();
                    document.setId(Long.valueOf((String)documentMap.get("id")));
                    document.setTitle((String)documentMap.get("title"));
                    document.setPages((Integer)documentMap.get("pages"));
                    document.setSize(Long.valueOf((String)documentMap.get("size")));
                    document.setCreateTime(TimeUtils.parse((String)contractMap.get("createTime")));
                    document.setAntifakeCode((String)documentMap.get("antifakeCode"));
                    if (documentMap.get("params") != null) {
                        List paramList = (List)documentMap.get("params");
                        ArrayList<DocumentParam> params = new ArrayList<DocumentParam>();
                        for (Map param : paramList) {
                            params.add(new DocumentParam(param));
                        }
                        document.setParams(params);
                    }
                    documents.add(document);
                }
                detail.setDocuments(documents.isEmpty() ? null : documents);
            }
            if (contractMap.get("signatories") != null) {
                List signatorieList = (List)contractMap.get("signatories");
                ArrayList<Signatory> signatories = new ArrayList<Signatory>();
                for (Map signatorieMap : signatorieList) {
                    Long id = Long.valueOf((String)signatorieMap.get("id"));
                    String type = (String)signatorieMap.get("tenantType");
                    Boolean sponsor = (Boolean)signatorieMap.get("sponsor");
                    String tenantName = (String)signatorieMap.get("tenantName");
                    String receiverType = (String)signatorieMap.get("receiverType");
                    String receiverName = (String)signatorieMap.get("receiverName");
                    String contact = (String)signatorieMap.get("contact");
                    Integer serialNo = (Integer)signatorieMap.get("serialNo");
                    SignatoryStatus status = SignatoryStatus.valueOf((String)signatorieMap.get("status"));
                    List actionList = (List)signatorieMap.get("actions");
                    ArrayList<Action> actions = new ArrayList<Action>();
                    if (CollectionUtils.isNotEmpty(actionList)) {
                        for (Map map : actionList) {
                            Long actionId = Long.valueOf((String)map.get("id"));
                            ActionType actionType = ActionType.valueOf((String)map.get("type"));
                            Integer actionSerialNo = (Integer)map.get("serialNo");
                            String actionName = (String)map.get("name");
                            String sealIds = (String)map.get("sealIds");
                            ActionStatus actionStatus = ActionStatus.valueOf((String)map.get("status"));
                            Action action = new Action(actionType, actionSerialNo);
                            if (sealIds != null && sealIds.length() > 0) {
                                String[] sealIdArr;
                                sealIds = sealIds.replace("[", "").replace("]", "");
                                for (String sealid : sealIdArr = sealIds.split(",")) {
                                    if (!StringUtils.isNotBlank(sealid)) continue;
                                    action.addSealId(Long.parseLong(sealid.trim()));
                                }
                            }
                            action.setId(actionId);
                            action.setStatus(actionStatus);
                            action.setName(actionName);
                            actions.add(action);
                        }
                    }
                    Signatory signatory = new Signatory();
                    signatory.setId(id);
                    signatory.setTenantType(type == null ? null : TenantType.valueOf(type));
                    signatory.setTenantName(tenantName);
                    signatory.setReceiverType(receiverType == null ? null : TenantType.valueOf(receiverType));
                    signatory.setReceiverName(receiverName);
                    signatory.setContact(contact);
                    signatory.setSerialNo(serialNo);
                    signatory.setStatus(status);
                    signatory.setActions(actions);
                    signatory.setSponsor(sponsor);
                    signatories.add(signatory);
                }
                detail.setSignatories(signatories);
            }
        }
        catch (Exception e) {
            throw new Exception("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return detail;
    }

    @Override
    public void download(Long contractId, OutputStream outputStream) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        this.client.download("/contract/download", paramers, outputStream);
    }

    @Override
    public void downloadDoc(Long documentId, OutputStream outputStream) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("documentId", String.valueOf(documentId));
        this.client.download("/document/download", paramers, outputStream);
    }

    @Override
    public void downloadImgDoc(Long documentId, OutputStream outputStream) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("documentId", String.valueOf(documentId));
        this.client.download("/document/download/imgdoc", paramers, outputStream);
    }

    @Override
    public Long createDocument(String html, String title) throws Exception {
        if (StringUtils.isBlank(title)) {
            throw new Exception("title\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(html)) {
            throw new Exception("html\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("html", html);
        paramers.addParam("title", title);
        Map<String, Object> result = this.client.doService("/document/createbyhtml", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u521b\u5efa\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Long documentId = Long.valueOf((String)result.get("documentId"));
        return documentId;
    }

    @Override
    public void cencelContract(Long contractId, Long sealId, String reason, Boolean removeContract) throws Exception {
        Map<String, Object> result;
        Integer code;
        if (contractId == null) {
            throw new Exception("contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (sealId == null) {
            throw new Exception("sealId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        paramers.addParam("sealId", String.valueOf(sealId));
        if (StringUtils.isNotBlank(reason)) {
            paramers.addParam("reason", reason);
        }
        if (removeContract != null) {
            paramers.addParam("removeContract", removeContract.toString());
        }
        if ((code = (Integer)(result = this.client.doService("/contract/cancel", paramers)).get("code")) != 0) {
            throw new Exception("\u521b\u5efa\u6587\u6863\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void recallContract(Long contractId, String reason) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        if (contractId == null) {
            throw new PrivateAppException("contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        if (StringUtils.isNotBlank(reason)) {
            paramers.addParam("reason", reason);
        }
        if ((code = (Integer)(result = this.client.doService("/contract/recall", paramers)).get("code")) != 0) {
            throw new PrivateAppException(code, "message:\u64a4\u56de\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public String viewUrl(Long contractId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/viewurl", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u67e5\u770b\u94fe\u63a5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        String viewUrl = (String)result.get("viewUrl");
        return viewUrl;
    }

    @Override
    public String viewUrl(ViewUrlRequest request) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(request.getContractId()));
        if (request.getExpireTime() != null) {
            paramers.addParam("expireTime", String.valueOf(request.getExpireTime()));
        }
        if (request.getPageType() != null) {
            paramers.addParam("pageType", request.getPageType().name());
        }
        if ((code = (Integer)(result = this.client.doService("/contract/viewurl", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u67e5\u770b\u94fe\u63a5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        String viewUrl = (String)result.get("viewUrl");
        return viewUrl;
    }

    @Override
    public String preSignUrl(Long contractId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/presignurl", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u7b7e\u7f72\u94fe\u63a5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("presignUrl");
    }

    @Override
    public String preSignUrl(PreSignUrlRequest request) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(request.getContractId()));
        if (request.getCanSetStamper() != null) {
            paramers.addParam("canSetStamper", request.getCanSetStamper().toString());
        }
        if (request.getCanSetParam() != null) {
            paramers.addParam("canSetParam", request.getCanSetParam().toString());
        }
        if (request.getCanSend() != null) {
            paramers.addParam("canSend", request.getCanSend().toString());
        }
        if (request.getCanSaveOrClose() != null) {
            paramers.addParam("canSaveOrClose", request.getCanSaveOrClose().toString());
        }
        if (request.getLanguage() != null) {
            paramers.addParam("language", request.getLanguage().toString());
        }
        if ((code = (Integer)(result = this.client.doService("/contract/presignurl", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u7b7e\u7f72\u94fe\u63a5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("presignUrl");
    }

    @Override
    public void downloadFaceEvidenceFile(Long contractId, OutputStream outputStream) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        this.client.download("/contract/face/download/zip", paramers, outputStream);
    }

    @Override
    public List<Signatory> queryLocations(Long contractId) throws Exception {
        if (contractId == null) {
            throw new Exception("contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/query/location", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u7b7e\u7f72\u4f4d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        ArrayList<Signatory> signatories = new ArrayList<Signatory>();
        if (result.get("result") != null) {
            List sigs = (List)result.get("result");
            for (Map map : sigs) {
                Signatory sig = new Signatory();
                sig.setTenantName((String)map.get("tenantName"));
                sig.setTenantType(TenantType.valueOf((String)map.get("tenantType")));
                sig.setReceiverType(TenantType.valueOf((String)map.get("receiverType")));
                sig.setReceiverName((String)map.get("receiverName"));
                sig.setSerialNo((Integer)map.get("serialNo"));
                sig.setStatus(SignatoryStatus.valueOf((String)map.get("status")));
                if (map.get("locations") != null) {
                    List tempLocations = (List)map.get("locations");
                    ArrayList<SignatoryRect> locations = new ArrayList<SignatoryRect>();
                    for (Map tempLoaction : tempLocations) {
                        SignatoryRect location = new SignatoryRect();
                        location.setSignatoryId(Long.valueOf((String)tempLoaction.get("signatoryId")));
                        location.setDocumentId((String)tempLoaction.get("documentId") != null ? Long.valueOf((String)tempLoaction.get("documentId")) : null);
                        location.setRectType(StamperType.valueOf((String)tempLoaction.get("rectType")));
                        location.setPage((Integer)tempLoaction.get("page"));
                        location.setWidth((Double)tempLoaction.get("width"));
                        location.setHeight((Double)tempLoaction.get("height"));
                        location.setOffsetX((Double)tempLoaction.get("offsetX"));
                        location.setOffsetY((Double)tempLoaction.get("offsetY"));
                        location.setKeyword((String)tempLoaction.get("keyword"));
                        locations.add(location);
                    }
                    sig.setLocations(locations);
                }
                signatories.add(sig);
            }
        }
        return signatories;
    }

    @Override
    public String signUrl(SignUrlRequest request) throws Exception {
        request.valid();
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signurl", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u7b7e\u7f72\u94fe\u63a5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        String signUrl = (String)result.get("signUrl");
        return signUrl;
    }

    @Override
    public void forceFinish(ContractFinish contractFinish) throws Exception {
        contractFinish.validate();
        Map<String, Object> result = this.client.doServiceWithJson("/contract/finish/force", JSONUtils.toJson(contractFinish));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u5f3a\u5236\u7ed3\u675f\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public ContractFinish forceFinishAddAttachement(Long contractId, String attachment) throws Exception {
        if (contractId == null) {
            throw new Exception("\u8bf7\u8f93\u5165\u5408\u540cid");
        }
        if (StringUtils.isBlank(attachment)) {
            throw new Exception("\u8bf7\u8f93\u5165\u9644\u4ef6\u4fe1\u606f");
        }
        HttpParamers params = HttpParamers.httpPostParamers();
        params.addParam("contractId", String.valueOf(contractId));
        params.addParam("attachment", attachment);
        Map<String, Object> result = this.client.doService("/contract/finish/addattachment", params);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u6dfb\u52a0\u9644\u4ef6\u5931\u8d25," + (String)result.get("message"));
        }
        ContractFinish finish = new ContractFinish();
        if (result.get("result") != null) {
            Map record = (Map)result.get("result");
            finish.setAttachment((String)record.get("attachement"));
            finish.setCompanyName((String)record.get("companyName"));
            finish.setContractId(Long.valueOf((String)record.get("contractId")));
            finish.setFinishReason((String)record.get("finishReason"));
            finish.setUserName((String)record.get("userName"));
        }
        return finish;
    }

    @Override
    public void press(Long actionId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("actionId", String.valueOf(actionId));
        Map<String, Object> result = this.client.doService("/contract/press/operator", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u50ac\u7b7e\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void pressOperator(Long signatoryId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("signatoryId", String.valueOf(signatoryId));
        Map<String, Object> result = this.client.doService("/contract/press/operator", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u50ac\u7b7e\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public ContractListResponse list(ContractListRequest request) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        if (StringUtils.isNotBlank(request.getCompanyName())) {
            paramers.addParam("companyName", String.valueOf(request.getCompanyName()));
        }
        if (request.getSelectOffset() != null) {
            paramers.addParam("selectOffset", String.valueOf(request.getSelectOffset()));
        }
        if (request.getSelectLimit() != null) {
            paramers.addParam("selectLimit", String.valueOf(request.getSelectLimit()));
        }
        if (request.getOrderMode() != null) {
            paramers.addParam("orderMode", String.valueOf(request.getOrderMode()));
        }
        if ((code = (Integer)(result = this.client.doService("/contract/list", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u5408\u540c\u5217\u8868\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map resultMap = (Map)result.get("result");
        ContractListResponse response = new ContractListResponse();
        if (resultMap != null) {
            response.setTotalCount(((Integer)resultMap.get("totalCount")).intValue());
            List contractList = (List)resultMap.get("contractList");
            if (CollectionUtils.isNotEmpty(contractList)) {
                ArrayList<ContractDetail> contracts = new ArrayList<ContractDetail>();
                for (Map contractMap : contractList) {
                    ContractDetail contract = new ContractDetail(contractMap);
                    contracts.add(contract);
                }
                response.setContractList(contracts);
            }
        }
        return response;
    }

    @Override
    public void notify(Long contractId) throws Exception {
        if (contractId == null) {
            throw new Exception("\u8bf7\u8f93\u5165\u5408\u540cid");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/notify", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u5408\u540c\u50ac\u7b7e\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void batchDownload(List<Long> contractIds, OutputStream outputStream) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (CollectionUtils.isNotEmpty(contractIds)) {
            String contractIdsStr = "";
            for (int i = 0; i < contractIds.size(); ++i) {
                Long contractId = contractIds.get(i);
                if (contractId == null) continue;
                if (i != 0) {
                    contractIdsStr = contractIdsStr + ",";
                }
                contractIdsStr = contractIdsStr + contractId;
            }
            paramers.addParam("contractIds", contractIdsStr);
        }
        this.client.download("/contract/batchdowload", paramers, outputStream);
    }

    @Override
    public void delete(Long contractId) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (contractId != null) {
            paramers.addParam("contractId", String.valueOf(contractId));
        }
        if ((code = (Integer)(result = this.client.doService("/contract/delete", paramers)).get("code")) != 0) {
            throw new Exception("\u8349\u7a3f\u5408\u540c\u5220\u9664\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void fillParam(FillParamRequest request) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/fillparam", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u5408\u540c\u586b\u53c2\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public Long createContractByTemplateIds(CreateContractByTemplateIdsRequest request) throws Exception {
        if (request == null) {
            throw new Exception("\u53c2\u6570:CreateContractByTemplateIdsRequest \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(request.getTemplateIds())) {
            throw new Exception("\u53c2\u6570:templateIds \u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean titleEffective = false;
        if (CollectionUtils.isNotEmpty(request.getTitles()) && request.getTitles().size() == request.getTemplateIds().size()) {
            titleEffective = true;
        }
        int titleIndex = 0;
        ArrayList<Long> documentIds = new ArrayList<Long>();
        for (Long templateId : request.getTemplateIds()) {
            Long documentId = this.createDocument(templateId, request.getParams(), titleEffective ? request.getTitles().get(titleIndex) : request.getSubject(), null);
            documentIds.add(documentId);
            ++titleIndex;
        }
        CreateContractRequest contractRequest = new CreateContractRequest();
        contractRequest.setSubject(request.getSubject());
        contractRequest.setDocuments(documentIds);
        contractRequest.setSend(request.getSend());
        return this.createContract(contractRequest);
    }

    @Override
    public Long editCrontractByTemplateIds(CreateContractByTemplateIdsRequest request) throws Exception {
        if (request == null) {
            throw new Exception("\u53c2\u6570:CreateContractByTemplateIdsRequest \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(request.getTemplateIds())) {
            throw new Exception("\u53c2\u6570:templateIds \u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean titleEffective = false;
        if (CollectionUtils.isNotEmpty(request.getTitles()) && request.getTitles().size() == request.getTemplateIds().size()) {
            titleEffective = true;
        }
        int titleIndex = 0;
        ArrayList<Long> documentIds = new ArrayList<Long>();
        for (Long templateId : request.getTemplateIds()) {
            Long documentId = this.createDocument(templateId, request.getParams(), titleEffective ? request.getTitles().get(titleIndex) : request.getSubject(), null);
            documentIds.add(documentId);
            ++titleIndex;
        }
        CreateContractRequest contractRequest = new CreateContractRequest();
        contractRequest.setSubject(request.getSubject());
        contractRequest.setDocuments(documentIds);
        contractRequest.setSend(request.getSend());
        contractRequest.setId(request.getContractId());
        return this.editContract(contractRequest);
    }

    @Override
    public List<ContractOperationLog> queryOperationLog(ContractOperationLog condition) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (condition.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(condition.getContractId()));
        }
        paramers.addParam("operation", condition.getOperation());
        paramers.addParam("operatorContact", condition.getOperatorContact());
        Map<String, Object> result = this.client.doService("/contract/operationlog", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u5408\u540c\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        List contractOperationLogMaps = (List)result.get("result");
        ArrayList<ContractOperationLog> contractOperationLogs = new ArrayList();
        try {
            contractOperationLogs = MapUtils.toObjectList(contractOperationLogMaps, ContractOperationLog.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return contractOperationLogs;
    }

    @Override
    public void addTransmitter(ContractTransmit transmitter) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/transmit", JSONUtils.toJson(transmitter));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u6dfb\u52a0\u6284\u9001\u4eba\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public DocumentParams documentParams(Long contractId, String bizId) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (contractId == null && StringUtils.isEmpty(bizId)) {
            throw new PrivateAppException("contractId\u6216BizId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (contractId != null) {
            paramers.addParam("contractId", String.valueOf(contractId));
        }
        if (bizId != null) {
            paramers.addParam("bizId", bizId);
        }
        if ((code = (Integer)(result = this.client.doService("/contract/documentparams", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u67e5\u8be2\u5408\u540c\u586b\u53c2\u60c5\u51b5\u5931\u8d25" + (String)result.get("message"));
        }
        DocumentParams documentParams = new DocumentParams();
        try {
            documentParams = MapUtils.toObject(result, DocumentParams.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return documentParams;
    }

    @Override
    public ContractPerminssionBean queryPermission(ContractPerminssionBean request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getContractId() != null) {
            paramers.addParam("contractId", String.valueOf(request.getContractId()));
        }
        paramers.addParam("bizId", request.getBizId());
        paramers.addParam("contact", request.getContact());
        Map<String, Object> result = this.client.doService("/contract/permission", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u7528\u6237\u5408\u540c\u6743\u9650\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        ContractPerminssionBean contractPermission = null;
        Map contractPermissionMap = (Map)result.get("result");
        try {
            contractPermission = MapUtils.toObject(contractPermissionMap, ContractPerminssionBean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return contractPermission;
    }

    @Override
    public void contractEndTime(Long contractId, String endTime) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (contractId != null) {
            paramers.addParam("contractId", String.valueOf(contractId));
        }
        paramers.addParam("endTime", endTime);
        Map<String, Object> result = this.client.doService("/contract/endtime", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u8bbe\u7f6e\u5408\u540c\u7ec8\u6b62\u65f6\u95f4\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void fillParams(DocumentFillParam request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/fillparams", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u5408\u540c\u586b\u53c2\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }
}

