/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.InputStream;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.DataSignService;
import net.qiyuesuo.sdk.bean.sign.QueryDataRequest;
import net.qiyuesuo.sdk.bean.sign.VerifyResult;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class DataSignServiceImpl
implements DataSignService {
    private SDKClient client;

    public DataSignServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String sign(InputStream data, String bizId, String user, String cardNo, String contact) throws Exception {
        if (data == null) {
            throw new Exception("data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new Exception("bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(data);
        paramers.addFile("file", fileItem);
        paramers.addParam("businessId", bizId);
        paramers.addParam("userName", user);
        if (StringUtils.isNotBlank(cardNo)) {
            paramers.addParam("cardNo", cardNo);
        }
        paramers.addParam("contact", contact);
        Map<String, Object> result = this.client.doService("/datasign/sign", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u540d\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("result");
    }

    @Override
    public String viewUrl(String bizId) throws Exception {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new Exception("bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", bizId);
        Map<String, Object> result = this.client.doService("/datasign/viewurl", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u540d\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("viewUrl");
    }

    @Override
    public String getSrcData(String bizId) throws Exception {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new Exception("bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", bizId);
        Map<String, Object> result = this.client.doService("/datasign/getsrcdata", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        return (String)result.get("data");
    }

    @Override
    public VerifyResult getSrcAndCert(String bizId) throws Exception {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new Exception("bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", bizId);
        Map<String, Object> result = this.client.doService("/datasign/getsrcandcert", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        Map verifyMap = (Map)result.get("verifyinfo");
        VerifyResult verifyinfo = new VerifyResult();
        verifyinfo.setCertDateFrom((String)verifyMap.get("certDateFrom"));
        verifyinfo.setCertDateTo((String)verifyMap.get("certDateTo"));
        verifyinfo.setCode(code);
        verifyinfo.setMsg((String)verifyMap.get("msg"));
        verifyinfo.setOrganization((String)verifyMap.get("organization"));
        verifyinfo.setSerialNumber((String)verifyMap.get("serialNumber"));
        verifyinfo.setSignatory((String)verifyMap.get("signatory"));
        verifyinfo.setSignDate((String)verifyMap.get("signDate"));
        verifyinfo.setSignResult((String)verifyMap.get("signResult"));
        verifyinfo.setSignTime((String)verifyMap.get("signTime"));
        verifyinfo.setSrcDate((String)verifyMap.get("srcDate"));
        verifyinfo.setStrAlgName((String)verifyMap.get("strAlgName"));
        return verifyinfo;
    }

    @Override
    public VerifyResult getSrcAndCert(QueryDataRequest queryDataRequest) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", queryDataRequest.getBizId());
        if (queryDataRequest.getSensitiveInfoInvisible() != null) {
            paramers.addParam("sensitiveInfoInvisible", String.valueOf(queryDataRequest.getSensitiveInfoInvisible()));
        }
        if ((code = (Integer)(result = this.client.doService("/datasign/getsrcandcert", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        Map verifyMap = (Map)result.get("verifyinfo");
        VerifyResult verifyinfo = new VerifyResult(verifyMap);
        verifyinfo.setCode(code);
        return verifyinfo;
    }
}

