/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.SealApplyService;
import net.qiyuesuo.sdk.bean.seal.Seal;
import net.qiyuesuo.sdk.bean.sealapply.ApplyStatus;
import net.qiyuesuo.sdk.bean.sealapply.MapUtil;
import net.qiyuesuo.sdk.bean.sealapply.PhysicsImg;
import net.qiyuesuo.sdk.bean.sealapply.PhysicsPhotoType;
import net.qiyuesuo.sdk.bean.sealapply.SealAppend;
import net.qiyuesuo.sdk.bean.sealapply.SealApplyAppendRequest;
import net.qiyuesuo.sdk.bean.sealapply.SealApplyBean;
import net.qiyuesuo.sdk.bean.sealapply.SealApplyCompleteRequest;
import net.qiyuesuo.sdk.bean.sealapply.SealApplyImageRequest;
import net.qiyuesuo.sdk.bean.sealapply.SealApplyRequest;
import net.qiyuesuo.sdk.bean.sealapply.SealAuth;
import net.qiyuesuo.sdk.bean.sealapply.SealAuthUpdateTimeRequest;
import net.qiyuesuo.sdk.bean.sealapply.SealUsedFileUploadRequest;
import net.qiyuesuo.sdk.bean.sealapply.SealUsedImageUploadRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.json.JSONUtils;

public class SealApplyServiceImpl
implements SealApplyService {
    private SDKClient client;

    public SealApplyServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public SealApplyBean apply(SealApplyBean sealapply) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/seal/apply", JSONUtils.toJson(sealapply));
        Integer code = MapUtil.getInteger(result, "code");
        if (code == null || code != 0) {
            throw new PrivateAppException("\u7269\u7406\u7528\u5370\u7533\u8bf7\u5931\u8d25\uff0c" + MapUtil.getString(result, "message"));
        }
        SealApplyBean response = new SealApplyBean();
        Map map = (Map)result.get("result");
        response.setId(MapUtil.getLong(map, "id"));
        List sealAuthMap = (List)map.get("sealAuths");
        ArrayList<SealAuth> sealAuths = new ArrayList<SealAuth>();
        for (Map authMap : sealAuthMap) {
            sealAuths.add(new SealAuth(authMap));
        }
        response.setSealAuths(sealAuths);
        return response;
    }

    @Override
    public SealApplyBean append(Long businessId, Integer count, String contact, String number, String contactName) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("businessId", String.valueOf(businessId));
        paramers.addParam("count", String.valueOf(count));
        paramers.addParam("contact", contact);
        paramers.addParam("number", number);
        paramers.addParam("contactName", contactName);
        Map<String, Object> result = this.client.doService("/seal/apply/append", paramers);
        Integer code = MapUtil.getInteger(result, "code");
        if (code == null || code != 0) {
            throw new PrivateAppException("\u7269\u7406\u7528\u5370\u8ffd\u52a0\u5931\u8d25\uff0c" + MapUtil.getString(result, "message"));
        }
        SealApplyBean response = new SealApplyBean();
        Map map = (Map)result.get("result");
        response.setId(MapUtil.getLong(map, "id"));
        List sealAuthMap = (List)map.get("sealAuths");
        ArrayList<SealAuth> sealAuths = new ArrayList<SealAuth>();
        for (Map authMap : sealAuthMap) {
            SealAuth sealAuth = new SealAuth(authMap);
            sealAuths.add(sealAuth);
        }
        response.setSealAuths(sealAuths);
        return response;
    }

    @Override
    public void finish(Long businessId, String reason, String contact, String number, String contactName) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("businessId", String.valueOf(businessId));
        paramers.addParam("reason", reason);
        paramers.addParam("contact", contact);
        paramers.addParam("number", number);
        paramers.addParam("contactName", contactName);
        Map<String, Object> result = this.client.doService("/seal/apply/finish", paramers);
        Integer code = MapUtil.getInteger(result, "code");
        if (code == null || code != 0) {
            throw new PrivateAppException("\u7269\u7406\u7528\u5370\u5f3a\u5236\u7ed3\u675f\u7528\u5370\u5931\u8d25\uff0c" + MapUtil.getString(result, "message"));
        }
    }

    @Override
    public SealApplyBean detail(Long businessId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", String.valueOf(businessId));
        Map<String, Object> result = this.client.doService("/seal/apply/detail", paramers);
        Integer code = MapUtil.getInteger(result, "code");
        if (code == null || code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u7528\u5370\u8be6\u60c5\u5931\u8d25\uff0c" + MapUtil.getString(result, "message"));
        }
        Map map = (Map)result.get("result");
        SealApplyBean response = new SealApplyBean(map);
        List sealAuthMap = (List)map.get("sealAuths");
        ArrayList<SealAuth> sealAuths = new ArrayList<SealAuth>();
        if (sealAuthMap != null) {
            for (Map authMap : sealAuthMap) {
                sealAuths.add(new SealAuth(authMap));
            }
        }
        response.setSealAuths(sealAuths);
        ArrayList<PhysicsImg> faceImages = new ArrayList<PhysicsImg>();
        List faceImagesMap = (List)map.get("faceImages");
        if (faceImagesMap != null) {
            for (Map faceImageMap : faceImagesMap) {
                faceImages.add(new PhysicsImg(faceImageMap));
            }
        }
        response.setFaceImages(faceImages);
        ArrayList<PhysicsImg> useImages = new ArrayList<PhysicsImg>();
        List useImagesMap = (List)map.get("useImages");
        if (useImagesMap != null) {
            for (Map useImageMap : useImagesMap) {
                useImages.add(new PhysicsImg(useImageMap));
            }
        }
        response.setUseImages(useImages);
        List appendLogsMap = (List)map.get("appendLogs");
        ArrayList<SealAppend> SealAppends = new ArrayList<SealAppend>();
        if (appendLogsMap != null) {
            for (Map appendMap : appendLogsMap) {
                SealAppends.add(new SealAppend(appendMap));
            }
        }
        response.setAppendLogs(SealAppends);
        ArrayList<Seal> seals = new ArrayList<Seal>();
        List sealsMap = (List)map.get("seals");
        if (sealsMap != null) {
            for (Map sealmap : sealsMap) {
                seals.add(new Seal(sealmap));
            }
        }
        response.setSeals(seals);
        return response;
    }

    @Override
    public void imagesDownload(Long businessId, PhysicsPhotoType photoType, OutputStream outputStream) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", String.valueOf(businessId));
        if (photoType != null) {
            paramers.addParam("photoType", String.valueOf((Object)photoType));
        }
        this.client.download("/seal/apply/images/download", paramers, outputStream);
    }

    @Override
    public void image(String photokey, OutputStream outputStream) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("photokey", photokey);
        this.client.download("/seal/apply/image", paramers, outputStream);
    }

    @Override
    public SealApplyBean apply(SealApplyRequest sealapplyRequest) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/seal/apply/multiple", JSONUtils.toJson(sealapplyRequest));
        Integer code = MapUtil.getInteger(result, "code");
        if (code == null || code != 0) {
            throw new PrivateAppException("\u7269\u7406\u7528\u5370\u7533\u8bf7\u5931\u8d25\uff0c" + MapUtil.getString(result, "message"));
        }
        SealApplyBean response = new SealApplyBean();
        Map map = (Map)result.get("result");
        response.setId(MapUtil.getLong(map, "id"));
        List sealAuthMap = (List)map.get("sealAuths");
        ArrayList<SealAuth> sealAuths = new ArrayList<SealAuth>();
        if (sealAuthMap != null) {
            for (Map authMap : sealAuthMap) {
                sealAuths.add(new SealAuth(authMap));
            }
        }
        response.setSealAuths(sealAuths);
        if (map.get("status") != null) {
            ApplyStatus status = ApplyStatus.valueOf((String)map.get("status"));
            response.setStatus(status);
        }
        return response;
    }

    @Override
    public SealApplyBean applyByCategory(SealApplyRequest sealapplyRequest) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/seal/apply/mulitipleByCategory", JSONUtils.toJson(sealapplyRequest));
        Integer code = MapUtil.getInteger(result, "code");
        if (code == null || code != 0) {
            throw new PrivateAppException("\u7269\u7406\u7528\u5370\u7533\u8bf7\u5931\u8d25\uff0c" + MapUtil.getString(result, "message"));
        }
        SealApplyBean response = new SealApplyBean();
        Map map = (Map)result.get("result");
        response.setId(MapUtil.getLong(map, "id"));
        if (map.get("status") != null) {
            ApplyStatus status = ApplyStatus.valueOf((String)map.get("status"));
            response.setStatus(status);
            if (ApplyStatus.USING == status) {
                List sealAuthMap = (List)map.get("sealAuths");
                ArrayList<SealAuth> sealAuths = new ArrayList<SealAuth>();
                if (sealAuthMap != null) {
                    for (Map authMap : sealAuthMap) {
                        sealAuths.add(new SealAuth(authMap));
                        response.setSealAuths(sealAuths);
                    }
                }
            }
        }
        return response;
    }

    @Override
    public SealApplyBean append(SealApplyAppendRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("businessId", String.valueOf(request.getBusinessId()));
        paramers.addParam("count", String.valueOf(request.getCount()));
        paramers.addParam("contact", request.getContact());
        paramers.addParam("number", request.getNumber());
        paramers.addParam("contactName", request.getContactName());
        paramers.addParam("deviceNo", request.getDeviceNo());
        Map<String, Object> result = this.client.doService("/seal/apply/append", paramers);
        Integer code = MapUtil.getInteger(result, "code");
        if (code == null || code != 0) {
            throw new PrivateAppException("\u7269\u7406\u7528\u5370\u8ffd\u52a0\u5931\u8d25\uff0c" + MapUtil.getString(result, "message"));
        }
        SealApplyBean response = new SealApplyBean();
        Map map = (Map)result.get("result");
        response.setId(MapUtil.getLong(map, "id"));
        List sealAuthMap = (List)map.get("sealAuths");
        ArrayList<SealAuth> sealAuths = new ArrayList<SealAuth>();
        if (sealAuthMap != null) {
            for (Map authMap : sealAuthMap) {
                sealAuths.add(new SealAuth(authMap));
            }
        }
        response.setSealAuths(sealAuths);
        if (map.get("status") != null) {
            ApplyStatus status = ApplyStatus.valueOf((String)map.get("status"));
            response.setStatus(status);
        }
        return response;
    }

    @Override
    public void finish(SealApplyCompleteRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("businessId", String.valueOf(request.getBusinessId()));
        paramers.addParam("reason", request.getReason());
        paramers.addParam("deviceNo", request.getDeviceNo());
        paramers.addParam("contact", request.getContact());
        paramers.addParam("number", request.getNumber());
        paramers.addParam("contactName", request.getContactName());
        Map<String, Object> result = this.client.doService("/seal/apply/finish", paramers);
        Integer code = MapUtil.getInteger(result, "code");
        if (code == null || code != 0) {
            throw new PrivateAppException("\u7269\u7406\u7528\u5370\u5f3a\u5236\u7ed3\u675f\u5931\u8d25\uff0c" + MapUtil.getString(result, "message"));
        }
    }

    @Override
    public List<SealAuth> getOweAuths(String contact, String number) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contact", contact);
        paramers.addParam("number", number);
        Map<String, Object> response = this.client.doService("/seal/apply/owe/auths", paramers);
        Integer code = MapUtil.getInteger(response, "code");
        if (code == null || code != 0) {
            throw new PrivateAppException("\u6821\u9a8c\u5931\u8d25\uff0c" + MapUtil.getString(response, "message"));
        }
        List resultList = (List)response.get("result");
        ArrayList<SealAuth> sealAuths = new ArrayList<SealAuth>();
        if (resultList != null) {
            for (Map authMap : resultList) {
                sealAuths.add(new SealAuth(authMap));
            }
        }
        return sealAuths;
    }

    @Override
    public void upload(SealApplyImageRequest request) throws Exception {
        request.check();
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        HttpParamers paramers = HttpParamers.httpPostParamers();
        for (InputStream is : request.getStreams()) {
            StreamFile fileItem = new StreamFile(is);
            fileItems.add(fileItem);
        }
        paramers.addListFiles("images", fileItems);
        if (request.getType() != null) {
            paramers.addParam("type", request.getType().toString());
        }
        if (request.getSealAuthId() != null) {
            paramers.addParam("sealAuthId", String.valueOf(request.getSealAuthId()));
        } else {
            paramers.addParam("businessId", String.valueOf(request.getBusinessId()));
            if (request.getContact() != null) {
                paramers.addParam("contact", String.valueOf(request.getContact()));
            } else {
                paramers.addParam("number", String.valueOf(request.getNumber()));
            }
        }
        Map<String, Object> result = this.client.doService("/seal/apply/images", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u8865\u4f20\u7528\u5370\u56fe\u7247\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void sealUsedFileUpload(SealUsedFileUploadRequest request) throws Exception {
        request.check();
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addFile("file", request.getFile());
        paramers.addParam("businessId", String.valueOf(request.getBusinessId()));
        paramers.addParam("title", request.getTitle());
        Map<String, Object> result = this.client.doService("/seal/apply/used/file", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7528\u5370\u540e\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void sealUsedFileUpload(SealUsedImageUploadRequest request) throws Exception {
        request.check();
        HttpParamers paramers = HttpParamers.httpPostParamers();
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        for (StreamFile streamFile : request.getImages()) {
            fileItems.add(streamFile);
        }
        paramers.addListFiles("images", fileItems);
        paramers.addParam("businessId", String.valueOf(request.getBusinessId()));
        paramers.addParam("title", request.getTitle());
        Map<String, Object> result = this.client.doService("/seal/apply/used/images", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7528\u5370\u540e\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void updateUseSealTime(SealAuthUpdateTimeRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/seal/apply/updateUseSealTime", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u4fee\u6539\u7528\u5370\u65f6\u95f4\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }
}

