/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.SealService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.seal.Seal;
import net.qiyuesuo.sdk.bean.seal.SealCategory;
import net.qiyuesuo.sdk.bean.seal.SealCondition;
import net.qiyuesuo.sdk.bean.seal.SealRecord;
import net.qiyuesuo.sdk.bean.seal.SealRequest;
import net.qiyuesuo.sdk.bean.seal.SealType;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;

public class SealServiceImpl
implements SealService {
    private SDKClient client;

    public SealServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public Seal detail(Long sealId, String sealOtherName) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (sealId != null) {
            paramers.addParam("sealId", String.valueOf(sealId));
        }
        if (StringUtils.isNotBlank(sealOtherName)) {
            paramers.addParam("sealOtherName", sealOtherName);
        }
        if ((code = (Integer)(result = this.client.doService("/seal/detail", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u5370\u7ae0\u8be6\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map map = (Map)result.get("seal");
        if (map == null) {
            return null;
        }
        Seal seal = new Seal();
        try {
            seal.setCreateTime(TimeUtils.parse((String)map.get("createTime")));
            seal.setId(map.get("id") == null ? null : Long.valueOf((String)map.get("id")));
            seal.setName(String.valueOf(map.get("name")));
            seal.setOtherName(String.valueOf(map.get("otherName")));
            seal.setOwner(map.get("owner") == null ? null : Long.valueOf((String)map.get("owner")));
            seal.setSealKey(String.valueOf(map.get("sealKey")));
            seal.setSpec(String.valueOf(map.get("spec")));
            seal.setStatus(String.valueOf(map.get("status")));
            seal.setType(SealType.valueOf(String.valueOf(map.get("type"))));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return seal;
    }

    @Override
    public Seal detail(Long sealId) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (sealId != null) {
            paramers.addParam("sealId", String.valueOf(sealId));
        }
        if ((code = (Integer)(result = this.client.doService("/seal/detail", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u5370\u7ae0\u8be6\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map sealMap = (Map)result.get("seal");
        if (sealMap == null) {
            return null;
        }
        Seal seal = new Seal();
        try {
            seal = MapUtils.toObject(sealMap, Seal.class);
        }
        catch (ParseException e) {
            throw new Exception("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seal;
    }

    @Override
    public void image(Long sealId, String sealOtherName, OutputStream outputStream) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (sealId != null) {
            paramers.addParam("sealId", String.valueOf(sealId));
        }
        if (StringUtils.isNotBlank(sealOtherName)) {
            paramers.addParam("sealOtherName", sealOtherName);
        }
        this.client.download("/seal/image", paramers, outputStream);
    }

    @Override
    public void image(Seal request, OutputStream outputStream) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getId() != null) {
            paramers.addParam("sealId", String.valueOf(request.getId()));
        }
        this.client.download("/seal/image", paramers, outputStream);
    }

    @Override
    public List<SealRecord> sealRecord(SealRequest request) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getStartTime() != null) {
            paramers.addParam("startTime", TimeUtils.format(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            paramers.addParam("endTime", TimeUtils.format(request.getEndTime()));
        }
        paramers.addParam("companyName", request.getCompanyName());
        paramers.addParam("deviceNo", request.getDeviceNo());
        if (request.getCategory() != null) {
            paramers.addParam("category", request.getCategory().name());
        }
        if ((code = (Integer)(result = this.client.doService("/seal/records", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u5e73\u53f0\u5370\u7ae0\u7528\u5370\u8bb0\u5f55\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        ArrayList<SealRecord> newlist = new ArrayList<SealRecord>();
        try {
            List list = (List)result.get("result");
            if (list == null) {
                return null;
            }
            SealRecord sealRecord = null;
            for (Map tmap : list) {
                sealRecord = new SealRecord();
                sealRecord.setContractId(tmap.get("contractId") == null ? null : Long.valueOf((String)tmap.get("contractId")));
                sealRecord.setCreateTime(TimeUtils.parse((String)tmap.get("createTime")));
                sealRecord.setNumber((Integer)tmap.get("number"));
                sealRecord.setSealId(tmap.get("sealId") == null ? null : Long.valueOf((String)tmap.get("sealId")));
                sealRecord.setSealName((String)tmap.get("sealName"));
                sealRecord.setSealOtherName((String)tmap.get("sealOtherName"));
                sealRecord.setSubject((String)tmap.get("subject"));
                sealRecord.setTenantId(tmap.get("tenantId") == null ? null : Long.valueOf((String)tmap.get("tenantId")));
                sealRecord.setTenantName((String)tmap.get("tenantName"));
                sealRecord.setUserId(tmap.get("userId") == null ? null : Long.valueOf((String)tmap.get("userId")));
                sealRecord.setUserName((String)tmap.get("userName"));
                sealRecord.setDeviceNo((String)tmap.get("deviceNo"));
                Object categotyObject = tmap.get("category");
                if (categotyObject != null) {
                    sealRecord.setCategory(SealCategory.valueOf((String)categotyObject));
                }
                newlist.add(sealRecord);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return newlist;
    }

    @Override
    public List<Seal> sealList(String category) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (StringUtils.isNotBlank(category)) {
            paramers.addParam("category", category);
        }
        if ((code = (Integer)(result = this.client.doService("/seal/list/platform", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u5370\u7ae0\u5217\u8868\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        List sealList = (List)result.get("list");
        if (sealList == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        try {
            for (Map sealsMap : sealList) {
                seals.add(new Seal(sealsMap));
            }
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public List<Seal> sealList(Long companyId, String companyName, String category) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (companyId != null) {
            paramers.addParam("companyId", companyId.toString());
        }
        if (StringUtils.isNotBlank(companyName)) {
            paramers.addParam("companyName", companyName);
        }
        if (StringUtils.isNotBlank(category)) {
            paramers.addParam("category", category);
        }
        if ((code = (Integer)(result = this.client.doService("/seal/list", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u5370\u7ae0\u5217\u8868\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        List sealList = (List)result.get("list");
        if (sealList == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        try {
            for (Map sealsMap : sealList) {
                seals.add(new Seal(sealsMap));
            }
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public List<Seal> sealListAll(String category) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (StringUtils.isNotBlank(category)) {
            paramers.addParam("category", category);
        }
        if ((code = (Integer)(result = this.client.doService("/seal/list/all", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u5370\u7ae0\u5217\u8868\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        List sealList = (List)result.get("list");
        if (sealList == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        try {
            for (Map sealsMap : sealList) {
                seals.add(new Seal(sealsMap));
            }
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public List<Seal> sealAllContainsOAUserIDs(String category) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (StringUtils.isNotBlank(category)) {
            paramers.addParam("category", category);
        }
        if ((code = (Integer)(result = this.client.doService("/seal/oa/all", paramers)).get("code")) != 0) {
            throw new Exception("\u83b7\u53d6\u5370\u7ae0\u5217\u8868\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        List sealList = (List)result.get("list");
        if (sealList == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        try {
            for (Map sealsMap : sealList) {
                int index;
                Seal seal = new Seal(sealsMap);
                if (StringUtils.isNotBlank(seal.getStatus()) && (index = seal.getStatus().indexOf("key")) > -1) {
                    seal.setStatus(seal.getStatus().substring(index + 4, seal.getStatus().length() - 1));
                }
                seal.setOaUserIds(String.valueOf(sealsMap.get("oaUserIds")));
                seals.add(seal);
            }
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public Seal createCompanySeal(Seal seal, String image) throws PrivateAppException {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (seal.getOwner() != null) {
            paramers.addParam("owner", String.valueOf(seal.getOwner()));
        }
        if (StringUtils.isNotBlank(seal.getName())) {
            paramers.addParam("name", seal.getName());
        }
        if (StringUtils.isNotBlank(seal.getOtherName())) {
            paramers.addParam("otherName", seal.getOtherName());
        }
        if (StringUtils.isNotBlank(image)) {
            paramers.addParam("image", image);
        }
        if (seal.getSpec() != null) {
            paramers.addParam("spec", seal.getSpec());
        }
        if ((code = (Integer)(result = this.client.doService("/seal/create/company", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u521b\u5efa\u4f01\u4e1a\u516c\u7ae0\uff0c" + (String)result.get("message"));
        }
        Map map = (Map)result.get("result");
        if (map == null) {
            return null;
        }
        Seal tempSeal = new Seal();
        try {
            tempSeal.setCreateTime(TimeUtils.parse((String)map.get("createTime")));
            tempSeal.setId(map.get("id") == null ? null : Long.valueOf((String)map.get("id")));
            tempSeal.setName(String.valueOf(map.get("name")));
            tempSeal.setOtherName(String.valueOf(map.get("otherName")));
            tempSeal.setOwner(map.get("owner") == null ? null : Long.valueOf((String)map.get("owner")));
            tempSeal.setSealKey(String.valueOf(map.get("sealKey")));
            tempSeal.setSpec(String.valueOf(map.get("spec")));
            tempSeal.setStatus(String.valueOf(map.get("status")));
            tempSeal.setType(SealType.valueOf(String.valueOf(map.get("type"))));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tempSeal;
    }

    @Override
    public Seal getSealByCategory(Long categoryId) throws Exception {
        Map<String, Object> result;
        Integer code;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (categoryId != null) {
            paramers.addParam("categoryId", String.valueOf(categoryId));
        }
        if ((code = (Integer)(result = this.client.doService("/seal/getbycategory", paramers)).get("code")) != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u4e1a\u52a1\u5206\u7c7b\u4e0b\u5370\u7ae0\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        Map map = (Map)result.get("seal");
        if (map == null) {
            return null;
        }
        Seal tempSeal = new Seal();
        try {
            tempSeal.setCreateTime(TimeUtils.parse((String)map.get("createTime")));
            tempSeal.setId(map.get("id") == null ? null : Long.valueOf((String)map.get("id")));
            tempSeal.setName(String.valueOf(map.get("name")));
            tempSeal.setOtherName(String.valueOf(map.get("otherName")));
            tempSeal.setOwner(map.get("owner") == null ? null : Long.valueOf((String)map.get("owner")));
            tempSeal.setSealKey(String.valueOf(map.get("sealKey")));
            tempSeal.setSpec(String.valueOf(map.get("spec")));
            tempSeal.setStatus(String.valueOf(map.get("status")));
            tempSeal.setType(SealType.valueOf(String.valueOf(map.get("type"))));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tempSeal;
    }

    @Override
    public List<Seal> getSealByUser(String mobile, String companyName) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (StringUtils.isBlank(mobile)) {
            throw new Exception("\u8bf7\u8f93\u5165\u7528\u6237\u624b\u673a\u53f7");
        }
        if (StringUtils.isBlank(companyName)) {
            throw new Exception("\u8bf7\u8f93\u5165\u516c\u53f8\u540d\u79f0");
        }
        paramers.addParam("mobile", mobile);
        paramers.addParam("companyName", companyName);
        Map<String, Object> result = this.client.doService("/seal/user/charge", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u7528\u6237\u53ef\u7528\u5370\u7ae0\u5931\u8d25");
        }
        List sealList = (List)result.get("result");
        if (sealList == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        for (Map map : sealList) {
            Seal tempSeal = new Seal();
            tempSeal.setCreateTime(TimeUtils.parse((String)map.get("createTime")));
            tempSeal.setId(map.get("id") == null ? null : Long.valueOf((String)map.get("id")));
            tempSeal.setName(String.valueOf(map.get("name")));
            tempSeal.setOtherName(String.valueOf(map.get("otherName")));
            tempSeal.setOwner(map.get("owner") == null ? null : Long.valueOf((String)map.get("owner")));
            tempSeal.setSealKey(String.valueOf(map.get("sealKey")));
            tempSeal.setSpec(String.valueOf(map.get("spec")));
            tempSeal.setStatus(String.valueOf(map.get("status")));
            tempSeal.setType(SealType.valueOf(String.valueOf(map.get("type"))));
            tempSeal.setSealCategoryName(String.valueOf(map.get("sealCategoryName")));
            seals.add(tempSeal);
        }
        return seals;
    }

    @Override
    public List<Seal> getSealByEmployee(String number, String companyName) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("employeeNo", number);
        paramers.addParam("companyName", companyName);
        Map<String, Object> result = this.client.doService("/seal/user/charge", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u7528\u6237\u53ef\u7528\u5370\u7ae0\u5931\u8d25");
        }
        List sealList = (List)result.get("result");
        if (sealList == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        for (Map map : sealList) {
            Seal tempSeal = new Seal();
            tempSeal.setCreateTime(TimeUtils.parse((String)map.get("createTime")));
            tempSeal.setId(map.get("id") == null ? null : Long.valueOf((String)map.get("id")));
            tempSeal.setName(String.valueOf(map.get("name")));
            tempSeal.setOtherName(String.valueOf(map.get("otherName")));
            tempSeal.setOwner(map.get("owner") == null ? null : Long.valueOf((String)map.get("owner")));
            tempSeal.setSealKey(String.valueOf(map.get("sealKey")));
            tempSeal.setSpec(String.valueOf(map.get("spec")));
            tempSeal.setStatus(String.valueOf(map.get("status")));
            tempSeal.setType(SealType.valueOf(String.valueOf(map.get("type"))));
            seals.add(tempSeal);
        }
        return seals;
    }

    @Override
    public void personalSealImage(Long userId, String mobile, String cardNo, OutputStream outputStream) throws Exception {
        HttpParamers params = HttpParamers.httpGetParamers();
        if (userId != null) {
            params.addParam("userId", String.valueOf(userId));
        }
        if (StringUtils.isNotBlank(mobile)) {
            params.addParam("mobile", mobile);
        }
        if (StringUtils.isNotBlank(cardNo)) {
            params.addParam("cardNo", cardNo);
        }
        this.client.download("/seal/personalsealimage", params, outputStream);
    }

    @Override
    public void personalSealImages(SealCondition condition, OutputStream outputStream) throws Exception {
        HttpParamers params = HttpParamers.httpGetParamers();
        if (condition.getStartTime() != null) {
            params.addParam("startTime", TimeUtils.format(condition.getStartTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (condition.getEndTime() != null) {
            params.addParam("endTime", TimeUtils.format(condition.getEndTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        this.client.download("/seal/personalsealimages", params, outputStream);
    }

    @Override
    public void timeStampImage(OutputStream outputStream) throws Exception {
        HttpParamers params = HttpParamers.httpGetParamers();
        this.client.download("/seal/timestampimage", params, outputStream);
    }

    @Override
    public List<Company> innercompanySealList(SealCondition condition) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        Map<String, Object> result = this.client.doService("/seal/innercompany/seallist", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new PrivateAppException("\u83b7\u53d6\u5185\u90e8\u4f01\u4e1a\u7684\u5370\u7ae0\u5217\u8868\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        List compamyMaps = (List)result.get("result");
        List<Company> companies = null;
        try {
            companies = MapUtils.toObjectList(compamyMaps, Company.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return companies;
    }
}

