/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.SignService;
import net.qiyuesuo.sdk.bean.company.CompanyAppearanceSignRequest;
import net.qiyuesuo.sdk.bean.company.CompanyAuditRequest;
import net.qiyuesuo.sdk.bean.company.CompanySignRequest;
import net.qiyuesuo.sdk.bean.contract.SignCheck;
import net.qiyuesuo.sdk.bean.sign.PersonalAppearanceSignRequest;
import net.qiyuesuo.sdk.bean.sign.PersonalSignRequest;
import net.qiyuesuo.sdk.bean.sign.PlatformSignRequest;
import net.qiyuesuo.sdk.bean.sign.SignUrlRequest;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;

public class SignServiceImpl
implements SignService {
    private SDKClient client;

    public SignServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String presignUrl(Long contractId) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/presignurl", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u9884\u7b7e\u7f72\u94fe\u63a5\u60c5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (String)result.get("presignUrl");
    }

    @Override
    public void signByPlatform(PlatformSignRequest request) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signbyplatform", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u7f72\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void signByCompany(CompanySignRequest request) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signbycompany", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u7f72\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void signByCompanyWithoutAppearance(CompanyAppearanceSignRequest request) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signbycompanywithoutappearance", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u7f72\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public String signUrl(SignUrlRequest request) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signurl", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u83b7\u53d6\u7b7e\u7f72\u94fe\u63a5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        String signUrl = (String)result.get("signUrl");
        return signUrl;
    }

    @Override
    public void signByPerson(PersonalSignRequest request) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signbyperson", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u7f72\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void signByPersonWithoutAppearance(PersonalAppearanceSignRequest request) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signbypersonwithoutappearance", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u7f72\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void signSms(SignUrlRequest request) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signurl/send", JSONUtils.toJson(request));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u53d1\u9001\u7b7e\u7f72\u94fe\u63a5\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void signByLp(CompanySignRequest signRequest) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signbylegalperson", JSONUtils.toJson(signRequest));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u7f72\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public void audit(CompanyAuditRequest auditRequest) throws Exception {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/audit", JSONUtils.toJson(auditRequest));
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u7b7e\u7f72\u5408\u540c\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
    }

    @Override
    public boolean checkPassword(SignCheck signCheck) throws Exception {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("mobile", signCheck.getMobile());
        paramers.addParam("signPassword", signCheck.getSignPassword());
        Map<String, Object> result = this.client.doService("/contract/checkpassword", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u6821\u9a8c\u7b7e\u7f72\u5bc6\u7801\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        return (Boolean)result.get("result");
    }
}

