/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.InputStream;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.VerifyService;
import net.qiyuesuo.sdk.bean.verifier.PdfVerifierResult;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class VerifyServiceImpl
implements VerifyService {
    private SDKClient client;

    public VerifyServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public PdfVerifierResult verifyPdf(InputStream inputstream) throws Exception {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile file = new StreamFile(inputstream);
        paramers.addFile("file", file);
        Map<String, Object> result = this.client.doService("/pdfverifier", paramers);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception("\u9a8c\u8bc1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c" + (String)result.get("message"));
        }
        PdfVerifierResult verifierResult = new PdfVerifierResult();
        try {
            if (StringUtils.isNotBlank((String)result.get("documentId"))) {
                verifierResult.setDocumentId(Long.valueOf((String)result.get("documentId")));
            }
            verifierResult.setSignatureInfos(result.get("signatureInfos") == null ? null : result.get("signatureInfos").toString());
            verifierResult.setStatusCode((Integer)result.get("statusCode"));
            verifierResult.setStatusMsg((String)result.get("statusMsg"));
        }
        catch (Exception e) {
            throw new Exception("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return verifierResult;
    }
}

