/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Mac;
import net.qiyuesuo.sdk.common.Version;
import net.qiyuesuo.sdk.common.crypt.Hmac;
import net.qiyuesuo.sdk.common.crypt.MD5;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.HttpClient;
import net.qiyuesuo.sdk.common.http.HttpHeader;
import net.qiyuesuo.sdk.common.http.HttpMethod;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONObject;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.parameter.ParameterBody;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.idempotent.IdempotentClientToken;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKClient {
    private int connectTimeout = 30000;
    private int readTimeout = 120000;
    private String serviceUrl;
    private String accessToken;
    private String accessSecret;
    private boolean enableNonce;
    private String signatureVersion;
    private String traceId;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SDKClient(String serviceUrl, String accessToken, String accessSecret) {
        this.serviceUrl = serviceUrl;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
        this.signatureVersion = "MD5";
    }

    public SDKClient(String serviceUrl, String accessToken, String accessSecret, String signatureVersion, boolean enableNonce, String traceId) {
        this.serviceUrl = serviceUrl;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
        this.enableNonce = enableNonce;
        this.traceId = traceId;
        this.signatureVersion = StringUtils.isEmpty(signatureVersion) ? "MD5" : signatureVersion;
    }

    public Map<String, Object> doService(String requestUrl, HttpParamers paramers) throws PrivateAppException {
        String requestDirectoryName = UUID.randomUUID().toString().replace("-", "");
        String url = this.serviceUrl + requestUrl;
        HttpHeader header = this.buildHttpHeader(null, paramers, requestDirectoryName);
        if (StringUtils.isNotEmpty(IdempotentClientToken.getKey())) {
            header.setIdempotentToken(IdempotentClientToken.getKey());
        }
        String response = null;
        try {
            response = HttpClient.doService(url, paramers, header, this.connectTimeout, this.readTimeout, this.signatureVersion);
        }
        catch (PrivateAppException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivateAppException(e);
        }
        finally {
            if ("HMACSHA256".equals(this.signatureVersion)) {
                File file = new File("." + File.separator + "bigfile" + File.separator + requestDirectoryName);
                SDKClient.deleteDir(file);
            }
        }
        return this.handleHttpResponse(response);
    }

    public static void deleteDir(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    SDKClient.deleteDir(file);
                    continue;
                }
                if (!file.exists()) continue;
                file.delete();
            }
        }
        if (directory.exists()) {
            directory.delete();
        }
    }

    public String checkService(String requestUrl, HttpParamers paramers) throws PrivateAppException {
        String url = this.serviceUrl + requestUrl;
        HttpHeader header = this.buildHttpHeader(null, paramers, null);
        String response = null;
        try {
            response = HttpClient.doService(url, paramers, header, this.connectTimeout, this.readTimeout, this.signatureVersion);
        }
        catch (PrivateAppException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivateAppException(e);
        }
        return response;
    }

    public Map<String, Object> doServiceWithJson(String requestUrl, String json) throws PrivateAppException {
        this.logger.info("\u8bf7\u6c42\u7684json\uff1a{}", (Object)json);
        String url = this.serviceUrl + requestUrl;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        HttpHeader header = this.buildHttpHeader(json, paramers, null);
        String response = null;
        try {
            response = HttpClient.doServiceWithJson(url, json, header, this.connectTimeout, this.readTimeout);
        }
        catch (PrivateAppException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivateAppException(e);
        }
        return this.handleHttpResponse(response);
    }

    public Map<String, Object> doServiceByFormData(String requestUrl, Object object, HttpMethod httpMethod) throws PrivateAppException {
        String requestDirectoryName = UUID.randomUUID().toString().replace("-", "");
        this.logger.info("\u8bf7\u6c42\u7684\u6570\u636e\uff1a{}", (Object)JSONUtils.toJson(object));
        String url = this.serviceUrl + requestUrl;
        HttpParamers paramers = new HttpParamers(httpMethod);
        HttpHeader header = this.buildHttpHeader(null, paramers, requestDirectoryName);
        String response = null;
        try {
            Map<String, Object> map = MapUtils.oldEntityToMap(object);
            for (String key : map.keySet()) {
                Object o = map.get(key);
                if (o != null && o instanceof FileItem) {
                    paramers.addFile(key, (FileItem)o);
                    continue;
                }
                if (o == null) continue;
                paramers.addParam(key, String.valueOf(o));
            }
            response = HttpClient.doService(url, paramers, header, this.connectTimeout, this.readTimeout, this.signatureVersion);
        }
        catch (Exception e) {
            throw new PrivateAppException(e);
        }
        finally {
            if ("HMACSHA256".equals(this.signatureVersion)) {
                File file = new File("." + File.separator + "bigfile" + File.separator + requestDirectoryName);
                SDKClient.deleteDir(file);
            }
        }
        return this.handleHttpResponse(response);
    }

    private HttpHeader buildHttpHeader(String jsonString, HttpParamers paramers, String requestDirectoryName) {
        boolean isJson;
        Long timestamp = System.currentTimeMillis();
        String nonce = "";
        if (this.enableNonce) {
            nonce = UUID.randomUUID().toString();
        }
        this.traceId = StringUtils.isNotBlank(this.traceId) ? this.traceId : "";
        String signature = "";
        boolean bl = isJson = StringUtils.isNotBlank(jsonString);
        if ("HMACSHA256".equals(this.signatureVersion)) {
            ArrayList<ParameterBody> hmacSignatureList = new ArrayList<ParameterBody>();
            this.builderCommonParam(hmacSignatureList, timestamp + "", nonce, this.traceId);
            if (isJson) {
                hmacSignatureList.add(new ParameterBody("x-qys-body", jsonString, null));
            } else {
                hmacSignatureList.add(new ParameterBody("x-qys-body", "", null));
                this.builderParams(paramers, hmacSignatureList);
            }
            signature = this.calculateSignature(paramers.getHttpMethod().toString(), hmacSignatureList, paramers, requestDirectoryName);
        } else {
            signature = MD5.toMD5(this.accessToken + this.accessSecret + timestamp + nonce);
        }
        return new HttpHeader(this.accessToken, timestamp, signature, nonce, this.signatureVersion, "", this.traceId);
    }

    private void builderCommonParam(List<ParameterBody> hmacSignatureList, String timestamp, String nonce, String traceId) {
        hmacSignatureList.add(new ParameterBody("x-qys-accesstoken", this.accessToken, null));
        hmacSignatureList.add(new ParameterBody("x-qys-timestamp", timestamp + "", null));
        hmacSignatureList.add(new ParameterBody("x-qys-nonce", nonce, null));
        hmacSignatureList.add(new ParameterBody("x-qys-signature-version", this.signatureVersion, null));
        hmacSignatureList.add(new ParameterBody("x-qys-clienttoken", "", null));
        hmacSignatureList.add(new ParameterBody("x-qys-traceid", traceId, null));
    }

    private void builderParams(HttpParamers httpParamers, List<ParameterBody> hmacSignatureList) {
        String key;
        Set<Map.Entry<String, String>> textEntrySet = httpParamers.getParams().entrySet();
        HashSet<String> removeKey = new HashSet<String>();
        for (Map.Entry<String, String> textEntry : textEntrySet) {
            String string = textEntry.getKey();
            String value = textEntry.getValue();
            if (StringUtils.isNoneEmpty(string, value)) {
                if (!StringUtils.isNotBlank(string.trim())) continue;
                hmacSignatureList.add(new ParameterBody(textEntry.getKey(), textEntry.getValue(), null));
                continue;
            }
            removeKey.add(string);
        }
        for (String key3 : removeKey) {
            httpParamers.getParams().remove(key3);
        }
        if (!httpParamers.getFiles().isEmpty()) {
            Set<Map.Entry<String, FileItem>> fileEntrySet = httpParamers.getFiles().entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                key = entry.getKey();
                if (!StringUtils.isNotBlank(key.trim())) continue;
                hmacSignatureList.add(new ParameterBody(key, null, entry.getValue().getFileDirectoryName()));
            }
        }
        if (!httpParamers.getListFiles().isEmpty()) {
            Set<Map.Entry<String, List<FileItem>>> listEntrySet = httpParamers.getListFiles().entrySet();
            for (Map.Entry<String, Object> entry : listEntrySet) {
                key = entry.getKey();
                if (!StringUtils.isNotBlank(key.trim())) continue;
                List items = (List)entry.getValue();
                for (FileItem item : items) {
                    hmacSignatureList.add(new ParameterBody(key, null, item.getFileDirectoryName()));
                }
            }
        }
    }

    private String calculateSignature(String method, List<ParameterBody> hmacSignatureList, HttpParamers paramers, String requestDirectoryName) {
        HashMap<String, FileItem> fileItemMap = new HashMap<String, FileItem>();
        for (FileItem fileItem : paramers.getFiles().values()) {
            fileItemMap.put(fileItem.getFileDirectoryName(), fileItem);
        }
        for (List list : paramers.getListFiles().values()) {
            for (FileItem fileItem : list) {
                fileItemMap.put(fileItem.getFileDirectoryName(), fileItem);
            }
        }
        Collections.sort(hmacSignatureList, new Comparator<ParameterBody>(){

            @Override
            public int compare(ParameterBody s1, ParameterBody s2) {
                return s1.getName().compareTo(s2.getName());
            }
        });
        Mac mac = Hmac.getMac(this.accessSecret);
        mac.update(method.getBytes(StandardCharsets.UTF_8));
        for (ParameterBody parameterBody : hmacSignatureList) {
            String str = "&" + parameterBody.getName() + "=";
            mac.update(str.getBytes(StandardCharsets.UTF_8));
            String fileKey = parameterBody.getFileKey();
            if (StringUtils.isNotBlank(fileKey)) {
                FileItem file = (FileItem)fileItemMap.get(fileKey);
                file.setRequestDirectoryName(requestDirectoryName);
                file.readStreamAndcalculateSignature(mac);
                continue;
            }
            String value = parameterBody.getValue();
            if (!StringUtils.isNotBlank(value)) continue;
            mac.update(value.getBytes(StandardCharsets.UTF_8));
        }
        String string = Hex.encodeHexString((byte[])mac.doFinal());
        return string;
    }

    private Map<String, Object> handleHttpResponse(String response) throws PrivateAppException {
        JSONObject jsonObject = new JSONObject(response);
        Map<String, Object> result = jsonObject.toMap();
        if (result == null || result.isEmpty()) {
            throw new PrivateAppException("\u8fdc\u7a0b\u670d\u52a1\u8fd4\u56de\u7684\u6570\u636e\u65e0\u6cd5\u89e3\u6790");
        }
        Integer code = (Integer)result.get("code");
        if (code == null || code != 0) {
            throw new PrivateAppException(code, (String)result.get("message"));
        }
        return result;
    }

    public void download(String requestUrl, HttpParamers paramers, OutputStream outputStream) throws PrivateAppException {
        String url = this.serviceUrl + requestUrl;
        HttpHeader header = this.buildHttpHeader(null, paramers, null);
        try {
            HttpClient.doDownload(url, paramers, header, this.connectTimeout, this.readTimeout, outputStream);
        }
        catch (PrivateAppException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivateAppException(e.getMessage(), e);
        }
    }

    public String getVersionInfo() {
        return Version.touch();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void reset(String serviceUrl, String accessToken, String accessSecret) {
        this.serviceUrl = serviceUrl;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
    }

    public void enableNonce() {
        this.enableNonce = true;
    }
}

