/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.bean.page;

import java.io.Serializable;
import java.util.List;

public class PageVo<T>
implements Serializable {
    protected int pageNo;
    protected int pageSize;
    protected List<T> result;
    protected long totalCount = 0L;
    private boolean hasNext = false;

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        if (pageNo < 1) {
            this.pageNo = 1;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize < 1) {
            this.pageSize = 1;
        }
    }

    public int getFirst() {
        return (this.pageNo - 1) * this.pageSize + 1;
    }

    public List<T> getResult() {
        return this.result;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalPages() {
        if (this.totalCount < 0L) {
            return -1L;
        }
        long count = this.totalCount / (long)this.pageSize;
        if (this.totalCount % (long)this.pageSize > 0L) {
            ++count;
        }
        return count;
    }

    public boolean isHasNext() {
        if (!this.hasNext) {
            return (long)(this.pageNo + 1) <= this.getTotalPages();
        }
        return this.hasNext;
    }

    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    public int getNextPage() {
        return this.isHasNext() ? this.pageNo + 1 : this.pageNo;
    }

    public boolean isHasPre() {
        return this.pageNo - 1 >= 1;
    }

    public int getPrePage() {
        return this.isHasPre() ? this.pageNo - 1 : this.pageNo;
    }

    public String toString() {
        return "Page [totalCount=" + this.totalCount + "]";
    }
}

