/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.common.utils;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.qiyuesuo.sdk.common.utils.ArrayUtils;

public class StringUtils {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static String STRINGS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isAnyEmpty(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtils.isEmpty(cs)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneEmpty(CharSequence ... css) {
        return !StringUtils.isAnyEmpty(css);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtils.isBlank(cs)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        return !StringUtils.isAnyBlank(css);
    }

    public static boolean isAllBlank(CharSequence ... css) {
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtils.isNotBlank(cs)) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String trimToEmpty(Object o) {
        return o == null ? EMPTY : o.toString();
    }

    public static String random(int length) {
        if (length < 1) {
            return null;
        }
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(STRINGS.length());
            sb.append(STRINGS.charAt(number));
        }
        return sb.toString();
    }

    public static String randomString(int length) {
        if (length < 1) {
            return null;
        }
        String base = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static int getVersion(String versionStr) {
        String[] numbers = versionStr.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numbers.length && i <= 1; ++i) {
            String number = numbers[i];
            if (number.length() == 1) {
                number = '0' + number;
            }
            builder.append(number);
        }
        return Integer.valueOf(builder.toString());
    }

    public static <T> Set<T> StringToSet(String value) {
        value = value.replace("[", EMPTY);
        value = value.replace("]", EMPTY);
        String[] strs = value.split(",");
        HashSet<String> set = new HashSet<String>();
        for (String str : strs) {
            set.add(str.trim());
        }
        return set;
    }
}

