/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.CompanyService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.company.CompanyAuth;
import net.qiyuesuo.sdk.bean.company.CompanyAuthBean;
import net.qiyuesuo.sdk.bean.company.CompanyAuthInfoRequest;
import net.qiyuesuo.sdk.bean.company.CompanyAuthNoticeRequset;
import net.qiyuesuo.sdk.bean.company.CompanyAuthPage;
import net.qiyuesuo.sdk.bean.company.CompanyAuthRequest;
import net.qiyuesuo.sdk.bean.company.CompanyAuthRequestV2;
import net.qiyuesuo.sdk.bean.company.CompanyAuthStatusResponse;
import net.qiyuesuo.sdk.bean.company.CompanyCancelAuthRequest;
import net.qiyuesuo.sdk.bean.company.CompanyCredit;
import net.qiyuesuo.sdk.bean.company.CompanyRequest;
import net.qiyuesuo.sdk.bean.company.CompanyStatusResult;
import net.qiyuesuo.sdk.bean.company.CreateCompanyRequest;
import net.qiyuesuo.sdk.bean.company.TenantStatus;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.sealapply.MapUtil;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpMethod;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;
import net.qiyuesuo.v2sdk.response.auth.CompanyAuthResponseV2;

public class CompanyServiceImpl
implements CompanyService {
    private SDKClient client;

    public CompanyServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String createCompany(CreateCompanyRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        if (request.getLegalAuthorization() != null) {
            paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        }
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("legalPerson", request.getLegalPerson());
        paramers.addParam("legalPersonId", request.getLegalPersonId());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("operator", request.getOperator());
        paramers.addParam("paperType", request.getPaperType());
        paramers.addParam("province", request.getProvince());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("tenantType", request.getTenantType().name());
        if (request.getRemind() != null) {
            paramers.addParam("remind", String.valueOf(request.getRemind()));
        }
        Map<String, Object> result = this.client.doService("/company/create", paramers);
        Company company = null;
        Map companyMap = (Map)result.get("result");
        try {
            company = MapUtils.toObject(companyMap, Company.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return company == null ? null : company.getOpenCompanyId();
    }

    @Override
    public Company create(CreateCompanyRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        if (request.getLegalAuthorization() != null) {
            paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        }
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("legalPerson", request.getLegalPerson());
        paramers.addParam("legalPersonId", request.getLegalPersonId());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("email", request.getEmail());
        paramers.addParam("operator", request.getOperator());
        paramers.addParam("paperType", request.getPaperType());
        paramers.addParam("province", request.getProvince());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("tenantType", request.getTenantType().name());
        if (request.getCompanyType() != null) {
            paramers.addParam("companyType", "" + request.getCompanyType());
        }
        if (StringUtils.isNotBlank(request.getOpenCompanyId())) {
            paramers.addParam("openCompanyId", request.getOpenCompanyId());
        }
        if (request.getRemind() != null) {
            paramers.addParam("remind", String.valueOf(request.getRemind()));
        }
        paramers.addParam("area", request.getArea());
        if (request.getCustomer() != null) {
            paramers.addParam("customer", String.valueOf(request.getCustomer()));
        }
        Map<String, Object> result = this.client.doService("/company/create", paramers);
        Company company = null;
        Map companyMap = (Map)result.get("result");
        try {
            company = MapUtils.toObject(companyMap, Company.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return company;
    }

    @Override
    public String getCompanyAuthStatus(String companyName) throws PrivateAppException {
        return this.getCompanyAuthStatus(null, companyName, null).getStatus();
    }

    @Override
    public String getCompanyAuthStatus(CompanyRequest companyRequest) throws PrivateAppException {
        return this.getCompanyAuthStatus(companyRequest.getCompanyId(), companyRequest.getCompanyName(), companyRequest.getRegisterNo()).getStatus();
    }

    @Override
    public CompanyStatusResult getCompanyAuthStatusDetail(CompanyRequest companyRequest) throws PrivateAppException {
        return this.getCompanyAuthStatus(companyRequest.getCompanyId(), companyRequest.getCompanyName(), companyRequest.getRegisterNo());
    }

    private CompanyStatusResult getCompanyAuthStatus(Long companyId, String companyName, String registerNo) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("companyName", companyName);
        paramers.addParam("registerNo", registerNo);
        if (companyId != null) {
            paramers.addParam("id", String.valueOf(companyId));
        }
        Map<String, Object> result = this.client.doService("/company/status", paramers);
        String status = null;
        String reason = null;
        if (result.get("result") != null) {
            status = (String)((Map)result.get("result")).get("status");
            reason = (String)((Map)result.get("result")).get("reason");
        }
        return new CompanyStatusResult(status, reason);
    }

    @Override
    public Map<String, String> getCompanyAuthStatusDetail(String companyName) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("companyName", companyName);
        Map<String, Object> result = this.client.doService("/company/status", paramers);
        return (Map)result.get("result");
    }

    @Override
    public List<Company> queryList(TenantType tenantType) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (tenantType != null) {
            paramers.addParam("tenantType", tenantType.toString());
        }
        Map<String, Object> result = this.client.doService("/company/list", paramers);
        ArrayList<Company> companies = new ArrayList<Company>();
        if (result.get("result") != null) {
            List companyList = (List)result.get("result");
            for (Map companyMap : companyList) {
                Company company = new Company();
                company.setId(Long.valueOf((String)companyMap.get("id")));
                company.setName((String)companyMap.get("name"));
                if (companyMap.get("status") != null) {
                    company.setStatus(TenantStatus.valueOf((String)companyMap.get("status")));
                }
                if (companyMap.get("tenantType") != null) {
                    company.setTenantType(TenantType.valueOf((String)companyMap.get("tenantType")));
                }
                if (companyMap.get("parentId") != null) {
                    company.setParentId(Long.valueOf((String)companyMap.get("parentId")));
                }
                companies.add(company);
            }
        }
        return companies;
    }

    @Override
    public List<Company> queryList(CompanyRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request != null) {
            if (request.getTenantType() != null) {
                paramers.addParam("tenantType", request.getTenantType().toString());
            }
            paramers.addParam("companyName", request.getCompanyName());
            if (request.getUpdateTime() != null) {
                paramers.addParam("updateTime", TimeUtils.format(request.getUpdateTime(), "yyyy-MM-dd HH:mm:ss"));
            }
        }
        Map<String, Object> result = this.client.doService("/company/list", paramers);
        ArrayList<Company> companies = new ArrayList<Company>();
        if (result.get("result") != null) {
            List companyList = (List)result.get("result");
            for (Map companyMap : companyList) {
                Company company = new Company();
                company.setId(Long.valueOf((String)companyMap.get("id")));
                company.setName((String)companyMap.get("name"));
                if (companyMap.get("status") != null) {
                    company.setStatus(TenantStatus.valueOf((String)companyMap.get("status")));
                }
                if (companyMap.get("tenantType") != null) {
                    company.setTenantType(TenantType.valueOf((String)companyMap.get("tenantType")));
                }
                if (companyMap.get("parentId") != null) {
                    company.setParentId(Long.valueOf((String)companyMap.get("parentId")));
                }
                companies.add(company);
            }
        }
        return companies;
    }

    @Override
    public Company detail(CompanyRequest request) throws PrivateAppException {
        if (request == null) {
            return null;
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        if (StringUtils.isNotBlank(request.getCompanyName())) {
            paramers.addParam("companyName", request.getCompanyName());
        }
        if (StringUtils.isNotBlank(request.getRegisterNo())) {
            paramers.addParam("registerNo", request.getRegisterNo());
        }
        Map<String, Object> result = this.client.doService("/company/detail", paramers);
        Map companyMap = (Map)result.get("result");
        Company company = new Company();
        if (companyMap != null) {
            company.setId(MapUtil.getLong(companyMap, "id"));
            company.setName(MapUtil.getString(companyMap, "name"));
            company.setRegisterNo(MapUtil.getString(companyMap, "registerNo"));
            company.setTenantType(TenantType.valueOf(MapUtil.getString(companyMap, "tenantType")));
            company.setCreateTime(MapUtil.getDate(companyMap, "createTime"));
            company.setStatus(TenantStatus.valueOf(MapUtil.getString(companyMap, "status")));
            company.setLegalPerson(MapUtil.getString(companyMap, "legalPerson"));
            company.setLegalPersonId(MapUtil.getString(companyMap, "legalPersonId"));
            company.setParentId(MapUtil.getLong(companyMap, "parentId"));
            company.setFreeze(MapUtil.getBoolean(companyMap, "freeze"));
        }
        return company;
    }

    @Override
    public void sendCompanyAuthNotice(CompanyAuthNoticeRequset request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("legalPerson", request.getLegalPerson());
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        if (request.getLegalAuthorization() != null) {
            paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        }
        this.client.doService("/companyauth/notice", paramers);
    }

    @Override
    public Company sendCompanyAuthNotify(CompanyAuthNoticeRequset request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("legalPerson", request.getLegalPerson());
        paramers.addParam("external", String.valueOf(request.getExternal()));
        if (request.getLanguage() != null) {
            paramers.addParam("language", String.valueOf((Object)request.getLanguage()));
        }
        paramers.addParam("themeColor", request.getThemeColor());
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        if (request.getLegalAuthorization() != null) {
            paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        }
        Map<String, Object> result = this.client.doService("/companyauth/notice", paramers);
        Long companyId = MapUtil.getLong((Map)result.get("result"), "id");
        Company company = new Company();
        if (companyId != null) {
            company.setId(companyId);
        }
        return company;
    }

    @Override
    public void changeInfo(CompanyAuth companyAuth) throws PrivateAppException {
        throw new PrivateAppException("\u8bf7\u4f7f\u7528\u65b0\u7248\u4f01\u4e1a\u4fe1\u606f\u53d8\u66f4\u63a5\u53e3");
    }

    @Override
    public String changeInfo(CompanyRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceByFormData("/company/changeinfo", request, HttpMethod.POST);
        return (String)result.get("authUrl");
    }

    @Override
    public void deleteUnceritifiedCompany(CompanyRequest request) throws PrivateAppException {
        this.client.doServiceByFormData("/company/delete", request, HttpMethod.POST);
    }

    @Override
    public void freezeOrUnfreezeCompany(CompanyRequest request, Boolean freeze) throws PrivateAppException {
        String url = freeze != false ? "/company/freeze" : "/company/unfreeze";
        this.client.doServiceByFormData(url, request, HttpMethod.POST);
    }

    @Override
    public CompanyCredit manageStatus(CompanyRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        paramers.addParam("companyName", request.getCompanyName());
        paramers.addParam("registerNo", request.getRegisterNo());
        Map<String, Object> result = this.client.doService("/company/managestatus", paramers);
        Map companyCreditMap = (Map)result.get("result");
        CompanyCredit companyCredit = null;
        try {
            companyCredit = MapUtils.toObject(companyCreditMap, CompanyCredit.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return companyCredit;
    }

    @Override
    public String companyAuthPCPage(CompanyAuthPage request) throws PrivateAppException {
        return this.getAuthUrl(request, true);
    }

    @Override
    public String companyAuthH5Page(CompanyAuthPage request) throws PrivateAppException {
        return this.getAuthUrl(request, false);
    }

    private String getAuthUrl(CompanyAuthPage request, boolean pcPage) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("mobile", request.getMobile());
        if (request.getCustomer() != null) {
            paramers.addParam("customer", String.valueOf(request.getCustomer()));
        }
        paramers.addParam("external", String.valueOf(request.getExternal()));
        if (request.getLegalPerson() != null) {
            paramers.addParam("legalPerson", request.getLegalPerson());
        }
        if (request.getEdit() != null) {
            paramers.addParam("edit", String.valueOf(request.getEdit()));
        }
        paramers.addParam("successPage", request.getSuccessPage());
        paramers.addParam("modifyFields", request.getModifyFields());
        if (request.getLanguage() != null) {
            paramers.addParam("language", String.valueOf((Object)request.getLanguage()));
        }
        paramers.addParam("themeColor", request.getThemeColor());
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        Map<String, Object> result = null;
        result = pcPage ? this.client.doService("/companyauth/pcpage", paramers) : this.client.doService("/companyauth/h5page", paramers);
        String authurl = (String)result.get("authurl");
        return authurl;
    }

    @Override
    public void downloadLicense(CompanyRequest request, OutputStream outputStream) throws PrivateAppException {
        if (request.getCompanyId() == null && StringUtils.isBlank(request.getCompanyName()) && StringUtils.isBlank(request.getRegisterNo())) {
            throw new PrivateAppException(1000001, "companyId\u3001companyName\u3001registerNo\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        paramers.addParam("companyName", request.getCompanyName());
        paramers.addParam("registerNo", request.getRegisterNo());
        this.client.download("/company/license/download", paramers, outputStream);
    }

    @Override
    public void recertification(CompanyAuthRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (request.getId() != null) {
            paramers.addParam("id", request.getId().toString());
        }
        paramers.addParam("name", request.getName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("mobile", request.getMobile());
        if (request.getLegalPerson() != null) {
            paramers.addParam("legalPerson", request.getLegalPerson());
        }
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        if (request.getLegalAuthorization() != null) {
            paramers.addFile("legalAuthorization", request.getLegalAuthorization());
        }
        if (request.getRemoveOriginalCharger() != null) {
            paramers.addParam("removeOriginalCharger", request.getRemoveOriginalCharger().toString());
        }
        if (request.getModifyCompanyStatusImmediately() != null) {
            paramers.addParam("modifyCompanyStatusImmediately", String.valueOf(request.getModifyCompanyStatusImmediately()));
        }
        if (request.getLanguage() != null) {
            paramers.addParam("language", request.getLanguage().toString());
        }
        if (request.getThemeColor() != null) {
            paramers.addParam("themeColor", request.getThemeColor());
        }
        this.client.doService("/companyauth/recertification", paramers);
    }

    @Override
    public String submitCompanyAuthInfo(CompanyAuthInfoRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("area", request.getArea());
        if (request.getCompanyType() != null) {
            paramers.addParam("companyType", request.getCompanyType().toString());
        }
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        paramers.addParam("companyName", request.getCompanyName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("legalPerson", request.getLegalPerson());
        paramers.addParam("mobile", request.getMobile());
        if (request.getOperAuthorization() != null) {
            paramers.addFile("operAuthorization", request.getOperAuthorization());
        }
        if (request.getCardType() != null) {
            paramers.addParam("cardType", request.getCardType().toString());
        }
        paramers.addParam("bankCardNo", request.getBankCardNo());
        paramers.addParam("bankName", request.getBankName());
        paramers.addParam("lineNo", request.getLineNo());
        paramers.addParam("requestId", request.getRequestId());
        if (request.getCustomer() != null) {
            paramers.addParam("customer", String.valueOf(request.getCustomer()));
        }
        Map<String, Object> result = this.client.doService("/companyauth/submitcompanyauth", paramers);
        String requestId = (String)result.get("requestId");
        return requestId;
    }

    @Override
    public Integer bankAccountConfirm(String requestId, Double amount) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("requestId", requestId);
        if (amount != null) {
            paramers.addParam("amount", amount.toString());
        }
        Map<String, Object> result = this.client.doService("/companyauth/bankaccountconfirm", paramers);
        Integer confirm = Integer.valueOf((String)result.get("confirm"));
        return confirm;
    }

    @Override
    public Map<String, Object> getAuthResult(String requestId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("requestId", requestId);
        Map<String, Object> result = this.client.doService("/companyauth/getauthresult", paramers);
        return (Map)result.get("result");
    }

    @Override
    public void basicAuth(CompanyAuthRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("name", request.getName());
        paramers.addParam("registerNo", request.getRegisterNo());
        paramers.addParam("charger", request.getCharger());
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("legalPerson", request.getLegalPerson());
        paramers.addParam("legalPersonCardNo", request.getLegalPersonCardNo());
        paramers.addParam("legalPersonContact", request.getLegalPersonContact());
        paramers.addParam("companyType", String.valueOf(request.getCompanyType()));
        paramers.addParam("area", request.getArea());
        paramers.addParam("openCompanyId", request.getOpenCompanyId());
        paramers.addParam("external", String.valueOf(request.getExternal()));
        if (request.getLicense() != null) {
            paramers.addFile("license", request.getLicense());
        }
        this.client.doService("/companyauth/basicauth", paramers);
    }

    @Override
    public String legalPersonSignAuthUrl(CompanyAuthRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        Map<String, Object> result = this.client.doServiceWithJson("/companyauth/legalpersonsignurl", JSONUtils.toJson(request));
        return String.valueOf(result.get("result"));
    }

    @Override
    public void cancelCompanyAuth(CompanyCancelAuthRequest request) throws PrivateAppException {
        this.client.doServiceByFormData("/companyauth/cancel", request, HttpMethod.POST);
    }

    @Override
    public CompanyAuthResponseV2 companyauthV2(CompanyAuthRequestV2 request) throws Exception {
        Map<String, Object> map = this.client.doServiceByFormData("/companyauth/v2", request, HttpMethod.POST);
        Map result = (Map)map.get("result");
        CompanyAuthResponseV2 response = MapUtils.toObject(result, CompanyAuthResponseV2.class);
        return response;
    }

    @Override
    public String submitBasicinfo(CompanyAuthRequestV2 request) throws Exception {
        Map<String, Object> map = this.client.doServiceByFormData("/companyauth/submitbasicinfo", request, HttpMethod.POST);
        return (String)map.get("requestId");
    }

    @Override
    public void submitOperauthorization(CompanyAuthBean request) throws Exception {
        this.client.doServiceByFormData("/companyauth/submit/operauthorization", request, HttpMethod.POST);
    }

    @Override
    public void submitReversepay(CompanyAuthBean request) throws Exception {
        this.client.doServiceByFormData("/companyauth/submit/reversepay", request, HttpMethod.POST);
    }

    @Override
    public Integer reversepayConfirm(CompanyAuthBean request) throws Exception {
        Map<String, Object> map = this.client.doServiceByFormData("/companyauth/reversepay/confirm", request, HttpMethod.POST);
        return (Integer)map.get("confirm");
    }

    @Override
    public String legalSignurl(CompanyAuthBean request) throws Exception {
        Map<String, Object> map = this.client.doServiceByFormData("/companyauth/legalsignurl", request, HttpMethod.POST);
        return (String)map.get("result");
    }

    @Override
    public CompanyAuthStatusResponse companyAuthStatus(CompanyAuthBean request) throws Exception {
        Map<String, Object> map = this.client.doServiceByFormData("/companyauth/status", request, HttpMethod.POST);
        Map result = (Map)map.get("result");
        CompanyAuthStatusResponse response = MapUtils.toObject(result, CompanyAuthStatusResponse.class);
        return response;
    }
}

