/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.DataSignService;
import net.qiyuesuo.sdk.bean.datasign.DataSignBean;
import net.qiyuesuo.sdk.bean.datasign.DataSignRequest;
import net.qiyuesuo.sdk.bean.datasign.DataSignSignatory;
import net.qiyuesuo.sdk.bean.datasign.DataSignStatus;
import net.qiyuesuo.sdk.bean.sign.QueryDataRequest;
import net.qiyuesuo.sdk.bean.sign.VerifyResult;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpMethod;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class DataSignServiceImpl
implements DataSignService {
    private SDKClient client;

    public DataSignServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String sign(InputStream data, String bizId, String user, String cardNo, String contact, String digestSigAlgType) throws PrivateAppException {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new PrivateAppException(1000001, "bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile fileItem = new StreamFile(data);
        paramers.addFile("file", fileItem);
        paramers.addParam("businessId", bizId);
        paramers.addParam("digestSigAlgType", digestSigAlgType);
        paramers.addParam("userName", user);
        if (StringUtils.isNotBlank(cardNo)) {
            paramers.addParam("cardNo", cardNo);
        }
        paramers.addParam("contact", contact);
        Map<String, Object> result = this.client.doService("/datasign/sign", paramers);
        return (String)result.get("result");
    }

    @Override
    public String viewUrl(String bizId) throws PrivateAppException {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new PrivateAppException(1000001, "bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", bizId);
        Map<String, Object> result = this.client.doService("/datasign/viewurl", paramers);
        return (String)result.get("viewUrl");
    }

    @Override
    public String getSrcData(String bizId) throws PrivateAppException {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new PrivateAppException(1000001, "bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", bizId);
        Map<String, Object> result = this.client.doService("/datasign/getsrcdata", paramers);
        return (String)result.get("data");
    }

    @Override
    public VerifyResult getSrcAndCert(String bizId) throws PrivateAppException {
        if (bizId == null || bizId.isEmpty() || bizId.equalsIgnoreCase("null") || bizId.equalsIgnoreCase("undefined")) {
            throw new PrivateAppException(1000001, "bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", bizId);
        Map<String, Object> result = this.client.doService("/datasign/getsrcandcert", paramers);
        Map verifyMap = (Map)result.get("verifyinfo");
        VerifyResult verifyinfo = new VerifyResult();
        verifyinfo.setCertDateFrom((String)verifyMap.get("certDateFrom"));
        verifyinfo.setCertDateTo((String)verifyMap.get("certDateTo"));
        verifyinfo.setCode((Integer)verifyMap.get("code"));
        verifyinfo.setMsg((String)verifyMap.get("msg"));
        verifyinfo.setOrganization((String)verifyMap.get("organization"));
        verifyinfo.setSerialNumber((String)verifyMap.get("serialNumber"));
        verifyinfo.setSignatory((String)verifyMap.get("signatory"));
        verifyinfo.setSignDate((String)verifyMap.get("signDate"));
        verifyinfo.setSignResult((String)verifyMap.get("signResult"));
        verifyinfo.setSignTime((String)verifyMap.get("signTime"));
        verifyinfo.setSrcDate((String)verifyMap.get("srcDate"));
        verifyinfo.setStrAlgName((String)verifyMap.get("strAlgName"));
        return verifyinfo;
    }

    @Override
    public VerifyResult getSrcAndCert(QueryDataRequest queryDataRequest) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("businessId", queryDataRequest.getBizId());
        if (queryDataRequest.getSensitiveInfoInvisible() != null) {
            paramers.addParam("sensitiveInfoInvisible", String.valueOf(queryDataRequest.getSensitiveInfoInvisible()));
        }
        Map<String, Object> result = this.client.doService("/datasign/getsrcandcert", paramers);
        Map verifyMap = (Map)result.get("verifyinfo");
        VerifyResult verifyinfo = new VerifyResult(verifyMap);
        return verifyinfo;
    }

    @Override
    public Long sign(DataSignBean dataSignBean) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (dataSignBean.getData() != null) {
            paramers.addFile("data", dataSignBean.getData());
        }
        if (StringUtils.isNotBlank(dataSignBean.getDataString())) {
            paramers.addParam("dataString", dataSignBean.getDataString());
        }
        if (dataSignBean.getTenantType() != null) {
            paramers.addParam("tenantType", dataSignBean.getTenantType().toString());
        }
        paramers.addParam("dataType", dataSignBean.getDataType());
        if (dataSignBean.getSignatory() != null) {
            paramers.addParam("signatory", JSONUtils.toJson(dataSignBean.getSignatory()));
        }
        paramers.addParam("businessData", dataSignBean.getBusinessData());
        paramers.addParam("digestSigAlgType", dataSignBean.getDigestSigAlgType());
        if (dataSignBean.getNeedTsa() != null) {
            paramers.addParam("needTsa", dataSignBean.getNeedTsa().toString());
        }
        Map<String, Object> result = this.client.doService("/binary/sign", paramers);
        return Long.valueOf(String.valueOf(result.get("id")));
    }

    @Override
    public Long signV2(DataSignBean dataSignBean) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (dataSignBean.getData() != null) {
            paramers.addFile("data", dataSignBean.getData());
        }
        if (StringUtils.isNotBlank(dataSignBean.getDataString())) {
            paramers.addParam("dataString", dataSignBean.getDataString());
        }
        if (dataSignBean.getTenantType() != null) {
            paramers.addParam("tenantType", dataSignBean.getTenantType().toString());
        }
        paramers.addParam("dataType", dataSignBean.getDataType());
        if (dataSignBean.getSignatory() != null) {
            paramers.addParam("signatory", JSONUtils.toJson(dataSignBean.getSignatory()));
        }
        paramers.addParam("businessData", dataSignBean.getBusinessData());
        paramers.addParam("digestSigAlgType", dataSignBean.getDigestSigAlgType());
        if (dataSignBean.getNeedTsa() != null) {
            paramers.addParam("needTsa", dataSignBean.getNeedTsa().toString());
        }
        Map<String, Object> result = this.client.doService("/binary/sign/v2", paramers);
        return Long.valueOf(String.valueOf(result.get("id")));
    }

    @Override
    public DataSignSignatory detail(DataSignRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getId() != null) {
            paramers.addParam("id", request.getId().toString());
        }
        paramers.addParam("bizId", request.getBizId());
        Map<String, Object> result = this.client.doService("/binary/detail", paramers);
        Map dataSignSignatoryMap = (Map)result.get("result");
        DataSignSignatory dataSignSignatory = null;
        try {
            dataSignSignatory = MapUtils.toObject(dataSignSignatoryMap, DataSignSignatory.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return dataSignSignatory;
    }

    @Override
    public void download(DataSignRequest request, OutputStream outputStream) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getId() != null) {
            paramers.addParam("id", request.getId().toString());
        }
        paramers.addParam("bizId", request.getBizId());
        this.client.download("/binary/download", paramers, outputStream);
    }

    @Override
    public String signUrl(DataSignBean request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (request.getData() != null) {
            paramers.addFile("data", request.getData());
        }
        if (StringUtils.isNotBlank(request.getDataString())) {
            paramers.addParam("dataString", request.getDataString());
        }
        if (request.getTenantType() != null) {
            paramers.addParam("tenantType", request.getTenantType().toString());
        }
        paramers.addParam("dataType", request.getDataType());
        if (request.getSignatory() != null) {
            paramers.addParam("signatory", JSONUtils.toJson(request.getSignatory()));
        }
        paramers.addParam("businessData", request.getBusinessData());
        if (request.getExpireTime() != null) {
            paramers.addParam("pageConfig.expireTime", request.getExpireTime().toString());
        }
        if (request.getVisitNum() != null) {
            paramers.addParam("pageConfig.visitNum", request.getVisitNum().toString());
        }
        if (request.getPageStyle() != null) {
            paramers.addParam("pageConfig.pageStyle.themeColor", request.getPageStyle().getThemeColor());
        }
        paramers.addParam("pageConfig.invalidToPage", request.getInvalidToPage());
        if (request.getLanguage() != null) {
            paramers.addParam("pageConfig.language", request.getLanguage().toString());
        }
        paramers.addParam("oaUrl", request.getOaUrl());
        if (request.getNeedTsa() != null) {
            paramers.addParam("needTsa", request.getNeedTsa().toString());
        }
        Map<String, Object> result = this.client.doService("/binary/signurl", paramers);
        return String.valueOf(result.get("signUrl"));
    }

    @Override
    public String signUrlV2(DataSignBean request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (request.getData() != null) {
            paramers.addFile("data", request.getData());
        }
        if (StringUtils.isNotBlank(request.getDataString())) {
            paramers.addParam("dataString", request.getDataString());
        }
        if (request.getTenantType() != null) {
            paramers.addParam("tenantType", request.getTenantType().toString());
        }
        paramers.addParam("dataType", request.getDataType());
        if (request.getSignatory() != null) {
            paramers.addParam("signatory", JSONUtils.toJson(request.getSignatory()));
        }
        paramers.addParam("businessData", request.getBusinessData());
        if (request.getExpireTime() != null) {
            paramers.addParam("pageConfig.expireTime", request.getExpireTime().toString());
        }
        if (request.getVisitNum() != null) {
            paramers.addParam("pageConfig.visitNum", request.getVisitNum().toString());
        }
        if (request.getPageStyle() != null) {
            paramers.addParam("pageConfig.pageStyle.themeColor", request.getPageStyle().getThemeColor());
        }
        paramers.addParam("pageConfig.invalidToPage", request.getInvalidToPage());
        if (request.getLanguage() != null) {
            paramers.addParam("pageConfig.language", request.getLanguage().toString());
        }
        paramers.addParam("oaUrl", request.getOaUrl());
        if (request.getNeedTsa() != null) {
            paramers.addParam("needTsa", request.getNeedTsa().toString());
        }
        Map<String, Object> result = this.client.doService("/binary/signurl/v2", paramers);
        return String.valueOf(result.get("signUrl"));
    }

    @Override
    public DataSignStatus signUrlStatus(DataSignRequest request) throws PrivateAppException {
        DataSignStatus dataSignStatus;
        Map<String, Object> resultMap = this.client.doServiceByFormData("/binary/signurlstatus", request, HttpMethod.GET);
        try {
            dataSignStatus = MapUtils.toObject(resultMap, DataSignStatus.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return dataSignStatus;
    }
}

