/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.EmployeeService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.employee.InnerEmployeeRequest;
import net.qiyuesuo.sdk.bean.employee.RemoveEmployeeRequest;
import net.qiyuesuo.sdk.bean.employee.UserBean;
import net.qiyuesuo.sdk.bean.employee.UserSearchRequest;
import net.qiyuesuo.sdk.bean.role.Role;
import net.qiyuesuo.sdk.bean.user.UserAuthStatus;
import net.qiyuesuo.sdk.bean.user.UserDetail;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpMethod;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;

public class EmployeeServiceImpl
implements EmployeeService {
    private SDKClient client;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public EmployeeServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String createInnerCompanyEmployee(InnerEmployeeRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/employee/create", JSONUtils.toJson(request));
        return (String)result.get("result");
    }

    @Override
    public void quit(RemoveEmployeeRequest request) throws PrivateAppException {
        this.client.doServiceByFormData("/company/removeemployee", request, HttpMethod.GET);
    }

    @Override
    public void quitInnerCompanyEmployee(RemoveEmployeeRequest request) throws PrivateAppException {
        this.client.doServiceByFormData("/company/removeinneremployees", request, HttpMethod.GET);
    }

    @Override
    public UserDetail userDetail(UserSearchRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("mobile", request.getMobile());
        paramers.addParam("cardNo", request.getCardNo());
        paramers.addParam("number", request.getNumber());
        paramers.addParam("bizId", request.getBizId());
        paramers.addParam("email", request.getEmail());
        paramers.addParam("accountNo", request.getAccountNo());
        if (request.getId() != null) {
            paramers.addParam("id", String.valueOf(request.getId()));
        }
        Map<String, Object> result = this.client.doService("/user", paramers);
        Map authResult = (Map)result.get("result");
        UserDetail userInfo = new UserDetail();
        if (authResult.get("id") != null) {
            userInfo.setId(Long.valueOf((String)authResult.get("id")));
        }
        userInfo.setName((String)authResult.get("name"));
        userInfo.setCardNo((String)authResult.get("cardNo"));
        userInfo.setMobile((String)authResult.get("mobile"));
        userInfo.setStatus(UserAuthStatus.valueOf((String)authResult.get("status")));
        userInfo.setEmail((String)authResult.get("email"));
        userInfo.setPaperType((String)authResult.get("paperType"));
        try {
            userInfo.setApplyTime(TimeUtils.parse((String)authResult.get("applyTime")));
        }
        catch (ParseException e) {
            throw new PrivateAppException("\u7533\u8bf7\u65f6\u95f4\u8f6c\u6362\u5931\u8d25", e);
        }
        userInfo.setAuthSource((String)authResult.get("authSource"));
        userInfo.setBizId((String)authResult.get("bizId"));
        userInfo.setAccountNo((String)authResult.get("accountNo"));
        List companyList = (List)authResult.get("companies");
        try {
            List<Company> companies = MapUtils.toObjectList(companyList, Company.class);
            userInfo.setCompanies(companies);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f.\u7ed3\u679c\u8f6c\u6362\u5931\u8d25 ", e);
        }
        return userInfo;
    }

    @Override
    public List<Role> listByRoleType(Role request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        paramers.addParam("companyName", request.getCompanyName());
        paramers.addParam("registerNo", request.getRegisterNo());
        if (request.getRoleType() != null) {
            paramers.addParam("roleType", request.getRoleType().name());
        }
        Map<String, Object> result = this.client.doService("/rolelist", paramers);
        List<Role> roles = new ArrayList<Role>();
        List roleMaps = (List)result.get("result");
        if (roleMaps != null) {
            try {
                roles = MapUtils.toObjectList(roleMaps, Role.class);
            }
            catch (Exception e) {
                throw new PrivateAppException("\u6839\u636e\u89d2\u8272\u7c7b\u578b\u67e5\u8be2\u5458\u5de5,\u7ed3\u679c\u8f6c\u6362\u5931\u8d25 ", e);
            }
        }
        return roles;
    }

    @Override
    public void authNotify(UserBean userBean) throws PrivateAppException {
        this.client.doServiceWithJson("/userauth/notice", JSONUtils.toJson(userBean));
    }
}

