/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.SealService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.company.CompanyRequest;
import net.qiyuesuo.sdk.bean.page.PageVo;
import net.qiyuesuo.sdk.bean.seal.CustomParamConfig;
import net.qiyuesuo.sdk.bean.seal.Seal;
import net.qiyuesuo.sdk.bean.seal.SealCategory;
import net.qiyuesuo.sdk.bean.seal.SealCategoryCondition;
import net.qiyuesuo.sdk.bean.seal.SealCategoryVo;
import net.qiyuesuo.sdk.bean.seal.SealCondition;
import net.qiyuesuo.sdk.bean.seal.SealDeleteRequest;
import net.qiyuesuo.sdk.bean.seal.SealDetailViewRequest;
import net.qiyuesuo.sdk.bean.seal.SealEnableRequest;
import net.qiyuesuo.sdk.bean.seal.SealQueryRequest;
import net.qiyuesuo.sdk.bean.seal.SealRecord;
import net.qiyuesuo.sdk.bean.seal.SealRequest;
import net.qiyuesuo.sdk.bean.seal.SealType;
import net.qiyuesuo.sdk.bean.seal.attribute.SealAttributeListVo;
import net.qiyuesuo.sdk.bean.seal.attribute.SealAttributeVo;
import net.qiyuesuo.sdk.bean.user.UserInfoRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpMethod;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;
import net.qiyuesuo.v2sdk.request.seal.PersonalSealRequest;
import net.qiyuesuo.v2sdk.request.seal.SealV2Request;

public class SealServiceImpl
implements SealService {
    private SDKClient client;

    public SealServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public Seal detail(Long sealId, String sealOtherName) throws PrivateAppException {
        Map<String, Object> result;
        Map map;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (sealId != null) {
            paramers.addParam("sealId", String.valueOf(sealId));
        }
        if (StringUtils.isNotBlank(sealOtherName)) {
            paramers.addParam("sealOtherName", sealOtherName);
        }
        if ((map = (Map)(result = this.client.doService("/seal/detail", paramers)).get("seal")) == null) {
            return null;
        }
        Seal seal = new Seal();
        try {
            seal.setCreateTime(TimeUtils.parse((String)map.get("createTime")));
            seal.setId(map.get("id") == null ? null : Long.valueOf((String)map.get("id")));
            seal.setName(String.valueOf(map.get("name")));
            seal.setOtherName(String.valueOf(map.get("otherName")));
            seal.setOwner(map.get("owner") == null ? null : Long.valueOf((String)map.get("owner")));
            seal.setSealKey(String.valueOf(map.get("sealKey")));
            seal.setSpec(String.valueOf(map.get("spec")));
            seal.setStatus(String.valueOf(map.get("status")));
            seal.setType(SealType.valueOf(String.valueOf(map.get("type"))));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return seal;
    }

    @Override
    public Seal detail(Long sealId) throws PrivateAppException {
        Map<String, Object> result;
        Map sealMap;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (sealId != null) {
            paramers.addParam("sealId", String.valueOf(sealId));
        }
        if ((sealMap = (Map)(result = this.client.doService("/seal/detail", paramers)).get("seal")) == null) {
            return null;
        }
        Seal seal = new Seal();
        try {
            seal = MapUtils.toObject(sealMap, Seal.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seal;
    }

    @Override
    public Seal detail(SealV2Request sealRequest) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceByFormData("/seal/detail", sealRequest, HttpMethod.GET);
        Map sealMap = (Map)result.get("seal");
        if (sealMap == null) {
            return null;
        }
        Seal seal = new Seal();
        try {
            seal = MapUtils.toObject(sealMap, Seal.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seal;
    }

    @Override
    public void image(Long sealId, String sealOtherName, OutputStream outputStream) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (sealId != null) {
            paramers.addParam("sealId", String.valueOf(sealId));
        }
        if (StringUtils.isNotBlank(sealOtherName)) {
            paramers.addParam("sealOtherName", sealOtherName);
        }
        this.client.download("/seal/image", paramers, outputStream);
    }

    @Override
    public void image(Seal request, OutputStream outputStream) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (request.getId() != null) {
            paramers.addParam("sealId", String.valueOf(request.getId()));
        }
        paramers.addParam("sealName", request.getName());
        if (StringUtils.isNotBlank(request.getRegisterNo())) {
            paramers.addParam("registerNo", request.getRegisterNo());
        }
        if (StringUtils.isNotBlank(request.getCompanyName())) {
            paramers.addParam("companyName", request.getCompanyName());
        }
        if (request.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(request.getCompanyId()));
        }
        this.client.download("/seal/image", paramers, outputStream);
    }

    @Override
    public List<SealRecord> sealRecord(SealRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceByFormData("/seal/records", request, HttpMethod.GET);
        ArrayList<SealRecord> newlist = new ArrayList<SealRecord>();
        try {
            List list = (List)result.get("result");
            if (list == null) {
                return null;
            }
            SealRecord sealRecord = null;
            for (Map tmap : list) {
                sealRecord = new SealRecord();
                sealRecord.setContractId(tmap.get("contractId") == null ? null : Long.valueOf((String)tmap.get("contractId")));
                sealRecord.setCreateTime(TimeUtils.parse((String)tmap.get("createTime")));
                sealRecord.setNumber((Integer)tmap.get("number"));
                sealRecord.setSealId(tmap.get("sealId") == null ? null : Long.valueOf((String)tmap.get("sealId")));
                sealRecord.setSealName((String)tmap.get("sealName"));
                sealRecord.setSealOtherName((String)tmap.get("sealOtherName"));
                sealRecord.setSubject((String)tmap.get("subject"));
                sealRecord.setTenantId(tmap.get("tenantId") == null ? null : Long.valueOf((String)tmap.get("tenantId")));
                sealRecord.setTenantName((String)tmap.get("tenantName"));
                sealRecord.setUserId(tmap.get("userId") == null ? null : Long.valueOf((String)tmap.get("userId")));
                sealRecord.setUserName((String)tmap.get("userName"));
                sealRecord.setDeviceNo((String)tmap.get("deviceNo"));
                Object categotyObject = tmap.get("category");
                if (categotyObject != null) {
                    sealRecord.setCategory(SealCategory.valueOf((String)categotyObject));
                }
                sealRecord.setSealAttribute(tmap.get("sealAttribute") == null ? null : SealCategory.valueOf((String)tmap.get("sealAttribute")));
                sealRecord.setSealCategoryName(tmap.get("sealCategoryName") == null ? null : (String)tmap.get("sealCategoryName"));
                sealRecord.setType(tmap.get("type") == null ? null : SealType.valueOf((String)tmap.get("type")));
                newlist.add(sealRecord);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return newlist;
    }

    @Override
    public List<Seal> sealList(String category) throws PrivateAppException {
        Map<String, Object> result;
        List sealList;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (StringUtils.isNotBlank(category)) {
            paramers.addParam("category", category);
        }
        if ((sealList = (List)(result = this.client.doService("/seal/list/platform", paramers)).get("list")) == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        try {
            for (Map sealsMap : sealList) {
                seals.add(new Seal(sealsMap));
            }
        }
        catch (Exception e) {
            throw new PrivateAppException("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public List<Seal> sealList(Long companyId, String companyName, String category) throws PrivateAppException {
        Map<String, Object> result;
        List sealList;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (companyId != null) {
            paramers.addParam("companyId", companyId.toString());
        }
        if (StringUtils.isNotBlank(companyName)) {
            paramers.addParam("companyName", companyName);
        }
        if (StringUtils.isNotBlank(category)) {
            paramers.addParam("category", category);
        }
        if ((sealList = (List)(result = this.client.doService("/seal/list", paramers)).get("list")) == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        try {
            for (Map sealsMap : sealList) {
                seals.add(new Seal(sealsMap));
            }
        }
        catch (Exception e) {
            throw new PrivateAppException("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public List<Seal> sealList(CompanyRequest companyRequest, String category, String sealAttribute, String sealCategoryName) throws PrivateAppException {
        Map<String, Object> result;
        List sealList;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (companyRequest.getCompanyId() != null) {
            paramers.addParam("companyId", companyRequest.getCompanyId().toString());
        }
        if (StringUtils.isNotBlank(companyRequest.getCompanyName())) {
            paramers.addParam("companyName", companyRequest.getCompanyName());
        }
        if (StringUtils.isNotBlank(companyRequest.getOpenCompanyId())) {
            paramers.addParam("openCompanyId", companyRequest.getOpenCompanyId());
        }
        if (StringUtils.isNotBlank(companyRequest.getRegisterNo())) {
            paramers.addParam("registerNo", companyRequest.getRegisterNo());
        }
        if (StringUtils.isNotBlank(category)) {
            paramers.addParam("category", category);
        }
        if (StringUtils.isNotBlank(sealAttribute)) {
            paramers.addParam("sealAttribute", sealAttribute);
        }
        if (StringUtils.isNotBlank(sealCategoryName)) {
            paramers.addParam("sealCategoryName", sealCategoryName);
        }
        if ((sealList = (List)(result = this.client.doService("/seal/list", paramers)).get("list")) == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        try {
            for (Map sealsMap : sealList) {
                seals.add(new Seal(sealsMap));
            }
        }
        catch (Exception e) {
            throw new PrivateAppException("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public List<Seal> sealListAll(String category) throws PrivateAppException {
        Map<String, Object> result;
        List sealList;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (StringUtils.isNotBlank(category)) {
            paramers.addParam("category", category);
        }
        if ((sealList = (List)(result = this.client.doService("/seal/list/all", paramers)).get("list")) == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        try {
            for (Map sealsMap : sealList) {
                seals.add(new Seal(sealsMap));
            }
        }
        catch (Exception e) {
            throw new PrivateAppException("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public List<Seal> sealAllContainsOAUserIDs(String category) throws PrivateAppException {
        Map<String, Object> result;
        List sealList;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (StringUtils.isNotBlank(category)) {
            paramers.addParam("category", category);
        }
        if ((sealList = (List)(result = this.client.doService("/seal/oa/all", paramers)).get("list")) == null) {
            return null;
        }
        ArrayList<Seal> seals = new ArrayList<Seal>();
        try {
            for (Map sealsMap : sealList) {
                int index;
                Seal seal = new Seal(sealsMap);
                if (StringUtils.isNotBlank(seal.getStatus()) && (index = seal.getStatus().indexOf("key")) > -1) {
                    seal.setStatus(seal.getStatus().substring(index + 4, seal.getStatus().length() - 1));
                }
                seal.setOaUserIds(String.valueOf(sealsMap.get("oaUserIds")));
                seals.add(seal);
            }
        }
        catch (Exception e) {
            throw new PrivateAppException("\u89e3\u6790\u8fd4\u56de\u6570\u636e\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public Seal createCompanySeal(Seal seal, String image) throws PrivateAppException {
        Map<String, Object> result;
        Map map;
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (seal.getOwner() != null) {
            paramers.addParam("owner", String.valueOf(seal.getOwner()));
        }
        if (StringUtils.isNotBlank(seal.getName())) {
            paramers.addParam("name", seal.getName());
        }
        if (StringUtils.isNotBlank(seal.getOtherName())) {
            paramers.addParam("otherName", seal.getOtherName());
        }
        if (StringUtils.isNotBlank(image)) {
            paramers.addParam("image", image);
        }
        if (seal.getSpec() != null) {
            paramers.addParam("spec", seal.getSpec());
        }
        if (StringUtils.isNotBlank(seal.getRegisterNo())) {
            paramers.addParam("registerNo", seal.getRegisterNo());
        }
        if (StringUtils.isNotBlank(seal.getCompanyName())) {
            paramers.addParam("companyName", seal.getCompanyName());
        }
        if (seal.getCompanyId() != null) {
            paramers.addParam("companyId", String.valueOf(seal.getCompanyId()));
        }
        if (StringUtils.isNotBlank(seal.getSealCategoryName())) {
            paramers.addParam("sealCategoryName", seal.getSealCategoryName());
        }
        if ((map = (Map)(result = this.client.doService("/seal/create/company", paramers)).get("result")) == null) {
            return null;
        }
        Seal tempSeal = new Seal();
        try {
            tempSeal.setCreateTime(TimeUtils.parse((String)map.get("createTime")));
            tempSeal.setId(map.get("id") == null ? null : Long.valueOf((String)map.get("id")));
            tempSeal.setName(String.valueOf(map.get("name")));
            tempSeal.setOtherName(String.valueOf(map.get("otherName")));
            tempSeal.setOwner(map.get("owner") == null ? null : Long.valueOf((String)map.get("owner")));
            tempSeal.setSealKey(String.valueOf(map.get("sealKey")));
            tempSeal.setSpec(String.valueOf(map.get("spec")));
            tempSeal.setStatus(String.valueOf(map.get("status")));
            tempSeal.setType(SealType.valueOf(String.valueOf(map.get("type"))));
            tempSeal.setSealAttribute(map.get("sealAttribute") == null ? null : SealCategory.valueOf((String)map.get("sealAttribute")));
            tempSeal.setSealCategoryName(map.get("sealCategoryName") == null ? null : (String)map.get("sealCategoryName"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tempSeal;
    }

    @Override
    public Seal getSealByCategory(Long categoryId) throws PrivateAppException {
        Map<String, Object> result;
        Map map;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (categoryId != null) {
            paramers.addParam("categoryId", String.valueOf(categoryId));
        }
        if ((map = (Map)(result = this.client.doService("/seal/getbycategory", paramers)).get("seal")) == null) {
            return null;
        }
        Seal tempSeal = new Seal();
        try {
            tempSeal.setCreateTime(TimeUtils.parse((String)map.get("createTime")));
            tempSeal.setId(map.get("id") == null ? null : Long.valueOf((String)map.get("id")));
            tempSeal.setName(String.valueOf(map.get("name")));
            tempSeal.setOtherName(String.valueOf(map.get("otherName")));
            tempSeal.setOwner(map.get("owner") == null ? null : Long.valueOf((String)map.get("owner")));
            tempSeal.setSealKey(String.valueOf(map.get("sealKey")));
            tempSeal.setSpec(String.valueOf(map.get("spec")));
            tempSeal.setStatus(String.valueOf(map.get("status")));
            tempSeal.setType(SealType.valueOf(String.valueOf(map.get("type"))));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tempSeal;
    }

    @Override
    public List<Seal> getSealByUser(String mobile, String companyName) throws PrivateAppException {
        List<Seal> seals;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (StringUtils.isBlank(mobile)) {
            throw new PrivateAppException("\u8bf7\u8f93\u5165\u7528\u6237\u624b\u673a\u53f7");
        }
        if (StringUtils.isBlank(companyName)) {
            throw new PrivateAppException("\u8bf7\u8f93\u5165\u516c\u53f8\u540d\u79f0");
        }
        paramers.addParam("mobile", mobile);
        paramers.addParam("companyName", companyName);
        Map<String, Object> result = this.client.doService("/seal/user/charge", paramers);
        List sealList = (List)result.get("result");
        if (sealList == null) {
            return null;
        }
        try {
            seals = MapUtils.toObjectList(sealList, Seal.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public List<Seal> getSealByEmployee(String number, String companyName) throws PrivateAppException {
        List<Seal> seals;
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("employeeNo", number);
        paramers.addParam("companyName", companyName);
        Map<String, Object> result = this.client.doService("/seal/user/charge", paramers);
        List sealList = (List)result.get("result");
        if (sealList == null) {
            return null;
        }
        try {
            seals = MapUtils.toObjectList(sealList, Seal.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public List<Seal> getSealByUserInfo(SealQueryRequest request) throws PrivateAppException {
        List<Seal> seals;
        Map<String, Object> result = this.client.doServiceByFormData("/seal/user/charge", request, HttpMethod.GET);
        List sealList = (List)result.get("result");
        if (sealList == null) {
            return null;
        }
        try {
            seals = MapUtils.toObjectList(sealList, Seal.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return seals;
    }

    @Override
    public void personalSealImage(Long userId, String mobile, String cardNo, OutputStream outputStream) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        if (userId != null) {
            params.addParam("userId", String.valueOf(userId));
        }
        if (StringUtils.isNotBlank(mobile)) {
            params.addParam("mobile", mobile);
        }
        if (StringUtils.isNotBlank(cardNo)) {
            params.addParam("cardNo", cardNo);
        }
        this.client.download("/seal/personalsealimage", params, outputStream);
    }

    @Override
    public void personalSealImage(UserInfoRequest userInfoRequest, OutputStream outputStream) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        Map<String, Object> map = MapUtils.oldEntityToMap(userInfoRequest);
        for (String key : map.keySet()) {
            Object o = map.get(key);
            if (o == null) continue;
            params.addParam(key, String.valueOf(o));
        }
        this.client.download("/seal/personalsealimage", params, outputStream);
    }

    @Override
    public void personalSealImages(SealCondition condition, OutputStream outputStream) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        if (condition.getStartTime() != null) {
            params.addParam("startTime", TimeUtils.format(condition.getStartTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (condition.getEndTime() != null) {
            params.addParam("endTime", TimeUtils.format(condition.getEndTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        this.client.download("/seal/personalsealimages", params, outputStream);
    }

    @Override
    public void timeStampImage(OutputStream outputStream) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        this.client.download("/seal/timestampimage", params, outputStream);
    }

    @Override
    public List<Company> innercompanySealList(SealCondition condition) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        if (condition.getCategory() != null) {
            paramers.addParam("category", condition.getCategory().toString());
        }
        if (condition.getUpdateTimeStart() != null) {
            paramers.addParam("updateTimeStart", TimeUtils.format(condition.getUpdateTimeStart(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (condition.getUpdateTimeEnd() != null) {
            paramers.addParam("updateTimeEnd", TimeUtils.format(condition.getUpdateTimeEnd(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (condition.getGetDeleteData() != null) {
            paramers.addParam("getDeleteData", condition.getGetDeleteData().toString());
        }
        paramers.addParam("sealQueryStatus", condition.getSealQueryStatus());
        if (condition.getSealAttribute() != null) {
            paramers.addParam("sealAttribute", condition.getSealAttribute().toString());
        }
        if (StringUtils.isNotBlank(condition.getSealCategoryName())) {
            paramers.addParam("sealCategoryName", condition.getSealCategoryName());
        }
        Map<String, Object> result = this.client.doService("/seal/innercompany/seallist", paramers);
        List compamyMaps = (List)result.get("result");
        List<Company> companies = null;
        try {
            companies = MapUtils.toObjectList(compamyMaps, Company.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return companies;
    }

    @Override
    public void enable(boolean enable, Long sealId, String sealName) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        if (sealId != null) {
            params.addParam("sealId", String.valueOf(sealId));
        }
        params.addParam("sealName", sealName);
        params.addParam("enable", String.valueOf(enable));
        this.client.doService("/seal/physics/enable", params);
    }

    @Override
    public void enable(SealEnableRequest request) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        if (request.getSealId() != null) {
            params.addParam("sealId", String.valueOf(request.getSealId()));
        }
        params.addParam("sealName", request.getSealName());
        params.addParam("sealCategoryName", request.getSealCategoryName());
        params.addParam("enable", String.valueOf(request.isEnable()));
        this.client.doService("/seal/physics/enable", params);
    }

    @Override
    public void delete(Long sealId, String sealName) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        if (sealId != null) {
            params.addParam("sealId", String.valueOf(sealId));
        }
        params.addParam("sealName", sealName);
        this.client.doService("/seal/physics/delete", params);
    }

    @Override
    public void delete(SealDeleteRequest request) throws PrivateAppException {
        HttpParamers params = HttpParamers.httpGetParamers();
        if (request.getSealId() != null) {
            params.addParam("sealId", String.valueOf(request.getSealId()));
        }
        params.addParam("sealName", request.getSealName());
        params.addParam("sealCategoryName", request.getSealCategoryName());
        this.client.doService("/seal/physics/delete", params);
    }

    @Override
    public PageVo<SealCategoryVo> listSealCategory(SealCategoryCondition categoryCondition) throws PrivateAppException {
        Map<String, Object> stringObjectMap = this.client.doServiceByFormData("/sealcategory/list", categoryCondition, HttpMethod.GET);
        Map result = (Map)stringObjectMap.get("result");
        PageVo<SealCategoryVo> vo = new PageVo<SealCategoryVo>();
        try {
            vo.setPageNo((Integer)result.get("pageNo"));
            vo.setHasNext((Boolean)result.get("hasNext"));
            vo.setPageSize((Integer)result.get("pageSize"));
            vo.setTotalCount(((Integer)result.get("totalCount")).intValue());
            List pageResult = (List)result.get("result");
            List<SealCategoryVo> voList = MapUtils.toObjectList(pageResult, SealCategoryVo.class);
            vo.setResult(voList);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return vo;
    }

    @Override
    public SealAttributeListVo listSealAttribute() throws PrivateAppException {
        SealAttributeListVo v;
        Map<String, Object> stringObjectMap = this.client.doService("/sealattribute/list", HttpParamers.httpGetParamers());
        Map result = (Map)stringObjectMap.get("result");
        try {
            v = MapUtils.toObject(result, SealAttributeListVo.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return v;
    }

    @Override
    public SealAttributeVo sealAttributeBySealCategory(String sealCategory) throws PrivateAppException {
        SealAttributeVo v;
        HttpParamers httpParamers = HttpParamers.httpGetParamers();
        httpParamers.addParam("sealCategory", sealCategory);
        Map<String, Object> stringObjectMap = this.client.doService("/sealattribute/get/bysealcategory", httpParamers);
        Map result = (Map)stringObjectMap.get("result");
        try {
            v = MapUtils.toObject(result, SealAttributeVo.class);
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return v;
    }

    @Override
    public Seal createPersonlSeal(PersonalSealRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (request.getImgFile() != null) {
            paramers.addFile("imgFile", request.getImgFile());
        }
        if (StringUtils.isNotBlank(request.getUser())) {
            paramers.addParam("user", request.getUser());
        }
        paramers.addParam("imgFileBase64", request.getImgFileBase64());
        paramers.addParam("primary", String.valueOf(request.isPrimary()));
        if (request.getWidth() != null) {
            paramers.addParam("width", String.valueOf(request.getWidth()));
        }
        if (request.getHeight() != null) {
            paramers.addParam("height", String.valueOf(request.getHeight()));
        }
        Map<String, Object> result = this.client.doService("/seal/personal/create", paramers);
        Seal seal = null;
        Map temp = (Map)result.get("result");
        try {
            seal = MapUtils.toObject(temp, Seal.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return seal;
    }

    @Override
    public String sealViewUrl(SealDetailViewRequest request) throws PrivateAppException {
        String sealViewUrl = null;
        Map<String, Object> map = this.client.doServiceWithJson("/seal/viewurl", JSONUtils.toJson(request));
        if ((Integer)map.get("code") == 0) {
            sealViewUrl = (String)map.get("sealViewUrl");
        }
        return sealViewUrl;
    }

    @Override
    public List<CustomParamConfig> queryCustomParamConfig() {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        Map<String, Object> result = this.client.doService("/seal/query/customparam", paramers);
        List<CustomParamConfig> customParamConfigs = null;
        List customParamConfigMaps = (List)result.get("result");
        try {
            customParamConfigs = MapUtils.toObjectList(customParamConfigMaps, CustomParamConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PrivateAppException("\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return customParamConfigs;
    }
}

