/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.UserService;
import net.qiyuesuo.sdk.bean.employee.UserBean;
import net.qiyuesuo.sdk.bean.user.ChangeMobileRequest;
import net.qiyuesuo.sdk.bean.user.User;
import net.qiyuesuo.sdk.bean.user.UserInfoRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;

public class UserServiceImpl
implements UserService {
    private SDKClient client;

    public UserServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public void deleteUnceritifiedUser(User user) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (user.getUserId() != null) {
            paramers.addParam("userId", String.valueOf(user.getUserId()));
        }
        paramers.addParam("contact", user.getContact());
        this.client.doService("/user/delete", paramers);
    }

    @Override
    public void deleteUnCeritifiedUser(UserInfoRequest userInfoRequest) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        if (userInfoRequest.getUserId() != null) {
            paramers.addParam("userId", String.valueOf(userInfoRequest.getUserId()));
        }
        paramers.addParam("contact", userInfoRequest.getContact());
        paramers.addParam("mobile", userInfoRequest.getMobile());
        paramers.addParam("email", userInfoRequest.getEmail());
        paramers.addParam("cardNo", userInfoRequest.getCardNo());
        paramers.addParam("openUserId", userInfoRequest.getOpenUserId());
        paramers.addParam("number", userInfoRequest.getNumber());
        paramers.addParam("accountNo", userInfoRequest.getAccountNo());
        this.client.doService("/user/delete", paramers);
    }

    @Override
    public void changeMobileNotify(ChangeMobileRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("oldMobile", request.getOldMobile());
        paramers.addParam("newMobile", request.getNewMobile());
        this.client.doService("/user/changemobile", paramers);
    }

    @Override
    public String getAuthUrl(UserBean userBean) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/userauth/authurl", JSONUtils.toJson(userBean));
        String authUrl = (String)result.get("result");
        return authUrl;
    }

    @Override
    public String getAuthUrl2(UserBean userBean) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/userauth/authurl2", JSONUtils.toJson(userBean));
        String authUrl = (String)result.get("result");
        return authUrl;
    }

    @Override
    public String userAuthIdentify(UserBean userBean) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/userauth/identify", JSONUtils.toJson(userBean));
        return JSONUtils.toJson(result);
    }
}

