/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.v2sdk;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Mac;
import net.qiyuesuo.sdk.common.crypt.Hmac;
import net.qiyuesuo.sdk.common.crypt.MD5;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.HttpHeader;
import net.qiyuesuo.sdk.common.parameter.ParameterBody;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.v2sdk.exception.BaseSdkException;
import net.qiyuesuo.v2sdk.http.HttpClient;
import net.qiyuesuo.v2sdk.http.HttpParameter;
import net.qiyuesuo.v2sdk.request.SdkRequest;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkV2Client {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int connectTimeout = 30000;
    private int readTimeout = 120000;
    private String serviceUrl;
    private String accessToken;
    private String accessSecret;
    private String signatureVersion;
    private String traceId;

    public SdkV2Client(String serviceUrl, String accessToken, String accessSecret) {
        this.serviceUrl = serviceUrl;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
        this.signatureVersion = "MD5";
    }

    public SdkV2Client(String serviceUrl, String accessToken, String accessSecret, String signatureVersion, String traceId) {
        this.serviceUrl = serviceUrl;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
        this.traceId = traceId;
        this.signatureVersion = StringUtils.isEmpty(signatureVersion) ? "MD5" : signatureVersion;
    }

    public String service(SdkRequest request) throws BaseSdkException {
        try {
            return this.service(request, null);
        }
        catch (Exception e) {
            throw new BaseSdkException(e.getMessage(), e);
        }
    }

    public String service(SdkRequest request, String idempotentKey) throws BaseSdkException {
        String requestDirectoryName = UUID.randomUUID().toString().replace("-", "");
        String url = this.serviceUrl + request.getUrl();
        HttpParameter httpParameter = request.getHttpParameter();
        HttpHeader header = this.buildHttpHeader(httpParameter, requestDirectoryName);
        if (StringUtils.isNotBlank(idempotentKey)) {
            header.setIdempotentToken(idempotentKey);
        }
        try {
            if (httpParameter.isJson()) {
                this.logger.debug("jsonParams:{}", (Object)httpParameter.getJsonParams());
                String string = HttpClient.doServiceWithJson(url, httpParameter.getJsonParams(), header, this.connectTimeout, this.readTimeout);
                return string;
            }
            String string = HttpClient.doService(url, httpParameter, header, this.connectTimeout, this.readTimeout, this.signatureVersion);
            return string;
        }
        catch (Exception e) {
            throw new BaseSdkException(e.getMessage(), e);
        }
        finally {
            if ("HMACSHA256".equals(this.signatureVersion)) {
                File file = new File("." + File.separator + "bigfile" + File.separator + requestDirectoryName);
                SdkV2Client.deleteDir(file);
            }
        }
    }

    public static void deleteDir(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    SdkV2Client.deleteDir(file);
                    continue;
                }
                if (!file.exists()) continue;
                file.delete();
            }
        }
        if (directory.exists()) {
            directory.delete();
        }
    }

    public void download(SdkRequest request, OutputStream outputStream) throws BaseSdkException {
        String url = this.serviceUrl + request.getUrl();
        HttpParameter httpParameter = request.getHttpParameter();
        HttpHeader header = this.buildHttpHeader(httpParameter, null);
        try {
            if (httpParameter.isJson()) {
                this.logger.debug("jsonParams:{}", (Object)httpParameter.getJsonParams());
                HttpClient.doDownloadWithJson(url, httpParameter.getJsonParams(), header, outputStream, this.connectTimeout, this.readTimeout);
            } else {
                HttpClient.doDownload(url, request.getHttpParameter(), header, this.connectTimeout, this.readTimeout, outputStream);
            }
        }
        catch (Exception e) {
            throw new BaseSdkException(e.getMessage(), e);
        }
    }

    private HttpHeader buildHttpHeader(HttpParameter httpParameter, String requestDirectoryName) {
        Long timestamp = System.currentTimeMillis();
        String nonce = UUID.randomUUID().toString();
        this.traceId = StringUtils.isNotBlank(this.traceId) ? this.traceId : "";
        String signature = "";
        if ("HMACSHA256".equals(this.signatureVersion)) {
            ArrayList<ParameterBody> hmacSignatureList = new ArrayList<ParameterBody>();
            this.builderCommonParam(hmacSignatureList, timestamp + "", nonce, this.traceId);
            if (httpParameter.isJson()) {
                hmacSignatureList.add(new ParameterBody("x-qys-body", httpParameter.getJsonParams(), null));
            } else {
                hmacSignatureList.add(new ParameterBody("x-qys-body", "", null));
                this.builderParams(httpParameter, hmacSignatureList);
            }
            signature = this.calculateSignature(httpParameter.getHttpMethod().toString(), hmacSignatureList, httpParameter, requestDirectoryName);
        } else {
            signature = MD5.toMD5(this.accessToken + this.accessSecret + timestamp + nonce);
        }
        return new HttpHeader(this.accessToken, timestamp, signature, nonce, this.signatureVersion, "", this.traceId);
    }

    private void builderCommonParam(List<ParameterBody> hmacSignatureList, String timestamp, String nonce, String traceId) {
        hmacSignatureList.add(new ParameterBody("x-qys-accesstoken", this.accessToken, null));
        hmacSignatureList.add(new ParameterBody("x-qys-timestamp", timestamp + "", null));
        hmacSignatureList.add(new ParameterBody("x-qys-nonce", nonce, null));
        hmacSignatureList.add(new ParameterBody("x-qys-signature-version", this.signatureVersion, null));
        hmacSignatureList.add(new ParameterBody("x-qys-clienttoken", "", null));
        hmacSignatureList.add(new ParameterBody("x-qys-traceid", traceId, null));
    }

    private void builderParams(HttpParameter httpParamers, List<ParameterBody> hmacSignatureList) {
        String key;
        Set<Map.Entry<String, String>> textEntrySet = httpParamers.getParams().entrySet();
        HashSet<String> removeKey = new HashSet<String>();
        for (Map.Entry<String, String> textEntry : textEntrySet) {
            String string = textEntry.getKey();
            String value = textEntry.getValue();
            if (StringUtils.isNoneEmpty(string, value)) {
                if (!StringUtils.isNotBlank(string.trim())) continue;
                hmacSignatureList.add(new ParameterBody(textEntry.getKey(), textEntry.getValue(), null));
                continue;
            }
            removeKey.add(string);
        }
        if (!httpParamers.getFiles().isEmpty()) {
            Set<Map.Entry<String, FileItem>> fileEntrySet = httpParamers.getFiles().entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                key = entry.getKey();
                if (!StringUtils.isNotBlank(key.trim())) continue;
                hmacSignatureList.add(new ParameterBody(key, null, entry.getValue().getFileDirectoryName()));
            }
        }
        if (!httpParamers.getListFiles().isEmpty()) {
            Set<Map.Entry<String, List<FileItem>>> listEntrySet = httpParamers.getListFiles().entrySet();
            for (Map.Entry<String, Object> entry : listEntrySet) {
                key = entry.getKey();
                if (!StringUtils.isNotBlank(key.trim())) continue;
                List items = (List)entry.getValue();
                for (FileItem item : items) {
                    hmacSignatureList.add(new ParameterBody(key, null, item.getFileDirectoryName()));
                }
            }
        }
    }

    private String calculateSignature(String method, List<ParameterBody> hmacSignatureList, HttpParameter paramers, String requestDirectoryName) {
        HashMap<String, FileItem> fileItemMap = new HashMap<String, FileItem>();
        for (FileItem fileItem : paramers.getFiles().values()) {
            fileItemMap.put(fileItem.getFileDirectoryName(), fileItem);
        }
        for (List list : paramers.getListFiles().values()) {
            for (FileItem fileItem : list) {
                fileItemMap.put(fileItem.getFileDirectoryName(), fileItem);
            }
        }
        Collections.sort(hmacSignatureList, new Comparator<ParameterBody>(){

            @Override
            public int compare(ParameterBody s1, ParameterBody s2) {
                return s1.getName().compareTo(s2.getName());
            }
        });
        Mac mac = Hmac.getMac(this.accessSecret);
        mac.update(method.getBytes(StandardCharsets.UTF_8));
        for (ParameterBody parameterBody : hmacSignatureList) {
            String str = "&" + parameterBody.getName() + "=";
            mac.update(str.getBytes(StandardCharsets.UTF_8));
            String fileKey = parameterBody.getFileKey();
            if (StringUtils.isNotBlank(fileKey)) {
                FileItem file = (FileItem)fileItemMap.get(fileKey);
                file.setRequestDirectoryName(requestDirectoryName);
                file.readStreamAndcalculateSignature(mac);
                continue;
            }
            String value = parameterBody.getValue();
            if (!StringUtils.isNotBlank(value)) continue;
            mac.update(value.getBytes(StandardCharsets.UTF_8));
        }
        String string = Hex.encodeHexString((byte[])mac.doFinal());
        return string;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

