/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.common.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import javax.crypto.Mac;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFile
implements FileItem {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String fileName;
    private InputStream stream;
    private String mimeType;
    private byte[] requestBody;
    private Boolean bigFile;
    private String requestDirectoryName;
    private String fileDirectoryName;
    private Integer tempFileNum;
    private static final String DEFAULT_FILE_NAME = "streamFile";

    public StreamFile(String fileName, InputStream stream, String mimeType) {
        this.fileName = fileName;
        this.stream = stream;
        this.mimeType = mimeType;
        this.fileDirectoryName = UUID.randomUUID().toString().replace("-", "");
    }

    public StreamFile(String fileName, InputStream stream) {
        this.fileName = fileName;
        this.stream = stream;
        this.mimeType = "application/octet-stream";
        this.fileDirectoryName = UUID.randomUUID().toString().replace("-", "");
    }

    public StreamFile(InputStream stream) {
        this.fileName = DEFAULT_FILE_NAME;
        this.stream = stream;
        this.mimeType = "application/octet-stream";
        this.fileDirectoryName = UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public void setRequestDirectoryName(String requestDirectoryName) {
        this.requestDirectoryName = requestDirectoryName;
    }

    public String getRequestDirectoryName() {
        return this.requestDirectoryName;
    }

    @Override
    public String getFileDirectoryName() {
        return this.fileDirectoryName;
    }

    @Override
    public byte[] getRequestBody() {
        return this.requestBody;
    }

    @Override
    public boolean isValid() {
        return this.stream != null && this.fileName != null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getMimeType() {
        if (this.mimeType == null) {
            return "application/octet-stream";
        }
        return this.mimeType;
    }

    @Override
    public long getFileLength() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readStreamAndcalculateSignature(Mac mac) {
        try {
            int available = this.stream.available();
            if (available < 0x6400000) {
                this.bigFile = false;
                this.requestBody = IOUtils.readStreamAsByteArray(this.stream);
                mac.update(this.requestBody);
            } else {
                int n;
                this.bigFile = true;
                String directoryPath = "." + File.separator + "bigfile" + File.separator + this.requestDirectoryName + File.separator + this.fileDirectoryName;
                File file = new File(directoryPath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                Integer i = 0;
                byte[] buffer = new byte[0xA00000];
                while ((n = this.stream.read(buffer)) != -1) {
                    mac.update(buffer, 0, n);
                    FileOutputStream out = null;
                    FileChannel channel = null;
                    try {
                        Integer n2 = i;
                        Integer n3 = i = Integer.valueOf(i + 1);
                        out = new FileOutputStream(directoryPath + File.separator + n2 + ".temp");
                        channel = out.getChannel();
                        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, n);
                        channel.write(byteBuffer);
                    }
                    catch (Throwable throwable) {
                        IOUtils.safeClose(channel);
                        IOUtils.safeClose(out);
                        throw throwable;
                    }
                    IOUtils.safeClose(channel);
                    IOUtils.safeClose(out);
                }
                this.tempFileNum = i;
            }
        }
        catch (IOException e) {
            this.logger.error("read stream error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.safeClose(this.stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream output, String signatureVersion) throws IOException {
        block10: {
            block11: {
                if ("MD5".equals(signatureVersion)) {
                    byte[] buffer = new byte[4096];
                    int n = 0;
                    try {
                        while (-1 != (n = this.stream.read(buffer))) {
                            output.write(buffer, 0, n);
                        }
                    }
                    finally {
                        IOUtils.safeClose(this.stream);
                    }
                }
                if (!"HMACSHA256".equals(signatureVersion)) break block10;
                if (this.bigFile.booleanValue()) break block11;
                output.write(this.requestBody);
                break block10;
            }
            for (int i = 0; i < this.tempFileNum; ++i) {
                RandomAccessFile reader = null;
                FileChannel channel = null;
                try {
                    String directoryPath = "." + File.separator + "bigfile" + File.separator + this.requestDirectoryName + File.separator + this.fileDirectoryName + File.separator + i + ".temp";
                    reader = new RandomAccessFile(directoryPath, "r");
                    channel = reader.getChannel();
                    ByteBuffer buff = ByteBuffer.allocate(0x100000);
                    while (channel.read(buff) != -1) {
                        output.write(buff.array(), 0, buff.position());
                        buff.clear();
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.safeClose(channel);
                    IOUtils.safeClose(reader);
                    throw throwable;
                }
                IOUtils.safeClose(channel);
                IOUtils.safeClose(reader);
            }
        }
    }
}

