/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.qiyuesuo.ParamsHandle;
import net.qiyuesuo.sdk.bean.user.UserInfoRequest;
import net.qiyuesuo.sdk.common.json.JSONObject;
import net.qiyuesuo.sdk.common.utils.StringUtils;
import net.qiyuesuo.sdk.common.utils.TimeUtils;

public class MapUtils {
    public static <T> T toObject(Map<String, Object> map, Class<T> beanClass) throws Exception {
        T bean = null;
        try {
            if (beanClass.isEnum()) {
                T[] enumConstants = beanClass.getEnumConstants();
                if (enumConstants == null || enumConstants.length == 0) {
                    return null;
                }
                return MapUtils.getEnumBean(map, enumConstants);
            }
            bean = beanClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (map == null || map.isEmpty()) {
            return bean;
        }
        for (String methodName : map.keySet()) {
            Set value = map.get(methodName);
            if (value == null) continue;
            Field beanField = null;
            try {
                beanField = beanClass.getDeclaredField(methodName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            if (beanField == null) continue;
            beanField.setAccessible(true);
            String methodType = beanField.getType().getName();
            if (beanField.getType().isAssignableFrom(String.class)) {
                value = value instanceof Map ? JSONObject.valueToString(value) : value.toString();
            } else if (beanField.getType().isAssignableFrom(Long.class) || beanField.getType().getName().equals("long")) {
                value = Long.parseLong(value.toString());
            } else if (beanField.getType().isAssignableFrom(Integer.class) || beanField.getType().getName().equals("int")) {
                value = Integer.parseInt(value.toString());
            } else if (beanField.getType().isAssignableFrom(Float.class) || beanField.getType().getName().equals("float")) {
                value = Float.valueOf(Float.parseFloat(value.toString()));
            } else if (beanField.getType().isAssignableFrom(Double.class) || beanField.getType().getName().equals("double")) {
                value = Double.parseDouble(value.toString());
            } else if (beanField.getType().isAssignableFrom(Boolean.class) || beanField.getType().getName().equals("boolean")) {
                value = Boolean.parseBoolean(value.toString());
            } else if (beanField.getType().isAssignableFrom(Date.class)) {
                value = TimeUtils.parse(value.toString());
            } else if (beanField.getType().isAssignableFrom(Set.class)) {
                value = StringUtils.StringToSet(value.toString());
            } else if (beanField.getType().isEnum()) {
                value = MapUtils.convertToEnum(methodType, value);
            } else if (beanField.getType().isAssignableFrom(ArrayList.class)) {
                ParameterizedType pt = (ParameterizedType)beanField.getGenericType();
                Class listClass = (Class)pt.getActualTypeArguments()[0];
                if (!MapUtils.guessType(listClass)) {
                    ArrayList<T> objects = new ArrayList<T>();
                    List maps = (List)((Object)value);
                    for (Map tempMap : maps) {
                        T object = MapUtils.toObject(tempMap, listClass);
                        objects.add(object);
                    }
                    value = objects;
                }
            } else {
                Class<?> tempClass = beanField.getType();
                Map tempMap = (Map)((Object)value);
                value = MapUtils.toObject(tempMap, tempClass);
            }
            try {
                String methodName1 = "set" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                Method method = beanClass.getMethod(methodName1, beanField.getType());
                method.invoke(bean, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bean;
    }

    private static <T> T getEnumBean(Map<String, Object> map, T[] enumConstants) {
        String key = (String)map.get("key");
        for (T enumConstant : enumConstants) {
            if (!enumConstant.toString().equals(key)) continue;
            return enumConstant;
        }
        return null;
    }

    private static boolean guessType(Class clas) {
        String[] types;
        for (String str : types = new String[]{"java.lang.Integer", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Short", "java.lang.Byte", "java.lang.Boolean", "java.lang.Character", "java.lang.String", "int", "double", "long", "short", "byte", "boolean", "char", "float"}) {
            if (!str.equals(clas.getName())) continue;
            return true;
        }
        return false;
    }

    private static Enum convertToEnum(String enumName, Object value) throws Exception {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(enumName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            Enum myE = (Enum)value;
            return myE;
        }
        try {
            return Enum.valueOf(clazz, value.toString());
        }
        catch (Exception exception) {
            return (Enum)MapUtils.toObject((Map)value, clazz);
        }
    }

    public static <T> List<T> toObjectList(List<Map<String, Object>> maps, Class<T> beanClass) throws Exception {
        if (maps == null || maps.size() < 0) {
            return null;
        }
        ArrayList<T> beanList = new ArrayList<T>();
        for (Map<String, Object> tempMap : maps) {
            T bean = MapUtils.toObject(tempMap, beanClass);
            beanList.add(bean);
        }
        return beanList;
    }

    public static Map<String, Object> oldEntityToMap(Object object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = object.getClass(); tempClass != null && !"java.lang.object".equalsIgnoreCase(tempClass.getName()); tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (Field field : fieldList) {
            try {
                boolean flag = field.isAccessible();
                field.setAccessible(true);
                Object o = field.get(object);
                if (o == null) continue;
                if (o instanceof UserInfoRequest) {
                    Map<String, Object> userInfoMap = MapUtils.oldEntityToMap(o);
                    for (Map.Entry<String, Object> entry : userInfoMap.entrySet()) {
                        map.put(field.getName().concat(".") + entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                boolean annotationPresent = field.isAnnotationPresent(ParamsHandle.class);
                if (annotationPresent) {
                    Map<String, Object> stringObjectMap = MapUtils.oldEntityToMap(o);
                    for (Map.Entry<String, Object> entry : stringObjectMap.entrySet()) {
                        map.put(field.getName().concat(".") + entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                map.put(field.getName(), o);
                field.setAccessible(flag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Map<String, Object> entityToMap(Object object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = object.getClass(); tempClass != null && !"java.lang.object".equalsIgnoreCase(tempClass.getName()); tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (Field field : fieldList) {
            try {
                boolean flag = field.isAccessible();
                field.setAccessible(true);
                Object o = field.get(object);
                if (o == null) continue;
                map.put(field.getName(), o);
                field.setAccessible(flag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

