/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.SignService;
import net.qiyuesuo.sdk.bean.company.CompanyAppearanceSignRequest;
import net.qiyuesuo.sdk.bean.company.CompanyAuditRequest;
import net.qiyuesuo.sdk.bean.company.CompanySignRequest;
import net.qiyuesuo.sdk.bean.contract.SignCheck;
import net.qiyuesuo.sdk.bean.sign.AddSignatoriesRequest;
import net.qiyuesuo.sdk.bean.sign.PersonalAppearanceSignRequest;
import net.qiyuesuo.sdk.bean.sign.PersonalSignRequest;
import net.qiyuesuo.sdk.bean.sign.PlatformSignRequest;
import net.qiyuesuo.sdk.bean.sign.SignUrlRepeatAddRequest;
import net.qiyuesuo.sdk.bean.sign.SignUrlRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpMethod;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.json.JSONUtils;

public class SignServiceImpl
implements SignService {
    private SDKClient client;

    public SignServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public String presignUrl(Long contractId) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpGetParamers();
        paramers.addParam("contractId", String.valueOf(contractId));
        Map<String, Object> result = this.client.doService("/contract/presignurl", paramers);
        return (String)result.get("presignUrl");
    }

    @Override
    public void signByPlatform(PlatformSignRequest request) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/signbyplatform", JSONUtils.toJson(request));
    }

    @Override
    public void signByCompany(CompanySignRequest request) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/signbycompany", JSONUtils.toJson(request));
    }

    @Override
    public void signByCompanyWithoutAppearance(CompanyAppearanceSignRequest request) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/signbycompanywithoutappearance", JSONUtils.toJson(request));
    }

    @Override
    public String signUrl(SignUrlRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signurl", JSONUtils.toJson(request));
        String signUrl = (String)result.get("signUrl");
        return signUrl;
    }

    @Override
    public String signUrl(SignUrlRepeatAddRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signurl/v2", JSONUtils.toJson(request));
        return (String)result.get("signUrl");
    }

    @Override
    public String signUrlV3(SignUrlRepeatAddRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/signurl/v3", JSONUtils.toJson(request));
        return (String)result.get("signUrl");
    }

    @Override
    public void signByPerson(PersonalSignRequest request) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/signbyperson", JSONUtils.toJson(request));
    }

    @Override
    public void signByPersonWithoutAppearance(PersonalAppearanceSignRequest request) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/signbypersonwithoutappearance", JSONUtils.toJson(request));
    }

    @Override
    public void signSms(SignUrlRequest request) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/signurl/send", JSONUtils.toJson(request));
    }

    @Override
    public void signSms(SignUrlRepeatAddRequest request) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/signurl/send/v2", JSONUtils.toJson(request));
    }

    @Override
    public void signByLp(CompanySignRequest signRequest) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/signbylegalperson", JSONUtils.toJson(signRequest));
    }

    @Override
    public void audit(CompanyAuditRequest auditRequest) throws PrivateAppException {
        this.client.doServiceWithJson("/contract/audit", JSONUtils.toJson(auditRequest));
    }

    @Override
    public boolean checkPassword(SignCheck signCheck) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceByFormData("/contract/checkpassword", signCheck, HttpMethod.GET);
        return (Boolean)result.get("result");
    }

    @Override
    public String addSignatories(AddSignatoriesRequest request) throws PrivateAppException {
        Map<String, Object> result = this.client.doServiceWithJson("/contract/addsignatories", JSONUtils.toJson(request));
        Map urlResult = (Map)result.get("result");
        if (urlResult != null) {
            String pageUrl = (String)urlResult.get("pageUrl");
            return pageUrl;
        }
        return null;
    }
}

