/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.v2sdk.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.qiyuesuo.sdk.common.json.JSONArray;
import net.qiyuesuo.sdk.common.json.JSONObject;
import net.qiyuesuo.sdk.common.utils.MapUtils;
import net.qiyuesuo.v2sdk.exception.ServiceException;
import net.qiyuesuo.v2sdk.response.SdkResponse;

public class JSONUtils {
    public static String toJson(Object object) {
        JSONObject jsonObject = new JSONObject(object);
        return jsonObject.toString();
    }

    public static String toJson(Map<?, ?> map) {
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    public static String toJson(List<?> list) {
        JSONArray json = new JSONArray();
        for (Object object : list) {
            JSONObject jsonObject = new JSONObject(object);
            json.put(jsonObject);
        }
        return json.toString();
    }

    public static <T> SdkResponse toQysResponse(String json) throws ServiceException {
        return JSONUtils.toQysResponse(json, null);
    }

    public static <T> SdkResponse<T> toQysResponse(String json, Class<T> targetClass) throws ServiceException {
        JSONObject jsonObject = new JSONObject(json);
        Map<String, Object> map = jsonObject.toMap();
        Integer code = (Integer)map.get("code");
        String message = (String)map.get("message");
        Map resultMap = map.get("result") != null ? (Map)map.get("result") : null;
        try {
            Object result = targetClass == null || resultMap == null ? null : (Object)MapUtils.toObject(resultMap, targetClass);
            return new SdkResponse<Object>(code, message, result);
        }
        catch (Exception e) {
            throw new ServiceException("\u89e3\u6790\u7ed3\u679c\u9519\u8bef", e);
        }
    }

    public static <T> SdkResponse<List<T>> toQysListResponse(String json, Class<T> targetClass) throws ServiceException {
        List resultList;
        JSONObject jsonObject = new JSONObject(json);
        Map<String, Object> map = jsonObject.toMap();
        Integer code = (Integer)map.get("code");
        String message = (String)map.get("message");
        List list = resultList = map.get("result") != null ? (List)map.get("result") : null;
        if (resultList == null) {
            return new SdkResponse<Object>(code, message, null);
        }
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Map item : resultList) {
                Object t = targetClass == null || item == null ? null : (Object)MapUtils.toObject(item, targetClass);
                result.add(t);
            }
            return new SdkResponse<List<T>>(code, message, result);
        }
        catch (Exception e) {
            throw new ServiceException("\u89e3\u6790\u7ed3\u679c\u9519\u8bef", e);
        }
    }
}

