/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;

class ResultSetUtil {
    static final int[][] allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    ResultSetUtil() {
    }

    static OracleResultSet createScrollResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n2) throws SQLException {
        switch (n2) {
            case 1: {
                return oracleResultSet;
            }
            case 2: {
                return new UpdatableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
            case 3: {
                return new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
            case 4: {
                ScrollableResultSet scrollableResultSet = new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
                return new UpdatableResultSet(scrollRsetStatement, scrollableResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
            case 5: {
                return new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
            case 6: {
                SensitiveScrollableResultSet sensitiveScrollableResultSet = new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
                return new UpdatableResultSet(scrollRsetStatement, sensitiveScrollableResultSet, ResultSetUtil.getScrollType(n2), ResultSetUtil.getUpdateConcurrency(n2));
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(null, 23, null);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    static int getScrollType(int n2) {
        return allRsetTypes[n2][0];
    }

    static int getUpdateConcurrency(int n2) {
        return allRsetTypes[n2][1];
    }

    static int getRsetTypeCode(int n2, int n3) throws SQLException {
        for (int i2 = 0; i2 < allRsetTypes.length; ++i2) {
            if (allRsetTypes[i2][0] != n2 || allRsetTypes[i2][1] != n3) continue;
            return i2;
        }
        SQLException sQLException = DatabaseError.createSqlException(null, 68);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    static boolean needIdentifier(int n2) throws SQLException {
        return n2 != 1 && n2 != 3;
    }

    static boolean needIdentifier(int n2, int n3) throws SQLException {
        return ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(n2, n3));
    }

    static boolean needCache(int n2) throws SQLException {
        return n2 >= 3;
    }

    static boolean needCache(int n2, int n3) throws SQLException {
        return ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(n2, n3));
    }

    static boolean supportRefreshRow(int n2) throws SQLException {
        return n2 >= 4;
    }

    static boolean supportRefreshRow(int n2, int n3) throws SQLException {
        return ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(n2, n3));
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

