/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public class OracleTypeCOLLECTION
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -7279638692691669378L;
    public static final int TYPE_PLSQL_INDEX_TABLE = 1;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int TYPE_VARRAY = 3;
    int userCode = 0;
    long maxSize = 0L;
    OracleType elementType = null;
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 2;
    static final int POSSIBLY_OTHER_USER_OBJECT = 3;
    static final int OTHER_USER_OBJECT = 4;
    static final int OTHER_USER_SYNONYM = 5;
    static final int PUBLIC_SYNONYM = 6;
    static final int BREAK = 7;
    static final String[] sqlString = new String[]{"SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME = :1", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :tname CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :tname FROM DUAL)", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = :1 AND TYPE_NAME = :2", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = (SELECT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ", "DECLARE /*+RULE*/  the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleTypeCOLLECTION(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeCOLLECTION(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n2, (Connection)oracleConnection);
    }

    public OracleTypeCOLLECTION(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        super(sQLName, byArray, n2, byArray2, oracleConnection);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof ARRAY) {
                return (ARRAY)object;
            }
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            return new ARRAY(arrayDescriptor, this.connection, object);
        }
        return null;
    }

    public int getTypeCode() {
        return 2003;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        if (oracleType == null) {
            return false;
        }
        if (oracleType == this) {
            return true;
        }
        if (oracleType.getClass() != this.getClass()) {
            return false;
        }
        return oracleType.getTypeDescriptor().getName().equals(this.descriptor.getName());
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        long l2 = tDSReader.readLong();
        this.maxSize = tDSReader.readLong();
        this.userCode = tDSReader.readByte();
        tDSReader.addSimplePatch(l2, this);
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        return this.unlinearize(byArray, l2, datum, 1L, -1, n2, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum unlinearize(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getConnection();
        Datum datum2 = null;
        if (oracleConnection == null) {
            datum2 = this.unlinearizeInternal(byArray, l2, datum, l3, n2, n3, map);
        } else {
            OracleConnection oracleConnection2 = oracleConnection;
            synchronized (oracleConnection2) {
                datum2 = this.unlinearizeInternal(byArray, l2, datum, l3, n2, n3, map);
            }
        }
        return datum2;
    }

    public synchronized Datum unlinearizeInternal(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        PickleContext pickleContext = new PickleContext(byArray, l2);
        return this.unpickle81(pickleContext, (ARRAY)datum, l3, n2, 1, n3, map);
    }

    public synchronized boolean isInlineImage(byte[] byArray, int n2) throws SQLException {
        if (byArray == null) {
            return false;
        }
        if (PickleContext.isCollectionImage_pctx(byArray[n2])) {
            return true;
        }
        if (PickleContext.isDegenerateImage_pctx(byArray[n2])) {
            return false;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        ARRAY aRRAY = (ARRAY)datum;
        boolean bl = aRRAY.hasDataSeg();
        int n2 = 0;
        int n3 = pickleContext.offset() + 2;
        if (bl) {
            if (!this.metaDataInitialized) {
                this.copy_properties((OracleTypeCOLLECTION)aRRAY.getDescriptor().getPickler());
            }
            Datum[] datumArray = aRRAY.getOracleArray();
            if (this.userCode == 3 && (long)datumArray.length > this.maxSize) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 71, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            n2 += pickleContext.writeCollImageHeader(datumArray.length, this.typeVersion);
            for (int i2 = 0; i2 < datumArray.length; ++i2) {
                n2 = datumArray[i2] == null ? (n2 += pickleContext.writeElementNull()) : (n2 += this.elementType.pickle81(pickleContext, datumArray[i2]));
                String string = "idx=" + i2 + " is " + datumArray[i2];
            }
        } else {
            n2 += pickleContext.writeCollImageHeader(aRRAY.getLocator());
        }
        pickleContext.patchImageLen(n3, n2);
        return n2;
    }

    ARRAY unpickle81(PickleContext pickleContext, ARRAY aRRAY, int n2, int n3, Map map) throws SQLException {
        return this.unpickle81(pickleContext, aRRAY, 1L, -1, n2, n3, map);
    }

    ARRAY unpickle81(PickleContext pickleContext, ARRAY aRRAY, long l2, int n2, int n3, int n4, Map map) throws SQLException {
        ARRAY aRRAY2 = aRRAY;
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            aRRAY2 = new ARRAY(arrayDescriptor, (byte[])null, this.connection);
        }
        if (this.unpickle81ImgHeader(pickleContext, aRRAY2, n3, n4)) {
            if (l2 == 1L && n2 == -1) {
                this.unpickle81ImgBody(pickleContext, aRRAY2, n4, map);
            } else {
                this.unpickle81ImgBody(pickleContext, aRRAY2, l2, n2, n4, map);
            }
        }
        return aRRAY2;
    }

    boolean unpickle81ImgHeader(PickleContext pickleContext, ARRAY aRRAY, int n2, int n3) throws SQLException {
        boolean bl = true;
        if (n2 == 3) {
            aRRAY.setImage(pickleContext.image(), pickleContext.absoluteOffset(), 0L);
        }
        byte by = pickleContext.readByte();
        if (!PickleContext.is81format(by)) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!PickleContext.hasPrefix(by)) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image has no prefix segment");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (PickleContext.isCollectionImage_pctx(by)) {
            bl = true;
        } else if (PickleContext.isDegenerateImage_pctx(by)) {
            bl = false;
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        pickleContext.readByte();
        if (n2 == 9) {
            pickleContext.skipBytes(pickleContext.readLength(true) - 2);
            return false;
        }
        if (n2 == 3) {
            long l2 = pickleContext.readLength();
            aRRAY.setImageLength(l2);
            pickleContext.skipTo(aRRAY.getImageOffset() + l2);
            return false;
        }
        pickleContext.skipLength();
        int n4 = pickleContext.readLength();
        aRRAY.setPrefixFlag(pickleContext.readByte());
        if (aRRAY.isInline()) {
            pickleContext.readDataValue(n4 - 1);
        } else {
            aRRAY.setLocator(pickleContext.readDataValue(n4 - 1));
        }
        return aRRAY.isInline();
    }

    void unpickle81ImgBody(PickleContext pickleContext, ARRAY aRRAY, long l2, int n2, int n3, Map map) throws SQLException {
        boolean bl;
        pickleContext.readByte();
        int n4 = pickleContext.readLength();
        aRRAY.setLength(n4);
        if (n3 == 0) {
            return;
        }
        int n5 = (int)this.getAccessLength(n4, l2, n2);
        boolean bl2 = bl = ArrayDescriptor.getCacheStyle(aRRAY) == 1;
        if (l2 > 1L && n5 > 0) {
            long l3 = aRRAY.getLastIndex();
            if (l3 < l2) {
                if (l3 > 0L) {
                    pickleContext.skipTo(aRRAY.getLastOffset());
                } else {
                    l3 = 1L;
                }
                if (bl) {
                    for (long i2 = l3; i2 < l2; ++i2) {
                        aRRAY.setIndexOffset(i2, pickleContext.offset());
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                    }
                } else {
                    for (long i3 = l3; i3 < l2; ++i3) {
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                    }
                }
            } else if (l3 > l2) {
                long l4 = aRRAY.getOffset(l2);
                if (l4 != -1L) {
                    pickleContext.skipTo(l4);
                } else if (bl) {
                    int n6 = 1;
                    while ((long)n6 < l2) {
                        aRRAY.setIndexOffset(n6, pickleContext.offset());
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++n6;
                    }
                } else {
                    int n7 = 1;
                    while ((long)n7 < l2) {
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++n7;
                    }
                }
            } else {
                pickleContext.skipTo(aRRAY.getLastOffset());
            }
            aRRAY.setLastIndexOffset(l2, pickleContext.offset());
        }
        this.unpickle81ImgBodyElements(pickleContext, aRRAY, (int)l2, n5, n3, map);
    }

    void unpickle81ImgBody(PickleContext pickleContext, ARRAY aRRAY, int n2, Map map) throws SQLException {
        pickleContext.readByte();
        int n3 = pickleContext.readLength();
        aRRAY.setLength(n3);
        if (n2 == 0) {
            return;
        }
        this.unpickle81ImgBodyElements(pickleContext, aRRAY, 1, n3, n2, map);
    }

    private void unpickle81ImgBodyElements(PickleContext pickleContext, ARRAY aRRAY, int n2, int n3, int n4, Map map) throws SQLException {
        boolean bl = ArrayDescriptor.getCacheStyle(aRRAY) == 1;
        switch (n4) {
            case 1: {
                Datum[] datumArray = new Datum[n3];
                if (bl) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        aRRAY.setIndexOffset(n2 + i2, pickleContext.offset());
                        datumArray[i2] = (Datum)this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                } else {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        datumArray[i3] = (Datum)this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                }
                aRRAY.setDatumArray(datumArray);
                break;
            }
            case 2: {
                Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.elementType.getTypeCode());
                if (bl) {
                    for (int i4 = 0; i4 < n3; ++i4) {
                        aRRAY.setIndexOffset(n2 + i4, pickleContext.offset());
                        objectArray[i4] = this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                } else {
                    for (int i5 = 0; i5 < n3; ++i5) {
                        objectArray[i5] = this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                }
                aRRAY.setObjArray(objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.elementType instanceof OracleTypeNUMBER || this.elementType instanceof OracleTypeFLOAT) {
                    aRRAY.setObjArray(OracleTypeNUMBER.unpickle81NativeArray(pickleContext, 1L, n3, n4));
                    break;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "This feature is limited to numeric collection");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid conversion type " + this.elementType);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        aRRAY.setLastIndexOffset(n2 + n3, pickleContext.offset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCollElemTypeName() throws SQLException {
        if (this.connection == null) {
            return;
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.sqlName == null) {
                this.getFullName();
            }
            Statement statement = null;
            Statement statement2 = null;
            ResultSet resultSet = null;
            try {
                int n2;
                int n3 = n2 = this.sqlName.getSchema().equalsIgnoreCase(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 4;
                while (n2 != 7) {
                    switch (n2) {
                        case 0: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 1;
                            break;
                        }
                        case 1: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 2;
                            break;
                        }
                        case 2: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 3;
                            break;
                        }
                        case 3: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 5;
                            break;
                        }
                        case 4: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSchema());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 5;
                            break;
                        }
                        case 5: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 6;
                            break;
                        }
                        case 6: {
                            statement = this.connection.prepareCall(this.getSqlHint() + sqlString[n2]);
                            statement.setString(1, this.sqlName.getSimpleName());
                            statement.registerOutParameter(2, -10);
                            statement.execute();
                            resultSet = ((OracleCallableStatement)statement).getCursor(2);
                            n2 = 7;
                        }
                    }
                    if (resultSet.next()) {
                        if (this.attrTypeNames == null) {
                            this.attrTypeNames = new String[1];
                        }
                        this.attrTypeNames[0] = resultSet.getString(2) + "." + resultSet.getString(1);
                        n2 = 7;
                        continue;
                    }
                    if (n2 != 7) continue;
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                while (n2 != 7) {
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    public String getAttributeName(int n2) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public String getAttributeName(int n2, boolean bl) throws SQLException {
        return this.getAttributeName(n2);
    }

    public String getAttributeType(int n2) throws SQLException {
        if (n2 != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.sqlName == null) {
            this.getFullName();
        }
        if (this.attrTypeNames == null) {
            this.initCollElemTypeName();
        }
        return this.attrTypeNames[0];
    }

    public String getAttributeType(int n2, boolean bl) throws SQLException {
        if (bl) {
            return this.getAttributeType(n2);
        }
        if (n2 != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.sqlName != null && this.attrTypeNames != null) {
            return this.attrTypeNames[0];
        }
        return null;
    }

    public int getNumAttrs() throws SQLException {
        return 0;
    }

    public OracleType getAttrTypeAt(int n2) throws SQLException {
        return null;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        return new ArrayDescriptor(this, (Connection)this.connection);
    }

    ArrayDescriptor createArrayDescriptorWithItsOwnTree() throws SQLException {
        if (this.descriptor == null) {
            this.descriptor = this.sqlName == null && this.getFullName(false) == null ? new ArrayDescriptor(this, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        }
        return (ArrayDescriptor)this.descriptor;
    }

    public OracleType getElementType() throws SQLException {
        return this.elementType;
    }

    public int getUserCode() throws SQLException {
        return this.userCode;
    }

    public long getMaxLength() throws SQLException {
        return this.maxSize;
    }

    private long getAccessLength(long l2, long l3, int n2) throws SQLException {
        if (l3 > l2) {
            return 0L;
        }
        if (n2 < 0) {
            return l2 - l3 + 1L;
        }
        return Math.min(l2 - l3 + 1L, (long)n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.userCode);
        objectOutputStream.writeLong(this.maxSize);
        objectOutputStream.writeObject(this.elementType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.userCode = objectInputStream.readInt();
        this.maxSize = objectInputStream.readLong();
        this.elementType = (OracleType)objectInputStream.readObject();
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
        this.elementType.setConnection(oracleConnection);
    }

    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.elementType != null) {
            this.elementType.initMetadataRecursively();
        }
    }

    public void initChildNamesRecursively(Map map) throws SQLException {
        TypeTreeElement typeTreeElement = (TypeTreeElement)map.get(this.sqlName);
        if (this.elementType != null) {
            this.elementType.setNames(typeTreeElement.getChildSchemaName(0), typeTreeElement.getChildTypeName(0));
            this.elementType.initChildNamesRecursively(map);
            this.elementType.cacheDescriptor();
        }
    }

    public void cacheDescriptor() throws SQLException {
        this.descriptor = ArrayDescriptor.createDescriptor(this);
    }

    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }

    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleTypeCOLLECTION sqlName=\"" + this.sqlName + "\" " + ">");
        if (this.elementType != null) {
            this.elementType.printXML(printWriter, n2 + 1, bl);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("</OracleTypeCOLLECTION>");
    }
}

