/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.export.ActivitiListenerExport;
import org.activiti.bpmn.converter.export.MultiInstanceExport;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DataObject;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.FormValue;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TerminateEventDefinition;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.bpmn.model.ValuedDataObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBpmnXMLConverter
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseBpmnXMLConverter.class);
    protected BpmnModel model;
    protected Process activeProcess;
    protected Map<String, BaseChildElementParser> childElementParsers = new HashMap<String, BaseChildElementParser>();
    protected boolean didWriteExtensionStartElement = false;
    protected static final List<ExtensionAttribute> defaultElementAttributes = Arrays.asList(new ExtensionAttribute("id"), new ExtensionAttribute("name"));
    protected static final List<ExtensionAttribute> defaultActivityAttributes = Arrays.asList(new ExtensionAttribute("http://activiti.org/bpmn", "async"), new ExtensionAttribute("http://activiti.org/bpmn", "exclusive"), new ExtensionAttribute("default"), new ExtensionAttribute("http://activiti.org/bpmn", "isForCompensation"));

    public void convertToBpmnModel(XMLStreamReader xtr, BpmnModel model, Process activeProcess, List<SubProcess> activeSubProcessList) throws Exception {
        this.model = model;
        this.activeProcess = activeProcess;
        String elementId = xtr.getAttributeValue(null, "id");
        String elementName = xtr.getAttributeValue(null, "name");
        boolean async = this.parseAsync(xtr);
        boolean notExclusive = this.parseNotExclusive(xtr);
        String defaultFlow = xtr.getAttributeValue(null, "default");
        boolean isForCompensation = this.parseForCompensation(xtr);
        BaseElement parsedElement = this.convertXMLToElement(xtr);
        if (parsedElement instanceof Artifact) {
            Artifact currentArtifact = (Artifact)parsedElement;
            currentArtifact.setId(elementId);
            if (this.isInSubProcess(activeSubProcessList)) {
                SubProcess currentSubProcess = activeSubProcessList.get(activeSubProcessList.size() - 2);
                currentSubProcess.addArtifact(currentArtifact);
            } else {
                this.activeProcess.addArtifact(currentArtifact);
            }
        }
        if (parsedElement instanceof FlowElement) {
            FlowElement currentFlowElement = (FlowElement)parsedElement;
            currentFlowElement.setId(elementId);
            currentFlowElement.setName(elementName);
            if (currentFlowElement instanceof Activity) {
                Activity activity = (Activity)currentFlowElement;
                activity.setAsynchronous(async);
                activity.setNotExclusive(notExclusive);
                activity.setForCompensation(isForCompensation);
                if (StringUtils.isNotEmpty((CharSequence)defaultFlow)) {
                    activity.setDefaultFlow(defaultFlow);
                }
            }
            if (currentFlowElement instanceof Gateway && StringUtils.isNotEmpty((CharSequence)defaultFlow)) {
                ((Gateway)currentFlowElement).setDefaultFlow(defaultFlow);
            }
            if (currentFlowElement instanceof DataObject) {
                if (activeSubProcessList.size() > 0) {
                    activeSubProcessList.get(activeSubProcessList.size() - 1).getDataObjects().add((ValuedDataObject)parsedElement);
                } else {
                    this.activeProcess.getDataObjects().add((ValuedDataObject)parsedElement);
                }
            }
            if (activeSubProcessList.size() > 0) {
                activeSubProcessList.get(activeSubProcessList.size() - 1).addFlowElement(currentFlowElement);
            } else {
                this.activeProcess.addFlowElement(currentFlowElement);
            }
        }
    }

    public void convertToXML(XMLStreamWriter xtw, BaseElement baseElement, BpmnModel model) throws Exception {
        FlowElement flowElement;
        Gateway gateway;
        FlowElement defaultFlowElement;
        Activity activity;
        this.model = model;
        xtw.writeStartElement(this.getXMLElementName());
        this.didWriteExtensionStartElement = false;
        this.writeDefaultAttribute("id", baseElement.getId(), xtw);
        if (baseElement instanceof FlowElement) {
            this.writeDefaultAttribute("name", ((FlowElement)baseElement).getName(), xtw);
        }
        if (baseElement instanceof Activity) {
            activity = (Activity)baseElement;
            if (activity.isAsynchronous()) {
                this.writeQualifiedAttribute("async", "true", xtw);
            }
            if (activity.isNotExclusive()) {
                this.writeQualifiedAttribute("exclusive", "false", xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)activity.getDefaultFlow()) && (defaultFlowElement = model.getFlowElement(activity.getDefaultFlow())) != null && defaultFlowElement instanceof SequenceFlow) {
                this.writeDefaultAttribute("default", activity.getDefaultFlow(), xtw);
            }
        }
        if (baseElement instanceof Gateway && StringUtils.isNotEmpty((CharSequence)(gateway = (Gateway)baseElement).getDefaultFlow()) && (defaultFlowElement = model.getFlowElement(gateway.getDefaultFlow())) != null && defaultFlowElement instanceof SequenceFlow) {
            this.writeDefaultAttribute("default", gateway.getDefaultFlow(), xtw);
        }
        this.writeAdditionalAttributes(baseElement, xtw);
        if (baseElement instanceof FlowElement && StringUtils.isNotEmpty((CharSequence)(flowElement = (FlowElement)baseElement).getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(flowElement.getDocumentation());
            xtw.writeEndElement();
        }
        this.writeExtensionChildElements(baseElement, xtw);
        this.didWriteExtensionStartElement = this.writeListeners(baseElement, xtw);
        this.didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements(baseElement, this.didWriteExtensionStartElement, xtw);
        if (this.didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        if (baseElement instanceof Activity) {
            activity = (Activity)baseElement;
            MultiInstanceExport.writeMultiInstance(activity, xtw);
        }
        this.writeAdditionalChildElements(baseElement, xtw);
        xtw.writeEndElement();
    }

    protected abstract BaseElement convertXMLToElement(XMLStreamReader var1) throws Exception;

    protected abstract String getXMLElementName();

    protected abstract void writeAdditionalAttributes(BaseElement var1, XMLStreamWriter var2) throws Exception;

    protected abstract void writeExtensionChildElements(BaseElement var1, XMLStreamWriter var2) throws Exception;

    protected abstract void writeAdditionalChildElements(BaseElement var1, XMLStreamWriter var2) throws Exception;

    protected void parseChildElements(String elementName, BaseElement parentElement, XMLStreamReader xtr) throws Exception {
        HashMap<String, BaseChildElementParser> childParsers = new HashMap<String, BaseChildElementParser>();
        if (this.childElementParsers != null) {
            childParsers.putAll(this.childElementParsers);
        }
        BpmnXMLUtil.parseChildElements(elementName, parentElement, xtr, childParsers, this.model);
    }

    protected ExtensionElement parseExtensionElement(XMLStreamReader xtr) throws Exception {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setName(xtr.getLocalName());
        if (StringUtils.isNotEmpty((CharSequence)xtr.getNamespaceURI())) {
            extensionElement.setNamespace(xtr.getNamespaceURI());
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getPrefix())) {
            extensionElement.setNamespacePrefix(xtr.getPrefix());
        }
        BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)extensionElement, defaultElementAttributes);
        boolean readyWithExtensionElement = false;
        while (!readyWithExtensionElement && xtr.hasNext()) {
            xtr.next();
            if (xtr.isCharacters()) {
                if (!StringUtils.isNotEmpty((CharSequence)xtr.getText().trim())) continue;
                extensionElement.setElementText(xtr.getText().trim());
                continue;
            }
            if (xtr.isStartElement()) {
                ExtensionElement childExtensionElement = this.parseExtensionElement(xtr);
                extensionElement.addChildElement(childExtensionElement);
                continue;
            }
            if (!xtr.isEndElement() || !extensionElement.getName().equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithExtensionElement = true;
        }
        return extensionElement;
    }

    protected boolean parseAsync(XMLStreamReader xtr) {
        boolean async = false;
        String asyncString = xtr.getAttributeValue("http://activiti.org/bpmn", "async");
        if ("true".equalsIgnoreCase(asyncString)) {
            async = true;
        }
        return async;
    }

    protected boolean parseNotExclusive(XMLStreamReader xtr) {
        boolean notExclusive = false;
        String exclusiveString = xtr.getAttributeValue("http://activiti.org/bpmn", "exclusive");
        if ("false".equalsIgnoreCase(exclusiveString)) {
            notExclusive = true;
        }
        return notExclusive;
    }

    protected boolean parseForCompensation(XMLStreamReader xtr) {
        boolean isForCompensation = false;
        String compensationString = xtr.getAttributeValue(null, "isForCompensation");
        if ("true".equalsIgnoreCase(compensationString)) {
            isForCompensation = true;
        }
        return isForCompensation;
    }

    protected List<String> parseDelimitedList(String expression) {
        return BpmnXMLUtil.parseDelimitedList(expression);
    }

    private boolean isInSubProcess(List<SubProcess> subProcessList) {
        return subProcessList.size() > 1;
    }

    protected String convertToDelimitedString(List<String> stringList) {
        return BpmnXMLUtil.convertToDelimitedString(stringList);
    }

    protected void writeFormProperties(FlowElement flowElement, XMLStreamWriter xtw) throws Exception {
        List propertyList = null;
        if (flowElement instanceof UserTask) {
            propertyList = ((UserTask)flowElement).getFormProperties();
        } else if (flowElement instanceof StartEvent) {
            propertyList = ((StartEvent)flowElement).getFormProperties();
        }
        if (propertyList != null) {
            for (FormProperty property : propertyList) {
                if (!StringUtils.isNotEmpty((CharSequence)property.getId())) continue;
                if (!this.didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    this.didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("activiti", "formProperty", "http://activiti.org/bpmn");
                this.writeDefaultAttribute("id", property.getId(), xtw);
                this.writeDefaultAttribute("name", property.getName(), xtw);
                this.writeDefaultAttribute("type", property.getType(), xtw);
                this.writeDefaultAttribute("expression", property.getExpression(), xtw);
                this.writeDefaultAttribute("variable", property.getVariable(), xtw);
                this.writeDefaultAttribute("default", property.getDefaultExpression(), xtw);
                this.writeDefaultAttribute("datePattern", property.getDatePattern(), xtw);
                if (!property.isReadable()) {
                    this.writeDefaultAttribute("readable", "false", xtw);
                }
                if (!property.isWriteable()) {
                    this.writeDefaultAttribute("writable", "false", xtw);
                }
                if (property.isRequired()) {
                    this.writeDefaultAttribute("required", "true", xtw);
                }
                for (FormValue formValue : property.getFormValues()) {
                    if (!StringUtils.isNotEmpty((CharSequence)formValue.getId())) continue;
                    xtw.writeStartElement("activiti", "value", "http://activiti.org/bpmn");
                    xtw.writeAttribute("id", formValue.getId());
                    xtw.writeAttribute("name", formValue.getName());
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
        }
    }

    protected boolean writeListeners(BaseElement element, XMLStreamWriter xtw) throws Exception {
        return ActivitiListenerExport.writeListeners(element, this.didWriteExtensionStartElement, xtw);
    }

    protected void writeEventDefinitions(Event parentEvent, List<EventDefinition> eventDefinitions, XMLStreamWriter xtw) throws Exception {
        for (EventDefinition eventDefinition : eventDefinitions) {
            if (eventDefinition instanceof TimerEventDefinition) {
                this.writeTimerDefinition(parentEvent, (TimerEventDefinition)eventDefinition, xtw);
                continue;
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                this.writeSignalDefinition(parentEvent, (SignalEventDefinition)eventDefinition, xtw);
                continue;
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                this.writeMessageDefinition(parentEvent, (MessageEventDefinition)eventDefinition, xtw);
                continue;
            }
            if (eventDefinition instanceof ErrorEventDefinition) {
                this.writeErrorDefinition(parentEvent, (ErrorEventDefinition)eventDefinition, xtw);
                continue;
            }
            if (!(eventDefinition instanceof TerminateEventDefinition)) continue;
            this.writeTerminateDefinition(parentEvent, (TerminateEventDefinition)eventDefinition, xtw);
        }
    }

    protected void writeTimerDefinition(Event parentEvent, TimerEventDefinition timerDefinition, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("timerEventDefinition");
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)timerDefinition, false, xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDate())) {
            xtw.writeStartElement("timeDate");
            xtw.writeCharacters(timerDefinition.getTimeDate());
            xtw.writeEndElement();
        } else if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeCycle())) {
            xtw.writeStartElement("timeCycle");
            xtw.writeCharacters(timerDefinition.getTimeCycle());
            xtw.writeEndElement();
        } else if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDuration())) {
            xtw.writeStartElement("timeDuration");
            xtw.writeCharacters(timerDefinition.getTimeDuration());
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeSignalDefinition(Event parentEvent, SignalEventDefinition signalDefinition, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("signalEventDefinition");
        this.writeDefaultAttribute("signalRef", signalDefinition.getSignalRef(), xtw);
        if (parentEvent instanceof ThrowEvent && signalDefinition.isAsync()) {
            BpmnXMLUtil.writeQualifiedAttribute("async", "true", xtw);
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)signalDefinition, false, xtw)) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeMessageDefinition(Event parentEvent, MessageEventDefinition messageDefinition, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("messageEventDefinition");
        String messageRef = messageDefinition.getMessageRef();
        if (StringUtils.isNotEmpty((CharSequence)messageRef)) {
            if (messageRef.startsWith(this.model.getTargetNamespace())) {
                messageRef = messageRef.replace(this.model.getTargetNamespace(), "");
                messageRef = messageRef.replaceFirst(":", "");
            } else {
                for (String prefix : this.model.getNamespaces().keySet()) {
                    String namespace = this.model.getNamespace(prefix);
                    if (!messageRef.startsWith(namespace)) continue;
                    messageRef = messageRef.replace(this.model.getTargetNamespace(), "");
                    messageRef = prefix + messageRef;
                }
            }
        }
        this.writeDefaultAttribute("messageRef", messageRef, xtw);
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)messageDefinition, false, xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeErrorDefinition(Event parentEvent, ErrorEventDefinition errorDefinition, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("errorEventDefinition");
        this.writeDefaultAttribute("errorRef", errorDefinition.getErrorCode(), xtw);
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)errorDefinition, false, xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeTerminateDefinition(Event parentEvent, TerminateEventDefinition terminateDefinition, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("terminateEventDefinition");
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)terminateDefinition, false, xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeDefaultAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        BpmnXMLUtil.writeDefaultAttribute(attributeName, value, xtw);
    }

    protected void writeQualifiedAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        BpmnXMLUtil.writeQualifiedAttribute(attributeName, value, xtw);
    }
}

