/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.AbstractVariableQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.QueryVariableValue;
import org.activiti.engine.impl.TaskQueryProperty;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.variable.VariableTypes;
import org.activiti.engine.task.DelegationState;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;

public class TaskQueryImpl
extends AbstractVariableQueryImpl<TaskQuery, Task>
implements TaskQuery {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String name;
    protected String nameLike;
    protected String description;
    protected String descriptionLike;
    protected Integer priority;
    protected Integer minPriority;
    protected Integer maxPriority;
    protected String assignee;
    protected String assigneeLike;
    protected String involvedUser;
    protected String owner;
    protected String ownerLike;
    protected boolean unassigned = false;
    protected boolean noDelegationState = false;
    protected DelegationState delegationState;
    protected String candidateUser;
    protected String candidateGroup;
    protected List<String> candidateGroups;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String processInstanceId;
    protected String executionId;
    protected Date createTime;
    protected Date createTimeBefore;
    protected Date createTimeAfter;
    protected String category;
    protected String key;
    protected String keyLike;
    protected String processDefinitionKey;
    protected String processDefinitionKeyLike;
    protected String processDefinitionId;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected String processInstanceBusinessKey;
    protected String processInstanceBusinessKeyLike;
    protected Date dueDate;
    protected Date dueBefore;
    protected Date dueAfter;
    protected boolean withoutDueDate = false;
    protected SuspensionState suspensionState;
    protected boolean excludeSubtasks = false;
    protected boolean includeTaskLocalVariables = false;
    protected boolean includeProcessVariables = false;
    protected String userIdForCandidateAndAssignee;
    protected boolean bothCandidateAndAssigned = false;

    public TaskQueryImpl() {
    }

    public TaskQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public TaskQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public TaskQueryImpl taskId(String taskId) {
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("Task id is null");
        }
        this.taskId = taskId;
        return this;
    }

    @Override
    public TaskQueryImpl taskName(String name) {
        if (name == null) {
            throw new ActivitiIllegalArgumentException("Task name is null");
        }
        this.name = name;
        return this;
    }

    @Override
    public TaskQueryImpl taskNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiIllegalArgumentException("Task namelike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public TaskQueryImpl taskDescription(String description) {
        if (description == null) {
            throw new ActivitiIllegalArgumentException("Description is null");
        }
        this.description = description;
        return this;
    }

    @Override
    public TaskQuery taskDescriptionLike(String descriptionLike) {
        if (descriptionLike == null) {
            throw new ActivitiIllegalArgumentException("Task descriptionlike is null");
        }
        this.descriptionLike = descriptionLike;
        return this;
    }

    @Override
    public TaskQuery taskPriority(Integer priority) {
        if (priority == null) {
            throw new ActivitiIllegalArgumentException("Priority is null");
        }
        this.priority = priority;
        return this;
    }

    @Override
    public TaskQuery taskMinPriority(Integer minPriority) {
        if (minPriority == null) {
            throw new ActivitiIllegalArgumentException("Min Priority is null");
        }
        this.minPriority = minPriority;
        return this;
    }

    @Override
    public TaskQuery taskMaxPriority(Integer maxPriority) {
        if (maxPriority == null) {
            throw new ActivitiIllegalArgumentException("Max Priority is null");
        }
        this.maxPriority = maxPriority;
        return this;
    }

    @Override
    public TaskQueryImpl taskAssignee(String assignee) {
        if (assignee == null) {
            throw new ActivitiIllegalArgumentException("Assignee is null");
        }
        this.assignee = assignee;
        return this;
    }

    @Override
    public TaskQueryImpl taskAssigneeLike(String assigneeLike) {
        if (assigneeLike == null) {
            throw new ActivitiIllegalArgumentException("Assignee is null");
        }
        this.assigneeLike = assigneeLike;
        return this;
    }

    @Override
    public TaskQueryImpl taskOwner(String owner) {
        if (owner == null) {
            throw new ActivitiIllegalArgumentException("Owner is null");
        }
        this.owner = owner;
        return this;
    }

    @Override
    public TaskQueryImpl taskOwnerLike(String ownerLike) {
        if (ownerLike == null) {
            throw new ActivitiIllegalArgumentException("Owner is null");
        }
        this.ownerLike = ownerLike;
        return this;
    }

    @Override
    @Deprecated
    public TaskQuery taskUnnassigned() {
        return this.taskUnassigned();
    }

    @Override
    public TaskQuery taskUnassigned() {
        this.unassigned = true;
        return this;
    }

    @Override
    public TaskQuery taskDelegationState(DelegationState delegationState) {
        if (delegationState == null) {
            this.noDelegationState = true;
        } else {
            this.delegationState = delegationState;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateUser(String candidateUser) {
        if (candidateUser == null) {
            throw new ActivitiIllegalArgumentException("Candidate user is null");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateUser and candidateGroup");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateUser and candidateGroupIn");
        }
        this.candidateUser = candidateUser;
        return this;
    }

    @Override
    public TaskQueryImpl taskInvolvedUser(String involvedUser) {
        if (involvedUser == null) {
            throw new ActivitiIllegalArgumentException("Involved user is null");
        }
        this.involvedUser = involvedUser;
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateGroup(String candidateGroup) {
        if (candidateGroup == null) {
            throw new ActivitiIllegalArgumentException("Candidate group is null");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        this.candidateGroup = candidateGroup;
        return this;
    }

    @Override
    public TaskQuery taskCandidateOrAssigned(String userIdForCandidateAndAssignee) {
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set candidateGroup");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        this.bothCandidateAndAssigned = true;
        this.userIdForCandidateAndAssignee = userIdForCandidateAndAssignee;
        return this;
    }

    @Override
    public TaskQuery taskCandidateGroupIn(List<String> candidateGroups) {
        if (candidateGroups == null) {
            throw new ActivitiIllegalArgumentException("Candidate group list is null");
        }
        if (candidateGroups.size() == 0) {
            throw new ActivitiIllegalArgumentException("Candidate group list is empty");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateUser");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        this.candidateGroups = candidateGroups;
        return this;
    }

    @Override
    public TaskQuery taskTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("task tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public TaskQuery taskTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("task tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    @Override
    public TaskQuery taskWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        return this;
    }

    @Override
    public TaskQueryImpl executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public TaskQueryImpl taskCreatedOn(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Override
    public TaskQuery taskCreatedBefore(Date before) {
        this.createTimeBefore = before;
        return this;
    }

    @Override
    public TaskQuery taskCreatedAfter(Date after) {
        this.createTimeAfter = after;
        return this;
    }

    @Override
    public TaskQuery taskCategory(String category) {
        this.category = category;
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKeyLike(String keyLike) {
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public TaskQuery taskVariableValueEquals(String variableName, Object variableValue) {
        return (TaskQuery)this.variableValueEquals(variableName, variableValue);
    }

    @Override
    public TaskQuery taskVariableValueEquals(Object variableValue) {
        return (TaskQuery)this.variableValueEquals(variableValue);
    }

    @Override
    public TaskQuery taskVariableValueEqualsIgnoreCase(String name, String value) {
        return (TaskQuery)this.variableValueEqualsIgnoreCase(name, value);
    }

    @Override
    public TaskQuery taskVariableValueNotEqualsIgnoreCase(String name, String value) {
        return (TaskQuery)this.variableValueNotEqualsIgnoreCase(name, value);
    }

    @Override
    public TaskQuery taskVariableValueNotEquals(String variableName, Object variableValue) {
        return (TaskQuery)this.variableValueNotEquals(variableName, variableValue);
    }

    @Override
    public TaskQuery taskVariableValueGreaterThan(String name, Object value) {
        return (TaskQuery)this.variableValueGreaterThan(name, value);
    }

    @Override
    public TaskQuery taskVariableValueGreaterThanOrEqual(String name, Object value) {
        return (TaskQuery)this.variableValueGreaterThanOrEqual(name, value);
    }

    @Override
    public TaskQuery taskVariableValueLessThan(String name, Object value) {
        return (TaskQuery)this.variableValueLessThan(name, value);
    }

    @Override
    public TaskQuery taskVariableValueLessThanOrEqual(String name, Object value) {
        return (TaskQuery)this.variableValueLessThanOrEqual(name, value);
    }

    @Override
    public TaskQuery taskVariableValueLike(String name, String value) {
        return (TaskQuery)this.variableValueLike(name, value);
    }

    @Override
    public TaskQuery processVariableValueEquals(String variableName, Object variableValue) {
        return (TaskQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    @Override
    public TaskQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        return (TaskQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    @Override
    public TaskQuery processVariableValueEquals(Object variableValue) {
        return (TaskQuery)this.variableValueEquals(variableValue, false);
    }

    @Override
    public TaskQuery processVariableValueEqualsIgnoreCase(String name, String value) {
        return (TaskQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    @Override
    public TaskQuery processVariableValueNotEqualsIgnoreCase(String name, String value) {
        return (TaskQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    @Override
    public TaskQuery processVariableValueGreaterThan(String name, Object value) {
        return (TaskQuery)this.variableValueGreaterThan(name, value, false);
    }

    @Override
    public TaskQuery processVariableValueGreaterThanOrEqual(String name, Object value) {
        return (TaskQuery)this.variableValueGreaterThanOrEqual(name, value, false);
    }

    @Override
    public TaskQuery processVariableValueLessThan(String name, Object value) {
        return (TaskQuery)this.variableValueLessThan(name, value, false);
    }

    @Override
    public TaskQuery processVariableValueLessThanOrEqual(String name, Object value) {
        return (TaskQuery)this.variableValueLessThanOrEqual(name, value, false);
    }

    @Override
    public TaskQuery processVariableValueLike(String name, String value) {
        return (TaskQuery)this.variableValueLike(name, value, false);
    }

    @Override
    public TaskQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public TaskQuery processDefinitionKeyLike(String processDefinitionKeyLike) {
        this.processDefinitionKeyLike = processDefinitionKeyLike;
        return this;
    }

    @Override
    public TaskQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public TaskQuery processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Override
    public TaskQuery processDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
        return this;
    }

    @Override
    public TaskQuery dueDate(Date dueDate) {
        this.dueDate = dueDate;
        this.withoutDueDate = false;
        return this;
    }

    @Override
    public TaskQuery dueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
        this.withoutDueDate = false;
        return this;
    }

    @Override
    public TaskQuery dueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
        this.withoutDueDate = false;
        return this;
    }

    @Override
    public TaskQuery withoutDueDate() {
        this.withoutDueDate = true;
        return this;
    }

    @Override
    public TaskQuery excludeSubtasks() {
        this.excludeSubtasks = true;
        return this;
    }

    @Override
    public TaskQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public TaskQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public TaskQuery includeTaskLocalVariables() {
        this.includeTaskLocalVariables = true;
        return this;
    }

    @Override
    public TaskQuery includeProcessVariables() {
        this.includeProcessVariables = true;
        return this;
    }

    public List<String> getCandidateGroups() {
        if (this.candidateGroup != null) {
            ArrayList<String> candidateGroupList = new ArrayList<String>(1);
            candidateGroupList.add(this.candidateGroup);
            return candidateGroupList;
        }
        if (this.candidateUser != null) {
            return this.getGroupsForCandidateUser(this.candidateUser);
        }
        if (this.candidateGroups != null) {
            return this.candidateGroups;
        }
        return null;
    }

    protected List<String> getGroupsForCandidateUser(String candidateUser) {
        List<Group> groups = Context.getCommandContext().getGroupIdentityManager().findGroupsByUser(candidateUser);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    @Override
    protected void ensureVariablesInitialized() {
        VariableTypes types = Context.getProcessEngineConfiguration().getVariableTypes();
        for (QueryVariableValue var : this.queryVariableValues) {
            var.initialize(types);
        }
    }

    @Override
    public TaskQuery orderByTaskId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TASK_ID);
    }

    @Override
    public TaskQuery orderByTaskName() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.NAME);
    }

    @Override
    public TaskQuery orderByTaskDescription() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DESCRIPTION);
    }

    @Override
    public TaskQuery orderByTaskPriority() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PRIORITY);
    }

    @Override
    public TaskQuery orderByProcessInstanceId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public TaskQuery orderByExecutionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.EXECUTION_ID);
    }

    @Override
    public TaskQuery orderByTaskAssignee() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.ASSIGNEE);
    }

    @Override
    public TaskQuery orderByTaskCreateTime() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CREATE_TIME);
    }

    @Override
    public TaskQuery orderByDueDate() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE);
    }

    @Override
    public TaskQuery orderByTenantId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TENANT_ID);
    }

    public String getMssqlOrDB2OrderBy() {
        String specialOrderBy = super.getOrderBy();
        if (specialOrderBy != null && specialOrderBy.length() > 0) {
            specialOrderBy = specialOrderBy.replace("RES.", "TEMPRES_");
        }
        return specialOrderBy;
    }

    @Override
    public List<Task> executeList(CommandContext commandContext, Page page) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        if (this.includeTaskLocalVariables || this.includeProcessVariables) {
            return commandContext.getTaskEntityManager().findTasksAndVariablesByQueryCriteria(this);
        }
        return commandContext.getTaskEntityManager().findTasksByQueryCriteria(this);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getTaskEntityManager().findTaskCountByQueryCriteria(this);
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public boolean getUnassigned() {
        return this.unassigned;
    }

    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    public boolean getNoDelegationState() {
        return this.noDelegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getCreateTimeBefore() {
        return this.createTimeBefore;
    }

    public Date getCreateTimeAfter() {
        return this.createTimeAfter;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public boolean getExcludeSubtasks() {
        return this.excludeSubtasks;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getUserIdForCandidateAndAssignee() {
        return this.userIdForCandidateAndAssignee;
    }
}

