/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.calendar;

import java.util.Date;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.calendar.BusinessCalendarImpl;
import org.activiti.engine.impl.calendar.CronExpression;
import org.activiti.engine.impl.calendar.DurationHelper;
import org.activiti.engine.runtime.ClockReader;

public class CycleBusinessCalendar
extends BusinessCalendarImpl {
    public static String NAME = "cycle";

    public CycleBusinessCalendar(ClockReader clockReader) {
        super(clockReader);
    }

    @Override
    public Date resolveDuedate(String duedateDescription) {
        try {
            if (duedateDescription.startsWith("R")) {
                return new DurationHelper(duedateDescription, this.clockReader).getDateAfter();
            }
            CronExpression ce = new CronExpression(duedateDescription, this.clockReader);
            return ce.getTimeAfter(this.clockReader.getCurrentTime());
        }
        catch (Exception e) {
            throw new ActivitiException("Failed to parse cron expression: " + duedateDescription, e);
        }
    }
}

