/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.jobexecutor.MessageAddedNotification;
import org.activiti.engine.impl.persistence.entity.JobEntity;

public class DecrementJobRetriesCmd
implements Command<Object> {
    protected String jobId;
    protected Throwable exception;

    public DecrementJobRetriesCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ActivitiEventDispatcher eventDispatcher;
        JobEntity job = Context.getCommandContext().getJobEntityManager().findJobById(this.jobId);
        job.setRetries(job.getRetries() - 1);
        job.setLockOwner(null);
        job.setLockExpirationTime(null);
        if (this.exception != null) {
            job.setExceptionMessage(this.exception.getMessage());
            job.setExceptionStacktrace(this.getExceptionStacktrace());
        }
        if ((eventDispatcher = commandContext.getEventDispatcher()).isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, job));
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_RETRIES_DECREMENTED, job));
        }
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        MessageAddedNotification messageAddedNotification = new MessageAddedNotification(jobExecutor);
        TransactionContext transactionContext = commandContext.getTransactionContext();
        transactionContext.addTransactionListener(TransactionState.COMMITTED, messageAddedNotification);
        return null;
    }

    private String getExceptionStacktrace() {
        StringWriter stringWriter = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

