/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryProperty;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;

public class ProcessDefinitionQueryImpl
extends AbstractQuery<ProcessDefinitionQuery, ProcessDefinition>
implements ProcessDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected Set<String> ids;
    protected String category;
    protected String categoryLike;
    protected String categoryNotEquals;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected Set<String> deploymentIds;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected Integer versionGt;
    protected Integer versionGte;
    protected Integer versionLt;
    protected Integer versionLte;
    protected boolean latest = false;
    protected SuspensionState suspensionState;
    protected String authorizationUserId;
    protected String procDefId;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String eventSubscriptionName;
    protected String eventSubscriptionType;

    public ProcessDefinitionQueryImpl() {
    }

    public ProcessDefinitionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ProcessDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionId(String processDefinitionId) {
        this.id = processDefinitionId;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionIds(Set<String> processDefinitionIds) {
        if (processDefinitionIds == null) {
            throw new ActivitiIllegalArgumentException("processDefinitionIds is null");
        }
        if (processDefinitionIds.isEmpty()) {
            throw new ActivitiIllegalArgumentException("processDefinitionIds is empty");
        }
        this.ids = processDefinitionIds;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionCategory(String category) {
        if (category == null) {
            throw new ActivitiIllegalArgumentException("category is null");
        }
        this.category = category;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionCategoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new ActivitiIllegalArgumentException("categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionCategoryNotEquals(String categoryNotEquals) {
        if (categoryNotEquals == null) {
            throw new ActivitiIllegalArgumentException("categoryNotEquals is null");
        }
        this.categoryNotEquals = categoryNotEquals;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionName(String name) {
        if (name == null) {
            throw new ActivitiIllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiIllegalArgumentException("nameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new ActivitiIllegalArgumentException("id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl deploymentIds(Set<String> deploymentIds) {
        if (deploymentIds == null) {
            throw new ActivitiIllegalArgumentException("deploymentIds is null");
        }
        if (deploymentIds.isEmpty()) {
            throw new ActivitiIllegalArgumentException("deploymentIds is empty");
        }
        this.deploymentIds = deploymentIds;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKey(String key) {
        if (key == null) {
            throw new ActivitiIllegalArgumentException("key is null");
        }
        this.key = key;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new ActivitiIllegalArgumentException("keyLike is null");
        }
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionResourceName(String resourceName) {
        if (resourceName == null) {
            throw new ActivitiIllegalArgumentException("resourceName is null");
        }
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionResourceNameLike(String resourceNameLike) {
        if (resourceNameLike == null) {
            throw new ActivitiIllegalArgumentException("resourceNameLike is null");
        }
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionVersion(Integer version) {
        this.checkVersion(version);
        this.version = version;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionVersionGreaterThan(Integer processDefinitionVersion) {
        this.checkVersion(processDefinitionVersion);
        this.versionGt = processDefinitionVersion;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionVersionGreaterThanOrEquals(Integer processDefinitionVersion) {
        this.checkVersion(processDefinitionVersion);
        this.versionGte = processDefinitionVersion;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionVersionLowerThan(Integer processDefinitionVersion) {
        this.checkVersion(processDefinitionVersion);
        this.versionLt = processDefinitionVersion;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionVersionLowerThanOrEquals(Integer processDefinitionVersion) {
        this.checkVersion(processDefinitionVersion);
        this.versionLte = processDefinitionVersion;
        return this;
    }

    protected void checkVersion(Integer version) {
        if (version == null) {
            throw new ActivitiIllegalArgumentException("version is null");
        }
        if (version <= 0) {
            throw new ActivitiIllegalArgumentException("version must be positive");
        }
    }

    @Override
    public ProcessDefinitionQueryImpl latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public ProcessDefinitionQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("processDefinition tenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("process definition tenantId is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscription(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscriptionName(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    public ProcessDefinitionQuery processDefinitionStarter(String procDefId) {
        this.procDefId = procDefId;
        return this;
    }

    public ProcessDefinitionQuery eventSubscription(String eventType, String eventName) {
        if (eventName == null) {
            throw new ActivitiIllegalArgumentException("event name is null");
        }
        if (eventType == null) {
            throw new ActivitiException("event type is null");
        }
        this.eventSubscriptionType = eventType;
        this.eventSubscriptionName = eventName;
        return this;
    }

    public List<String> getAuthorizationGroups() {
        if (this.authorizationUserId != null) {
            List<Group> groups = Context.getCommandContext().getGroupIdentityManager().findGroupsByUser(this.authorizationUserId);
            ArrayList<String> groupIds = new ArrayList<String>();
            for (Group group : groups) {
                groupIds.add(group.getId());
            }
            return groupIds;
        }
        return null;
    }

    @Override
    public ProcessDefinitionQuery orderByDeploymentId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.DEPLOYMENT_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionKey() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionCategory() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_CATEGORY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionVersion() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_VERSION);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionName() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_NAME);
    }

    @Override
    public ProcessDefinitionQuery orderByTenantId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getProcessDefinitionEntityManager().findProcessDefinitionCountByQueryCriteria(this);
    }

    @Override
    public List<ProcessDefinition> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getProcessDefinitionEntityManager().findProcessDefinitionsByQueryCriteria(this, page);
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Set<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getVersionGt() {
        return this.versionGt;
    }

    public Integer getVersionGte() {
        return this.versionGte;
    }

    public Integer getVersionLt() {
        return this.versionLt;
    }

    public Integer getVersionLte() {
        return this.versionLte;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    @Override
    public ProcessDefinitionQueryImpl startableByUser(String userId) {
        if (userId == null) {
            throw new ActivitiIllegalArgumentException("userId is null");
        }
        this.authorizationUserId = userId;
        return this;
    }
}

