/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.runtime.Execution;

public class GetExecutionVariableInstanceCmd
implements Command<VariableInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String variableName;
    protected boolean isLocal;
    protected String locale;
    protected boolean withLocalizationFallback;

    public GetExecutionVariableInstanceCmd(String executionId, String variableName, boolean isLocal) {
        this.executionId = executionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    public GetExecutionVariableInstanceCmd(String executionId, String variableName, boolean isLocal, String locale, boolean withLocalizationFallback) {
        this.executionId = executionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
        this.locale = locale;
        this.withLocalizationFallback = withLocalizationFallback;
    }

    @Override
    public VariableInstance execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("executionId is null");
        }
        if (this.variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        VariableInstance variableEntity = null;
        variableEntity = this.isLocal ? execution.getVariableInstanceLocal(this.variableName, false) : execution.getVariableInstance(this.variableName, false);
        if (this.locale != null) {
            String localizedName = null;
            String localizedDescription = null;
            ObjectNode languageNode = Context.getLocalizationElementProperties(this.locale, this.variableName, execution.getProcessDefinitionId(), this.withLocalizationFallback);
            if (languageNode != null) {
                JsonNode descriptionNode;
                JsonNode nameNode = languageNode.get("name");
                if (nameNode != null) {
                    localizedName = nameNode.asText();
                }
                if ((descriptionNode = languageNode.get("description")) != null) {
                    localizedDescription = descriptionNode.asText();
                }
            }
            if (variableEntity != null) {
                variableEntity.setLocalizedName(localizedName);
                variableEntity.setLocalizedDescription(localizedDescription);
            }
        }
        return variableEntity;
    }
}

