/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.deploy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionInfoEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionInfoCache {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionInfoCache.class);
    protected Map<String, ProcessDefinitionInfoCacheObject> cache;
    protected CommandExecutor commandExecutor;

    public ProcessDefinitionInfoCache(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        this.cache = new HashMap<String, ProcessDefinitionInfoCacheObject>();
    }

    public ProcessDefinitionInfoCache(CommandExecutor commandExecutor, final int limit) {
        this.commandExecutor = commandExecutor;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<String, ProcessDefinitionInfoCacheObject>(limit + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ProcessDefinitionInfoCacheObject> eldest) {
                boolean removeEldest;
                boolean bl = removeEldest = this.size() > limit;
                if (removeEldest) {
                    logger.trace("Cache limit is reached, {} will be evicted", (Object)eldest.getKey());
                }
                return removeEldest;
            }
        });
    }

    public ProcessDefinitionInfoCacheObject get(final String processDefinitionId) {
        ProcessDefinitionInfoCacheObject infoCacheObject = null;
        if (this.cache.containsKey(processDefinitionId)) {
            infoCacheObject = this.commandExecutor.execute(new Command<ProcessDefinitionInfoCacheObject>(){

                @Override
                public ProcessDefinitionInfoCacheObject execute(CommandContext commandContext) {
                    ProcessDefinitionInfoEntityManager infoEntityManager = commandContext.getProcessDefinitionInfoEntityManager();
                    ObjectMapper objectMapper = commandContext.getProcessEngineConfiguration().getObjectMapper();
                    ProcessDefinitionInfoCacheObject cacheObject = ProcessDefinitionInfoCache.this.cache.get(processDefinitionId);
                    ProcessDefinitionInfoEntity infoEntity = infoEntityManager.findProcessDefinitionInfoByProcessDefinitionId(processDefinitionId);
                    if (infoEntity != null && infoEntity.getRevision() != cacheObject.getRevision()) {
                        cacheObject.setRevision(infoEntity.getRevision());
                        if (infoEntity.getInfoJsonId() != null) {
                            byte[] infoBytes = infoEntityManager.findInfoJsonById(infoEntity.getInfoJsonId());
                            try {
                                ObjectNode infoNode = (ObjectNode)objectMapper.readTree(infoBytes);
                                cacheObject.setInfoNode(infoNode);
                            }
                            catch (Exception e) {
                                throw new ActivitiException("Error reading json info node for process definition " + processDefinitionId, e);
                            }
                        }
                    } else if (infoEntity == null) {
                        cacheObject.setRevision(0);
                        cacheObject.setInfoNode(objectMapper.createObjectNode());
                    }
                    return cacheObject;
                }
            });
        }
        return infoCacheObject;
    }

    public void add(String id, ProcessDefinitionInfoCacheObject obj) {
        this.cache.put(id, obj);
    }

    public void remove(String id) {
        this.cache.remove(id);
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }
}

