/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ByteArrayRef;

public class UserEntity
implements User,
Serializable,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected String password;
    protected final ByteArrayRef pictureByteArrayRef = new ByteArrayRef();

    public UserEntity() {
    }

    public UserEntity(String id) {
        this.id = id;
    }

    public void delete() {
        Context.getCommandContext().getDbSqlSession().delete(this);
        this.deletePicture();
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("firstName", this.firstName);
        persistentState.put("lastName", this.lastName);
        persistentState.put("email", this.email);
        persistentState.put("password", this.password);
        persistentState.put("pictureByteArrayId", this.pictureByteArrayRef.getId());
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public Picture getPicture() {
        if (this.pictureByteArrayRef.getId() != null) {
            return new Picture(this.pictureByteArrayRef.getBytes(), this.pictureByteArrayRef.getName());
        }
        return null;
    }

    public void setPicture(Picture picture) {
        if (picture != null) {
            this.savePicture(picture);
        } else {
            this.deletePicture();
        }
    }

    protected void savePicture(Picture picture) {
        this.pictureByteArrayRef.setValue(picture.getMimeType(), picture.getBytes());
    }

    protected void deletePicture() {
        this.pictureByteArrayRef.delete();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public boolean isPictureSet() {
        return this.pictureByteArrayRef.getId() != null;
    }
}

