/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.session;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.http.netty.server.servlet.NettyHttpSession;
import org.apache.cxf.transport.http.netty.server.session.HttpSessionStore;

public class DefaultHttpSessionStore
implements HttpSessionStore {
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultHttpSessionStore.class);
    private static final Map<String, NettyHttpSession> SESSIONS = new ConcurrentHashMap<String, NettyHttpSession>();

    @Override
    public NettyHttpSession createSession() {
        String sessionId = this.generateNewSessionId();
        LOG.log(Level.FINE, "Creating new session with id {}", sessionId);
        NettyHttpSession session = new NettyHttpSession(sessionId);
        SESSIONS.put(sessionId, session);
        return session;
    }

    @Override
    public void destroySession(String sessionId) {
        LOG.log(Level.FINE, "Destroying session with id {}", sessionId);
        SESSIONS.remove(sessionId);
    }

    @Override
    public NettyHttpSession findSession(String sessionId) {
        if (SESSIONS == null) {
            return null;
        }
        return SESSIONS.get(sessionId);
    }

    protected String generateNewSessionId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public void destroyInactiveSessions() {
        for (Map.Entry<String, NettyHttpSession> entry : SESSIONS.entrySet()) {
            long currentMillis;
            NettyHttpSession session = entry.getValue();
            if (session.getMaxInactiveInterval() < 0 || (currentMillis = System.currentTimeMillis()) - session.getLastAccessedTime() <= (long)(session.getMaxInactiveInterval() * 1000)) continue;
            this.destroySession(entry.getKey());
        }
    }
}

