/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.bayeux;

import dojox.cometd.Bayeux;
import java.util.List;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.directwebremoting.Container;
import org.directwebremoting.bayeux.BayeuxClient;
import org.directwebremoting.dwrp.PlainCallHandler;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Remoter;

public class BayeuxServletContextAttributeListener
implements ServletContextAttributeListener {
    private BayeuxClient bayeuxHandler;
    private Remoter remoter;
    private ConverterManager converterManager;
    private PlainCallHandler plainCallHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeAdded(ServletContextAttributeEvent scab) {
        BayeuxServletContextAttributeListener bayeuxServletContextAttributeListener = this;
        synchronized (bayeuxServletContextAttributeListener) {
            if (this.bayeuxHandler == null && "dojox.cometd.bayeux".equals(scab.getName())) {
                Bayeux bayeux = (Bayeux)scab.getValue();
                this.bayeuxHandler = new BayeuxClient(bayeux);
                if (this.remoter != null) {
                    this.bayeuxHandler.setRemoter(this.remoter);
                }
                if (this.converterManager != null) {
                    this.bayeuxHandler.setConverterManager(this.converterManager);
                }
                if (this.plainCallHandler != null) {
                    this.bayeuxHandler.setPlainCallHandler(this.plainCallHandler);
                }
            }
            if ("org.directwebremoting.ContainerList".equals(scab.getName())) {
                List containers = (List)scab.getValue();
                for (Container container : containers) {
                    PlainCallHandler p;
                    ConverterManager c;
                    Remoter r = container.getBean(Remoter.class);
                    if (r != null) {
                        this.remoter = r;
                        if (this.bayeuxHandler != null) {
                            this.bayeuxHandler.setRemoter(this.remoter);
                        }
                    }
                    if ((c = container.getBean(ConverterManager.class)) != null) {
                        this.converterManager = c;
                        if (this.bayeuxHandler != null) {
                            this.bayeuxHandler.setConverterManager(this.converterManager);
                        }
                    }
                    if ((p = container.getBean(PlainCallHandler.class)) == null) continue;
                    this.plainCallHandler = p;
                    if (this.bayeuxHandler == null) continue;
                    this.bayeuxHandler.setPlainCallHandler(this.plainCallHandler);
                }
            }
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent scab) {
    }

    public void attributeReplaced(ServletContextAttributeEvent scab) {
    }
}

