/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.util.Currency;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrencyConverter
extends AbstractConverter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        try {
            Currency currency = Currency.getInstance(data.getValue());
            if (currency == null) {
                throw new IllegalArgumentException(data.getValue() + " is not a valid java.util.Currency value");
            }
            return currency;
        }
        catch (Exception ex) {
            throw new ConversionException(Currency.class, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        return new NonNestedOutboundVariable('\"' + ((Currency)data).getCurrencyCode() + '\"');
    }
}

