/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEnumAbstractBaseConverter
extends AbstractConverter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = LocalUtil.urlDecode(data.getValue());
        try {
            Method getter = paramType.getMethod("forString", String.class);
            Object bean = getter.invoke(paramType, value);
            if (bean == null) {
                throw new ConversionException(paramType, "unknown enum value (" + value + ")");
            }
            return bean;
        }
        catch (NoSuchMethodException e) {
            throw new ConversionException(paramType, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException(paramType, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException(paramType, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionException(paramType, (Throwable)e);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) {
        return new NonNestedOutboundVariable('\'' + data.toString() + '\'');
    }
}

