/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.Sleeper;

public class PlainScriptConduit
extends BaseScriptConduit {
    private static final Log log = LogFactory.getLog(PlainScriptConduit.class);

    public PlainScriptConduit(Sleeper sleeper, HttpServletResponse response, String instanceId, String batchId, ConverterManager converterManager, boolean jsonOutput) throws IOException {
        super(sleeper, response, instanceId, batchId, converterManager, jsonOutput);
    }

    protected String getOutboundMimeType() {
        return "text/javascript; charset=utf-8";
    }

    public void beginStream() {
    }

    public void endStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addScript(ScriptBuffer scriptBuffer) throws IOException, ConversionException {
        String script = ScriptBufferUtil.createOutput(scriptBuffer, this.converterManager, this.jsonOutput);
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Execution time: " + new Date().toString() + " - Writing to response: " + script));
            }
            this.out.println("//#DWR-START#");
            this.out.print(EnginePrivate.remoteBeginWrapper(this.instanceId, false));
            this.out.println(script);
            this.out.print(EnginePrivate.remoteEndWrapper(this.instanceId, false));
            this.out.println("//#DWR-END#");
            return this.flush();
        }
    }
}

