/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundContext;

public final class InboundVariable {
    private final InboundVariable[] members;
    private boolean dereferenced = false;
    private final InboundContext context;
    private String key;
    private String type;
    private FormField formField;

    public InboundVariable(InboundContext context, String key, String type, String value) {
        this(context, key, type, new FormField(value));
    }

    public InboundVariable(InboundContext context, String key, String type, FormField fileField) {
        this.context = context;
        this.key = key;
        this.type = type;
        this.members = null;
        this.formField = fileField;
    }

    public InboundVariable(InboundContext context) {
        this.context = context;
        this.key = null;
        this.type = "null";
        this.formField = null;
        this.members = null;
        this.dereferenced = true;
    }

    public InboundVariable(InboundContext context, InboundVariable[] members) {
        this.context = context;
        this.key = null;
        this.type = "varargs";
        this.formField = null;
        this.members = members;
        this.dereferenced = true;
    }

    public InboundContext getContext() {
        return this.context;
    }

    public void dereference() throws ConversionException {
        int depth = 0;
        while ("reference".equals(this.type)) {
            InboundVariable cd = this.context.getInboundVariable(this.formField.getString());
            if (cd == null) {
                throw new ConversionException(this.getClass(), "Found reference to variable named '" + this.formField.getString() + "', but no variable of that name could be found.");
            }
            this.type = cd.type;
            this.formField = cd.getFormField();
            this.key = cd.key;
            if (++depth <= 20) continue;
            throw new ConversionException(this.getClass(), "Max depth exceeded when dereferencing " + this.formField.getString());
        }
        this.dereferenced = true;
    }

    public String getNamedObjectType() {
        if (this.type.startsWith("Object_")) {
            return this.type.substring("Object_".length());
        }
        return null;
    }

    public boolean isNull() {
        return "null".equals(this.type);
    }

    public String getValue() {
        return this.formField.getString();
    }

    public FormField getFormField() {
        return this.formField;
    }

    public String getType() {
        return this.type;
    }

    public InboundVariable[] getMembers() {
        return this.members;
    }

    public String toString() {
        if (this.formField == null) {
            return this.type + ":" + "null";
        }
        return this.type + ":" + this.formField.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InboundVariable)) {
            return false;
        }
        InboundVariable that = (InboundVariable)obj;
        if (!this.dereferenced) {
            throw new IllegalStateException("this.equals() called before dereference()");
        }
        if (!that.dereferenced) {
            throw new IllegalStateException("that.equals() called before dereference()");
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.formField.equals(that.formField)) {
            return false;
        }
        return this.key != null && that.key != null;
    }

    public int hashCode() {
        if (!this.dereferenced) {
            throw new IllegalStateException("hashCode() called before dereference()");
        }
        int hash = 745;
        hash += this.formField == null ? 875 : this.formField.hashCode();
        hash += this.type == null ? 346 : this.type.hashCode();
        return hash += this.key == null ? 768 : this.key.hashCode();
    }
}

