/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.Method;
import java.util.Map;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.CallbackHelper;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.IdGenerator;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.ParameterProperty;
import org.directwebremoting.extend.RealRawData;
import org.directwebremoting.ui.Callback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCallbackHelper
implements CallbackHelper {
    private IdGenerator idGenerator;
    public static final String KEY_CALLBACK = "org.directwebremoting.callback";
    public static final String KEY_TYPE = "org.directwebremoting.type";

    @Override
    public <T> String saveCallback(Callback<T> callback, Class<T> type) {
        String key = this.createUniqueId();
        for (ScriptSession session : callback.getScriptSessions()) {
            Map callbackMap = (Map)session.getAttribute(KEY_CALLBACK);
            callbackMap.put(key, callback);
            session.setAttribute(KEY_CALLBACK, callbackMap);
            Map typeMap = (Map)session.getAttribute(KEY_TYPE);
            typeMap.put(key, type);
            session.setAttribute(KEY_TYPE, typeMap);
        }
        return key;
    }

    public static <T> void executeCallback(String key, RealRawData data) throws ConversionException {
        WebContext webContext = WebContextFactory.get();
        ScriptSession session = webContext.getScriptSession();
        ConverterManager converterManager = webContext.getContainer().getBean(ConverterManager.class);
        Map typeMap = (Map)session.getAttribute(KEY_TYPE);
        Class type = (Class)typeMap.remove(key);
        session.removeAttribute(KEY_TYPE);
        session.setAttribute(KEY_TYPE, typeMap);
        try {
            Method method = Callback.class.getMethod("dataReturned", type);
            ParameterProperty property = new ParameterProperty(new MethodDeclaration(method), 0);
            InboundVariable iv = data.getInboundVariable();
            Object callbackData = converterManager.convertInbound(type, iv, property);
            Map callbackMap = (Map)session.getAttribute(KEY_TYPE);
            Callback callback = (Callback)callbackMap.remove(key);
            session.removeAttribute(KEY_TYPE);
            session.setAttribute(KEY_CALLBACK, callbackMap);
            callback.dataReturned(callbackData);
        }
        catch (Exception ex) {
            throw new ConversionException(type, (Throwable)ex);
        }
    }

    public String createUniqueId() {
        return this.idGenerator.generate();
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

