/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.Alarm;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.Sleeper;

public class OutputAlarm
implements Alarm {
    private final Sleeper sleeper;
    protected final ScriptConduit conduit;
    protected final int maxWaitAfterWrite;
    protected final RealScriptSession scriptSession;
    protected ScheduledFuture<?> future;
    protected final ScheduledThreadPoolExecutor executor;
    private static final Log log = LogFactory.getLog(OutputAlarm.class);

    public OutputAlarm(Sleeper sleeper, RealScriptSession scriptSession, int maxWaitAfterWrite, ScheduledThreadPoolExecutor executor) {
        this.sleeper = sleeper;
        this.maxWaitAfterWrite = maxWaitAfterWrite;
        this.scriptSession = scriptSession;
        this.executor = executor;
        this.conduit = new AlarmScriptConduit();
        try {
            scriptSession.addScriptConduit(this.conduit);
        }
        catch (IOException ex) {
            log.warn((Object)"Error adding monitor to script session", (Throwable)ex);
        }
    }

    public void cancel() {
        this.scriptSession.removeScriptConduit(this.conduit);
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    protected class AlarmScriptConduit
    extends ScriptConduit {
        protected AlarmScriptConduit() {
            super(10, false);
        }

        public boolean addScript(ScriptBuffer script) {
            if (OutputAlarm.this.maxWaitAfterWrite <= 0) {
                OutputAlarm.this.sleeper.wakeUp();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        OutputAlarm.this.sleeper.wakeUp();
                    }
                };
                OutputAlarm.this.future = OutputAlarm.this.executor.schedule(runnable, (long)OutputAlarm.this.maxWaitAfterWrite, TimeUnit.MILLISECONDS);
            }
            return false;
        }
    }
}

