/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jms;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Hub;
import org.directwebremoting.HubFactory;
import org.directwebremoting.ServerContext;
import org.directwebremoting.event.MessageEvent;
import org.directwebremoting.event.MessageListener;
import org.directwebremoting.jms.BlockingMessageListener;
import org.directwebremoting.jms.DwrConnection;
import org.directwebremoting.jms.DwrMessage;
import org.directwebremoting.jms.DwrTopic;
import org.directwebremoting.jms.Unsupported;

public class DwrMessageConsumer
implements MessageConsumer {
    protected Hub hub;
    protected String messageSelector;
    protected Destination destination;
    protected boolean noLocal;
    protected javax.jms.MessageListener messageListener;
    private static final Log log = LogFactory.getLog(DwrMessageConsumer.class);

    public DwrMessageConsumer(DwrConnection connection, Destination destination) throws JMSException {
        this(connection, destination, null, false);
    }

    public DwrMessageConsumer(DwrConnection connection, Destination destination, String messageSelector) throws JMSException {
        this(connection, destination, messageSelector, false);
    }

    public DwrMessageConsumer(DwrConnection connection, Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.destination = destination;
        this.setMessageSelector(messageSelector);
        this.noLocal = noLocal;
        ServerContext serverContext = connection.getServerContext();
        this.hub = serverContext != null ? HubFactory.get(serverContext) : HubFactory.get();
        if (!(destination instanceof DwrTopic)) {
            throw new IllegalStateException("Unsuported Destination type (" + destination.getClass().getCanonicalName() + "). Only Topics are currently supported.");
        }
        DwrTopic topic = (DwrTopic)destination;
        String topicName = topic.getTopicName();
        this.hub.subscribe(topicName, new MessageListenerMessageListener());
    }

    public void close() throws JMSException {
    }

    public javax.jms.MessageListener getMessageListener() throws JMSException {
        return this.messageListener;
    }

    public void setMessageListener(javax.jms.MessageListener messageListener) throws JMSException {
        this.messageListener = messageListener;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
        if (messageSelector != null && messageSelector.length() != 0) {
            throw Unsupported.noMessageSelectors();
        }
    }

    public String getMessageSelector() throws JMSException {
        return this.messageSelector;
    }

    public Message receive() throws JMSException {
        javax.jms.MessageListener old = this.getMessageListener();
        BlockingMessageListener listener = new BlockingMessageListener();
        this.setMessageListener(listener);
        Message message = listener.receive(0L);
        this.setMessageListener(old);
        return message;
    }

    public Message receive(long timeout) throws JMSException {
        javax.jms.MessageListener old = this.getMessageListener();
        BlockingMessageListener listener = new BlockingMessageListener();
        this.setMessageListener(listener);
        Message message = listener.receive(timeout);
        this.setMessageListener(old);
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        log.warn((Object)"MessageConsumer.receiveNoWait() probably doesn't do what you need in a queue context");
        javax.jms.MessageListener old = this.getMessageListener();
        BlockingMessageListener listener = new BlockingMessageListener();
        this.setMessageListener(listener);
        Message message = listener.receive(1L);
        this.setMessageListener(old);
        return message;
    }

    public final class MessageListenerMessageListener
    implements MessageListener {
        public void onMessage(MessageEvent message) {
            if (DwrMessageConsumer.this.messageListener != null) {
                DwrMessageConsumer.this.messageListener.onMessage((Message)new DwrMessage(message.getHub(), message));
            }
        }
    }
}

